package net.consentmanager.cm_sdk_android_v3

import androidx.annotation.Keep

@Keep
object CMPConstants {
    object JavaScript {
        const val JAVASCRIPT_TO_EXECUTE = """
            (function() {
                window.cmpToSDK_sendStatus = function(consent, jsonObject) {
                    jsonObject.cmpString = consent;
                    AndroidSDK.postMessage('consent', JSON.stringify(jsonObject));
                };
                window.cmpToSDK_showConsentLayer = function() {
                    AndroidSDK.postMessage('open', 'true');
                };
                window.onerror = function(message, source, lineno, colno, error) {
                    AndroidSDK.postMessage('error', JSON.stringify({
                        message: message,
                        source: source,
                        lineno: lineno,
                        colno: colno,
                        error: error ? error.toString() : null
                    }));
                };
            })();
        """
    }
}