/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import androidx.annotation.Keep;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl;", "Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "prefs", "Landroid/content/SharedPreferences;", "getConsentData", "Lkotlin/Pair;", "", "getMetadataValue", "", "key", "resetConsentManagementData", "", "saveConsentData", "json", "consentString", "Companion", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nCMPUserPreferencesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMPUserPreferencesService.kt\nnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1855#2:108\n1856#2:110\n1#3:109\n*S KotlinDebug\n*F\n+ 1 CMPUserPreferencesService.kt\nnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl\n*L\n40#1:108\n40#1:110\n*E\n"})
public final class CMPUserPreferencesServiceImpl
implements CMPUserPreferencesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private static final String KEY_CONSENT_JSON = "consentJson";
    @NotNull
    private static final String KEY_CONSENT_STRING = "consentString";

    public CMPUserPreferencesServiceImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getDefaultSharedPreferences(...)");
        this.prefs = sharedPreferences;
    }

    @Override
    public void saveConsentData(@NotNull String json2, @NotNull String consentString) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)consentString, (String)KEY_CONSENT_STRING);
        try {
            SharedPreferences.Editor editor;
            JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(json2));
            SharedPreferences.Editor $this$saveConsentData_u24lambda_u243 = editor = this.prefs.edit();
            boolean bl = false;
            $this$saveConsentData_u24lambda_u243.putString(KEY_CONSENT_JSON, json2);
            $this$saveConsentData_u24lambda_u243.putString(KEY_CONSENT_STRING, consentString);
            JsonElement jsonElement = (JsonElement)jsonObject.get((Object)"metadata");
            if (jsonElement != null && (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) != null) {
                Iterable $this$forEach$iv = (Iterable)jsonElement;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement metadataItem = (JsonElement)element$iv;
                    boolean bl2 = false;
                    JsonObject metadata = JsonElementKt.getJsonObject((JsonElement)metadataItem);
                    Object object = (JsonElement)metadata.get((Object)"name");
                    if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) continue;
                    Object name = object;
                    JsonElement jsonElement2 = (JsonElement)metadata.get((Object)"type");
                    String type = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : null;
                    JsonElement jsonElement3 = (JsonElement)metadata.get((Object)"value");
                    JsonPrimitive value = jsonElement3 != null ? JsonElementKt.getJsonPrimitive((JsonElement)jsonElement3) : null;
                    String string = type;
                    if (Intrinsics.areEqual((Object)string, (Object)"int")) {
                        Object object2 = value;
                        if (object2 != null && (object2 = JsonElementKt.getIntOrNull((JsonPrimitive)object2)) != null) {
                            int it = ((Number)object2).intValue();
                            boolean bl3 = false;
                            $this$saveConsentData_u24lambda_u243.putInt((String)name, it);
                        }
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string, (Object)"string")) continue;
                    Object object3 = value;
                    if (object3 == null || (object3 = object3.getContent()) == null) continue;
                    Object it = object3;
                    boolean bl4 = false;
                    $this$saveConsentData_u24lambda_u243.putString((String)name, (String)it);
                }
            }
            editor.apply();
            Log.d((String)"CMPUserPrefsService", (String)"Consent data saved successfully");
        }
        catch (Exception e) {
            Log.e((String)"CMPUserPrefsService", (String)"Error saving consent data", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public Pair<String, String> getConsentData() {
        Pair pair;
        try {
            pair = new Pair((Object)this.prefs.getString(KEY_CONSENT_JSON, null), (Object)this.prefs.getString(KEY_CONSENT_STRING, null));
        }
        catch (Exception e) {
            Log.e((String)"CMPUserPrefsService", (String)"Error retrieving consent data", (Throwable)e);
            pair = new Pair(null, null);
        }
        return pair;
    }

    @Override
    @Nullable
    public Object getMetadataValue(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object object2;
            if (this.prefs.contains(key)) {
                try {
                    object = this.prefs.getInt(key, -1);
                    int it = ((Number)object).intValue();
                    boolean bl = false;
                    object = this.prefs.contains(key) ? object : null;
                }
                catch (ClassCastException e) {
                    String string;
                    try {
                        string = this.prefs.getString(key, null);
                    }
                    catch (ClassCastException e2) {
                        Boolean bl;
                        try {
                            bl = this.prefs.getBoolean(key, false);
                            boolean it = bl;
                            boolean bl2 = false;
                            bl = this.prefs.contains(key) ? bl : null;
                        }
                        catch (ClassCastException e3) {
                            bl = null;
                        }
                        string = bl;
                    }
                    object = string;
                }
                object2 = object;
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (Exception e) {
            Log.e((String)"CMPUserPrefsService", (String)("Error retrieving metadata value for key: " + key), (Throwable)e);
            object = null;
        }
        return object;
    }

    @Override
    public void resetConsentManagementData() {
        try {
            this.prefs.edit().clear().apply();
            Log.d((String)"CMPUserPrefsService", (String)"Consent data cleared successfully");
        }
        catch (Exception e) {
            Log.e((String)"CMPUserPrefsService", (String)"Error clearing consent data", (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl$Companion;", "", "()V", "KEY_CONSENT_JSON", "", "KEY_CONSENT_STRING", "cm-sdk-android-v3_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

