package net.consentmanager.java;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.webkit.WebView;

import net.consentmanager.cm_sdk_android_v3.CMPManager;
import net.consentmanager.cm_sdk_android_v3.CMPManagerDelegate;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerUIConfig;
import net.consentmanager.cm_sdk_android_v3.ConsentStatus;
import net.consentmanager.cm_sdk_android_v3.JavaFriendlyResult;
import net.consentmanager.cm_sdk_android_v3.OnClickLinkCallback;
import net.consentmanager.cm_sdk_android_v3.UrlConfig;
import net.consentmanager.cm_sdk_android_v3.UserConsentStatus;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

import kotlin.Unit;

public class JavaCMPManager {
    private final CMPManager cmpManager;
    private WebView webView;

    private JavaCMPManager(CMPManager cmpManager) {
        this.cmpManager = cmpManager;
    }

    public static JavaCMPManager getInstance(Context context, UrlConfig urlConfig, ConsentLayerUIConfig webViewConfig, CMPManagerDelegate delegate) {
        CMPManager kotlinManager = CMPManager.Companion.getInstance(context, urlConfig, webViewConfig, delegate);
        return new JavaCMPManager(kotlinManager);
    }

    public void setWebView(WebView webView) {
        this.webView = webView;
        // Re-initialize the WebView if needed
        if (cmpManager != null) {
            cmpManager.setWebView(webView);
        }
    }

    public void setActivity(Activity activity) {
        cmpManager.setActivity(activity);
    }

    /**
     * Gets the complete user consent status including all vendors and purposes.
     * This replaces multiple deprecated methods including hasUserChoice(), getAllPurposesIDs(), etc.
     */
    public UserConsentStatus getUserStatus() {
        return cmpManager.getUserStatus();
    }

    /**
     * Gets the consent status for a specific purpose.
     * Replaces hasPurposeConsent(String id)
     */
    public ConsentStatus getStatusForPurpose(String id) {
        return cmpManager.getStatusForPurpose(id);
    }

    /**
     * Gets the consent status for a specific vendor.
     * Replaces hasVendorConsent(String id)
     */
    public ConsentStatus getStatusForVendor(String id) {
        return cmpManager.getStatusForVendor(id);
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public boolean hasUserChoice() {
        return cmpManager.hasUserChoice();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public boolean hasPurposeConsent(String id) {
        return cmpManager.hasPurposeConsent(id);
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public boolean hasVendorConsent(String id) {
        return cmpManager.hasVendorConsent(id);
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public String exportCMPInfo() {
        return cmpManager.exportCMPInfo();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getAllPurposesIDs() {
        return cmpManager.getAllPurposesIDs();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getEnabledPurposesIDs() {
        return cmpManager.getEnabledPurposesIDs();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getDisabledPurposesIDs() {
        return cmpManager.getDisabledPurposesIDs();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getAllVendorsIDs() {
        return cmpManager.getAllVendorsIDs();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getEnabledVendorsIDs() {
        return cmpManager.getEnabledVendorsIDs();
    }

    /**
     * @deprecated Use {@link #getUserStatus()} instead
     */
    @Deprecated
    public List<String> getDisabledVendorsIDs() {
        return cmpManager.getDisabledVendorsIDs();
    }

    public void resetConsentManagementData() {
        cmpManager.resetConsentManagementData();
    }

    // Add this method to the JavaCMPManager class in JavaCMPManager.java

    /**
     * Returns a Map of consent settings compatible with Google Consent Mode v2.
     * This map can be directly passed to Firebase Analytics' setConsent method.
     *
     * @return Map<String, String> where keys are consent settings (analytics_storage, ad_storage, etc.)
     *         and values are "granted" or "denied"
     */
    public Map<String, String> getGoogleConsentModeSettings() {
        return cmpManager.getGoogleConsentModeStatus();
    }

    public void checkAndOpen(boolean jumpToSettings, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.checkAndOpen(jumpToSettings, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    /**
     * @deprecated Use {@link #checkAndOpen(boolean, Function)} instead
     */
    @Deprecated
    public void checkWithServerAndOpenIfNecessary(Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.checkWithServerAndOpenIfNecessary(result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    /**
     * @deprecated Use {@link #forceOpen(boolean, Function)} instead
     */
    @Deprecated
    public void openConsentLayer(Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.openConsentLayer(result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void forceOpen(boolean jumpToSettings, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.forceOpen(jumpToSettings, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void importCMPInfo(String cmpString, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.importCMPInfo(cmpString, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    /**
     * @deprecated Use {@link #checkAndOpen} instead
     */
    @Deprecated
    public void checkIfConsentIsRequired(Consumer<Boolean> completion) {
        cmpManager.checkIfConsentIsRequired(isRequired -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.accept(isRequired);
            }
            return Unit.INSTANCE;
        });
    }

    public void acceptVendors(List<String> vendors, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.acceptVendors(vendors, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void rejectVendors(List<String> vendors, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.rejectVendors(vendors, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void acceptPurposes(List<String> purposes, boolean updatePurpose, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.acceptPurposes(purposes, updatePurpose, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void rejectPurposes(List<String> purposes, boolean updateVendor, Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.rejectPurposes(purposes, updateVendor, result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void rejectAll(Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.rejectAll(result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void acceptAll(Function<JavaFriendlyResult<Unit>, Void> completion) {
        cmpManager.acceptAll(result -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                completion.apply(new JavaFriendlyResult<>(result));
            }
            return Unit.INSTANCE;
        });
    }

    public void onApplicationPause() {
        cmpManager.onApplicationPause();
    }

    public void onApplicationResume() {
        cmpManager.onApplicationResume();
    }

    public void onActivityDestroyed() {
        cmpManager.onActivityDestroyed();
    }

    public void setOnClickLinkCallback(OnClickLinkCallback callback) {
        cmpManager.setOnClickLinkCallback(callback);
    }

    public OnClickLinkCallback getOnClickLinkCallback() {
        return cmpManager.getOnClickLinkCallback();
    }}