/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Keep;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesService;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitor;
import net.consentmanager.cm_sdk_android_v3.RetryManager;
import net.consentmanager.cm_sdk_android_v3.UseCase;
import net.consentmanager.cm_sdk_android_v3.WebViewManagerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001HB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u0004\u0018\u00010\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0007J0\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00132\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u0015J\b\u0010-\u001a\u00020\u0018H\u0002J\u0019\u0010.\u001a\u00020\u00182\n\u0010/\u001a\u000601j\u0002`0H\u0002\u00a2\u0006\u0002\u00102J\u0018\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u000206H\u0002J\u001b\u00107\u001a\u00020\u00182\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u0018J\u001a\u0010;\u001a\u00020\u00182\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0015J\u0006\u0010<\u001a\u00020\u0017J\b\u0010=\u001a\u00020\u0018H\u0002J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\"H\u0002J\f\u0010@\u001a\u00020\u0001*\u00020AH\u0002J\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00010C2\u0006\u00105\u001a\u000206H\u0002J\f\u0010D\u001a\u00020\u0001*\u00020EH\u0002J\u000e\u0010F\u001a\u0004\u0018\u00010\u0001*\u00020AH\u0002J\u0018\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00010C*\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;", "", "userPreferences", "Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "networkMonitor", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;", "<init>", "(Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;Lkotlinx/coroutines/CoroutineScope;Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;)V", "delegate", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;", "getDelegate", "()Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;", "setDelegate", "(Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;)V", "webView", "Landroid/webkit/WebView;", "currentUseCase", "Lnet/consentmanager/cm_sdk_android_v3/UseCase;", "completionHandler", "Lkotlin/Function1;", "Lkotlin/Result;", "", "", "retryManager", "Lnet/consentmanager/cm_sdk_android_v3/RetryManager;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "json$delegate", "Lkotlin/Lazy;", "currentUrl", "", "createWebViewClient", "Landroid/webkit/WebViewClient;", "createWebView", "activityRef", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "loadConsentURL", "url", "useCase", "completion", "injectJavaScript", "handleFailure", "error", "Lkotlin/Exception;", "Ljava/lang/Exception;", "(Ljava/lang/Exception;)V", "handleConsentReceived", "consent", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "executeCompletion", "result", "(Ljava/lang/Object;)V", "cancelOperations", "performRetry", "isWebViewDestroyed", "handleOpenMessage", "handleConsentMessage", "message", "toAny", "Lkotlinx/serialization/json/JsonElement;", "convertJsonObjectToMap", "", "convertPrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "convertElement", "toMap", "JavaScriptInterface", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nWebViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewManager.kt\nnet/consentmanager/cm_sdk_android_v3/WebViewManager\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,310:1\n113#2:311\n1557#3:312\n1628#3,3:313\n1557#3:317\n1628#3,3:318\n1557#3:322\n1628#3,3:323\n1187#3,2:326\n1261#3,4:328\n216#4:316\n217#4:321\n*S KotlinDebug\n*F\n+ 1 WebViewManager.kt\nnet/consentmanager/cm_sdk_android_v3/WebViewManager\n*L\n155#1:311\n265#1:312\n265#1:313,3\n282#1:317\n282#1:318,3\n301#1:322\n301#1:323,3\n305#1:326,2\n305#1:328,4\n278#1:316\n278#1:321\n*E\n"})
public final class WebViewManager {
    @NotNull
    private final CMPUserPreferencesService userPreferences;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final NetworkMonitor networkMonitor;
    @Nullable
    private WebViewManagerDelegate delegate;
    @Nullable
    private WebView webView;
    @Nullable
    private UseCase currentUseCase;
    @Nullable
    private Function1<? super Result<Boolean>, Unit> completionHandler;
    @Nullable
    private RetryManager retryManager;
    @NotNull
    private final Lazy json$delegate;
    @Nullable
    private String currentUrl;

    public WebViewManager(@NotNull CMPUserPreferencesService userPreferences, @NotNull CoroutineScope coroutineScope, @NotNull NetworkMonitor networkMonitor) {
        Intrinsics.checkNotNullParameter((Object)userPreferences, (String)"userPreferences");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)networkMonitor, (String)"networkMonitor");
        this.userPreferences = userPreferences;
        this.coroutineScope = coroutineScope;
        this.networkMonitor = networkMonitor;
        this.json$delegate = LazyKt.lazy(WebViewManager::json_delegate$lambda$1);
    }

    public /* synthetic */ WebViewManager(CMPUserPreferencesService cMPUserPreferencesService, CoroutineScope coroutineScope, NetworkMonitor networkMonitor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        }
        this(cMPUserPreferencesService, coroutineScope, networkMonitor);
    }

    @Nullable
    public final WebViewManagerDelegate getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@Nullable WebViewManagerDelegate webViewManagerDelegate) {
        this.delegate = webViewManagerDelegate;
    }

    private final Json getJson() {
        Lazy lazy = this.json$delegate;
        return (Json)lazy.getValue();
    }

    private final WebViewClient createWebViewClient() {
        return new WebViewClient(this){
            final /* synthetic */ WebViewManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                Log.d((String)"CMPWebViewManager", (String)("Page started loading: " + url));
            }

            public void onPageFinished(WebView view, String url) {
                Log.d((String)"CMPWebViewManager", (String)("Page finished loading: " + url));
                WebViewManager.access$injectJavaScript(this.this$0);
            }

            @Deprecated(message="Deprecated in Java")
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean bl;
                if (url == null) {
                    return false;
                }
                try {
                    Object object = this.this$0.getDelegate();
                    bl = object != null && (object = object.getOnClickLinkCallback()) != null ? object.onClickLink(url) : false;
                }
                catch (Exception e) {
                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                    if (webViewManagerDelegate != null) {
                        webViewManagerDelegate.didReceiveError("Error handling URL: " + e.getMessage());
                    }
                    bl = false;
                }
                return bl;
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                block0: {
                    WebResourceError webResourceError = error;
                    Log.e((String)"WebViewManager", (String)("Error loading page: " + (webResourceError != null ? webResourceError.getDescription() : null)));
                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                    if (webViewManagerDelegate == null) break block0;
                    WebResourceError webResourceError2 = error;
                    webViewManagerDelegate.didReceiveError("Error loading page: " + (webResourceError2 != null ? webResourceError2.getDescription() : null));
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"SetJavaScriptEnabled"})
    @Nullable
    public final WebView createWebView(@NotNull WeakReference<Activity> activityRef) {
        block5: {
            void $this$createWebView_u24lambda_u242;
            WebView webView;
            Activity activity;
            block4: {
                Intrinsics.checkNotNullParameter(activityRef, (String)"activityRef");
                Log.d((String)"CMPWebViewManager", (String)"Creating WebView");
                activity = (Activity)activityRef.get();
                if (activity == null) {
                    Log.e((String)"CMPWebViewManager", (String)"Activity reference is null, cannot create WebView");
                    return null;
                }
                if (this.webView == null) break block4;
                WebView webView2 = this.webView;
                boolean bl = webView2 != null ? !webView2.isAttachedToWindow() : false;
                if (!bl) break block5;
            }
            WebView webView3 = webView = new WebView((Context)activity);
            WebViewManager webViewManager = this;
            boolean bl = false;
            $this$createWebView_u24lambda_u242.getSettings().setJavaScriptEnabled(true);
            $this$createWebView_u24lambda_u242.getSettings().setDomStorageEnabled(true);
            $this$createWebView_u24lambda_u242.addJavascriptInterface((Object)new JavaScriptInterface(), "AndroidSDK");
            $this$createWebView_u24lambda_u242.setWebViewClient(this.createWebViewClient());
            webViewManager.webView = webView;
        }
        return this.webView;
    }

    public final void loadConsentURL(@NotNull String url, @NotNull UseCase useCase, @NotNull Function1<? super Result<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)useCase), (String)"useCase");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        try {
            Log.d((String)"CMPWebViewManager", (String)("Loading URL: " + url));
            this.currentUrl = url;
            this.currentUseCase = useCase;
            this.completionHandler = completion;
            WebView webView = this.webView;
            if (webView != null) {
                webView.loadUrl(url);
            }
        }
        catch (Exception e) {
            Log.e((String)"CMPWebViewManager", (String)"Error loading consent URL", (Throwable)e);
            WebViewManagerDelegate webViewManagerDelegate = this.delegate;
            if (webViewManagerDelegate != null) {
                webViewManagerDelegate.didReceiveError("Failed to load URL: " + e.getMessage());
            }
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
        }
    }

    private final void injectJavaScript() {
        block0: {
            Log.d((String)"CMPWebViewManager", (String)"Injecting JavaScript");
            WebView webView = this.webView;
            if (webView == null) break block0;
            webView.evaluateJavascript("\n            (function() {\n                window.cmpToSDK_sendStatus = function(consent, jsonObject) {\n                    jsonObject.cmpString = consent;\n                    AndroidSDK.postMessage('consent', JSON.stringify(jsonObject));\n                };\n                window.cmpToSDK_showConsentLayer = function() {\n                    AndroidSDK.postMessage('open', 'true');\n                };\n                window.onerror = function(message, source, lineno, colno, error) {\n                    AndroidSDK.postMessage('error', JSON.stringify({\n                        message: message,\n                        source: source,\n                        lineno: lineno,\n                        colno: colno,\n                        error: error ? error.toString() : null\n                    }));\n                };\n            })();\n        ", arg_0 -> WebViewManager.injectJavaScript$lambda$4(this, arg_0));
        }
    }

    private final void handleFailure(Exception error) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, error, null){
            int label;
            final /* synthetic */ WebViewManager this$0;
            final /* synthetic */ Exception $error;
            {
                this.this$0 = $receiver;
                this.$error = $error;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                        if (webViewManagerDelegate != null) {
                            String string = this.$error.getMessage();
                            if (string == null) {
                                string = "Unknown error occurred";
                            }
                            webViewManagerDelegate.didReceiveError(string);
                        }
                        WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.$error)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void handleConsentReceived(String consent, JsonObject jsonObject) {
        block3: {
            try {
                StringFormat $this$encodeToString$iv = (StringFormat)this.getJson();
                boolean $i$f$encodeToString = false;
                $this$encodeToString$iv.getSerializersModule();
                String jsonString = $this$encodeToString$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)jsonObject);
                this.userPreferences.saveConsentData(jsonString, consent);
                WebViewManagerDelegate webViewManagerDelegate = this.delegate;
                if (webViewManagerDelegate != null) {
                    webViewManagerDelegate.didReceiveConsentMessage(consent, this.toMap(jsonObject));
                }
                Function1<? super Result<Boolean>, Unit> function1 = this.completionHandler;
                if (function1 == null) break block3;
                function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)false)));
            }
            catch (Exception e) {
                WebViewManagerDelegate webViewManagerDelegate = this.delegate;
                if (webViewManagerDelegate == null) break block3;
                webViewManagerDelegate.didReceiveError("Error handling consent: " + e.getMessage());
            }
        }
    }

    private final void executeCompletion(Object result) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
            int label;
            final /* synthetic */ WebViewManager this$0;
            final /* synthetic */ Object $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Function1 function1 = WebViewManager.access$getCompletionHandler$p(this.this$0);
                        if (function1 != null) {
                            function1.invoke((Object)Result.box-impl((Object)this.$result));
                        }
                        WebViewManager.access$setCompletionHandler$p(this.this$0, null);
                        WebViewManager.access$setCurrentUseCase$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void cancelOperations() {
        try {
            WebView webView = this.webView;
            if (webView != null) {
                webView.stopLoading();
            }
            Function1<? super Result<Boolean>, Unit> function1 = this.completionHandler;
            if (function1 != null) {
                function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Operation cancelled")))));
            }
            this.completionHandler = null;
            this.currentUseCase = null;
            RetryManager retryManager = this.retryManager;
            if (retryManager != null) {
                retryManager.reset();
            }
        }
        catch (Exception e) {
            Log.e((String)"CMPWebViewManager", (String)"Error cancelling operations", (Throwable)e);
        }
    }

    public final void performRetry(@NotNull Function1<? super Boolean, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        try {
            WebView webView = this.webView;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(webView, completion, null){
                int label;
                final /* synthetic */ WebView $webView;
                final /* synthetic */ Function1<Boolean, Unit> $completion;
                {
                    this.$webView = $webView;
                    this.$completion = $completion;
                    super(2, $completion2);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (this.$webView != null) {
                                String string = this.$webView.getUrl();
                                if (string != null) {
                                    String string2 = string;
                                    WebView webView = this.$webView;
                                    Function1<Boolean, Unit> function1 = this.$completion;
                                    String url = string2;
                                    boolean bl = false;
                                    webView.loadUrl(url);
                                    function1.invoke((Object)Boxing.boxBoolean((boolean)true));
                                } else {
                                    this.$completion.invoke((Object)Boxing.boxBoolean((boolean)false));
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (Exception e) {
            Log.e((String)"CMPWebViewManager", (String)"Retry failed", (Throwable)e);
            completion.invoke((Object)false);
        }
    }

    public final boolean isWebViewDestroyed() {
        return this.webView == null;
    }

    private final void handleOpenMessage() {
        block7: {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                WebViewManager $this$handleOpenMessage_u24lambda_u246 = object2;
                boolean bl = false;
                Log.d((String)"CMPWebViewManager", (String)"Received open message");
                if ($this$handleOpenMessage_u24lambda_u246.currentUseCase == UseCase.CHECK_CONSENT || $this$handleOpenMessage_u24lambda_u246.currentUseCase == UseCase.PERFORM_DRY_CHECK_CONSENT) {
                    $this$handleOpenMessage_u24lambda_u246.executeCompletion(Result.constructor-impl((Object)true));
                    unit = Unit.INSTANCE;
                } else {
                    $this$handleOpenMessage_u24lambda_u246.executeCompletion(Result.constructor-impl((Object)false));
                    WebViewManagerDelegate webViewManagerDelegate = $this$handleOpenMessage_u24lambda_u246.delegate;
                    if (webViewManagerDelegate != null) {
                        webViewManagerDelegate.didReceiveOpenMessage();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block7;
            Object e = object = throwable;
            boolean bl = false;
            Log.e((String)"WebViewManager", (String)"Consent message processing failed", (Throwable)e);
            WebViewManagerDelegate webViewManagerDelegate = this.delegate;
            if (webViewManagerDelegate != null) {
                webViewManagerDelegate.didReceiveError("Consent processing error: " + ((Throwable)e).getMessage());
            }
        }
    }

    private final void handleConsentMessage(String message) {
        block6: {
            Object object;
            Object object2 = this;
            try {
                WebViewManager $this$handleConsentMessage_u24lambda_u248 = object2;
                boolean bl = false;
                Log.d((String)"CMPWebViewManager", (String)"Received consent message");
                JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)$this$handleConsentMessage_u24lambda_u248.getJson().parseToJsonElement(message));
                Object object3 = (JsonElement)jsonObject.get((Object)"cmpString");
                if (object3 == null || (object3 = object3.toString()) == null) {
                    throw new IllegalArgumentException("Invalid consent format");
                }
                Object consent = object3;
                UseCase useCase = $this$handleConsentMessage_u24lambda_u248.currentUseCase;
                if ((useCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[useCase.ordinal()]) == 1) {
                    $this$handleConsentMessage_u24lambda_u248.executeCompletion(Result.constructor-impl((Object)false));
                } else {
                    $this$handleConsentMessage_u24lambda_u248.handleConsentReceived((String)consent, jsonObject);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object e = object = throwable;
            boolean bl = false;
            Log.e((String)"WebViewManager", (String)"Consent message processing failed", (Throwable)e);
            WebViewManagerDelegate webViewManagerDelegate = this.delegate;
            if (webViewManagerDelegate != null) {
                webViewManagerDelegate.didReceiveError("Consent processing error: " + ((Throwable)e).getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object toAny(JsonElement $this$toAny) {
        Object object;
        JsonElement jsonElement = $this$toAny;
        if (jsonElement instanceof JsonObject) {
            object = this.toMap((JsonObject)$this$toAny);
        } else if (jsonElement instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$toAny;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toAny((JsonElement)it));
            }
            object = (List)destination$iv$iv;
        } else if (jsonElement instanceof JsonPrimitive) {
            object = ((JsonPrimitive)$this$toAny).isString() ? ((JsonPrimitive)$this$toAny).getContent() : (JsonElementKt.getIntOrNull((JsonPrimitive)((JsonPrimitive)$this$toAny)) != null ? Integer.valueOf(JsonElementKt.getInt((JsonPrimitive)((JsonPrimitive)$this$toAny))) : (JsonElementKt.getBooleanOrNull((JsonPrimitive)((JsonPrimitive)$this$toAny)) != null ? Boolean.valueOf(JsonElementKt.getBoolean((JsonPrimitive)((JsonPrimitive)$this$toAny))) : (JsonElementKt.getDoubleOrNull((JsonPrimitive)((JsonPrimitive)$this$toAny)) != null ? Double.valueOf(JsonElementKt.getDouble((JsonPrimitive)((JsonPrimitive)$this$toAny))) : ((JsonPrimitive)$this$toAny).getContent())));
        } else if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            object = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> convertJsonObjectToMap(JsonObject jsonObject) {
        Map map;
        Map $this$convertJsonObjectToMap_u24lambda_u2413 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Map $this$forEach$iv = (Map)jsonObject;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            Map map2 = $this$convertJsonObjectToMap_u24lambda_u2413;
            String string = key;
            JsonElement jsonElement = element;
            if (jsonElement instanceof JsonPrimitive) {
                object = this.convertPrimitive((JsonPrimitive)element);
            } else if (jsonElement instanceof JsonObject) {
                object = this.convertJsonObjectToMap((JsonObject)element);
            } else if (jsonElement instanceof JsonArray) {
                Collection<Object> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)element;
                String string2 = string;
                Map map3 = map2;
                boolean $i$f$map = false;
                void var18_18 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.convertElement((JsonElement)it));
                }
                collection = (List)destination$iv$iv;
                map2 = map3;
                string = string2;
                object = collection;
            } else if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
                object = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JsonNull jsonNull = object;
            if (object == null) {
                jsonNull = JsonNull.INSTANCE;
            }
            map2.put(string, jsonNull);
        }
        return MapsKt.build((Map)map);
    }

    private final Object convertPrimitive(JsonPrimitive $this$convertPrimitive) {
        return $this$convertPrimitive.isString() ? $this$convertPrimitive.getContent() : (JsonElementKt.getIntOrNull((JsonPrimitive)$this$convertPrimitive) != null ? Integer.valueOf(JsonElementKt.getInt((JsonPrimitive)$this$convertPrimitive)) : (JsonElementKt.getLongOrNull((JsonPrimitive)$this$convertPrimitive) != null ? Long.valueOf(JsonElementKt.getLong((JsonPrimitive)$this$convertPrimitive)) : (JsonElementKt.getDoubleOrNull((JsonPrimitive)$this$convertPrimitive) != null ? Double.valueOf(JsonElementKt.getDouble((JsonPrimitive)$this$convertPrimitive)) : (JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$convertPrimitive) != null ? Boolean.valueOf(JsonElementKt.getBoolean((JsonPrimitive)$this$convertPrimitive)) : $this$convertPrimitive.getContent()))));
    }

    /*
     * WARNING - void declaration
     */
    private final Object convertElement(JsonElement $this$convertElement) {
        Object object;
        JsonElement jsonElement = $this$convertElement;
        if (jsonElement instanceof JsonPrimitive) {
            object = this.convertPrimitive((JsonPrimitive)$this$convertElement);
        } else if (jsonElement instanceof JsonObject) {
            object = this.convertJsonObjectToMap((JsonObject)$this$convertElement);
        } else if (jsonElement instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$convertElement;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertElement((JsonElement)it));
            }
            object = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toMap(JsonObject $this$toMap) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $this$toMap.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            entry = TuplesKt.to((Object)key, (Object)this.toAny(value));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Unit json_delegate$lambda$1$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    private static final Json json_delegate$lambda$1() {
        return JsonKt.Json$default(null, WebViewManager::json_delegate$lambda$1$lambda$0, (int)1, null);
    }

    private static final Unit injectJavaScript$lambda$4$lambda$3(WebViewManager this$0, boolean success) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!success) {
            this$0.handleFailure(new Exception("Failed to inject JavaScript"));
        }
        return Unit.INSTANCE;
    }

    private static final void injectJavaScript$lambda$4(WebViewManager this$0, String result) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Log.d((String)"CMPWebViewManager", (String)("JavaScript injection result: " + result));
                if (!Intrinsics.areEqual((Object)result, (Object)"null")) break block0;
                Log.d((String)"CMPWebViewManager", (String)"JavaScript injected successfully.");
                RetryManager retryManager = this$0.retryManager;
                if (retryManager == null) break block1;
                retryManager.reset();
                break block1;
            }
            Log.d((String)"CMPWebViewManager", (String)("Error injecting JavaScript: " + result));
            RetryManager retryManager = this$0.retryManager;
            if (retryManager == null) break block1;
            retryManager.retry((Function1<? super Boolean, Unit>)((Function1)arg_0 -> WebViewManager.injectJavaScript$lambda$4$lambda$3(this$0, arg_0)));
        }
    }

    public static final /* synthetic */ void access$injectJavaScript(WebViewManager $this) {
        $this.injectJavaScript();
    }

    public static final /* synthetic */ void access$executeCompletion(WebViewManager $this, Object result) {
        $this.executeCompletion(result);
    }

    public static final /* synthetic */ Function1 access$getCompletionHandler$p(WebViewManager $this) {
        return $this.completionHandler;
    }

    public static final /* synthetic */ void access$setCompletionHandler$p(WebViewManager $this, Function1 function1) {
        $this.completionHandler = function1;
    }

    public static final /* synthetic */ void access$setCurrentUseCase$p(WebViewManager $this, UseCase useCase) {
        $this.currentUseCase = useCase;
    }

    public static final /* synthetic */ void access$handleConsentMessage(WebViewManager $this, String message) {
        $this.handleConsentMessage(message);
    }

    public static final /* synthetic */ void access$handleOpenMessage(WebViewManager $this) {
        $this.handleOpenMessage();
    }

    public static final /* synthetic */ RetryManager access$getRetryManager$p(WebViewManager $this) {
        return $this.retryManager;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/WebViewManager$JavaScriptInterface;", "", "<init>", "(Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;)V", "postMessage", "", "type", "", "message", "cm-sdk-android-v3_release"})
    public final class JavaScriptInterface {
        @JavascriptInterface
        public final void postMessage(@NotNull String type, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.d((String)"CMPWebViewManager", (String)("Received message: type=" + type + ", message=" + message));
            BuildersKt.launch$default((CoroutineScope)WebViewManager.this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(type, WebViewManager.this, message, null){
                int label;
                final /* synthetic */ String $type;
                final /* synthetic */ WebViewManager this$0;
                final /* synthetic */ String $message;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    this.$message = $message;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            switch (this.$type) {
                                case "consent": {
                                    WebViewManager.access$handleConsentMessage(this.this$0, this.$message);
                                    break;
                                }
                                case "open": {
                                    WebViewManager.access$handleOpenMessage(this.this$0);
                                    break;
                                }
                                case "error": {
                                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                                    if (webViewManagerDelegate != null) {
                                        webViewManagerDelegate.didReceiveError(this.$message);
                                    }
                                    WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception(this.$message))));
                                    break;
                                }
                                default: {
                                    Boxing.boxInt((int)Log.w((String)"WebViewManager", (String)("Unknown message type: " + this.$type)));
                                }
                            }
                            RetryManager retryManager = WebViewManager.access$getRetryManager$p(this.this$0);
                            if (retryManager != null) {
                                retryManager.reset();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UseCase.values().length];
            try {
                nArray[UseCase.PERFORM_DRY_CHECK_CONSENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

