/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.Keep;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerUIConfig;
import net.consentmanager.cm_sdk_android_v3.DefaultDialogFactory;
import net.consentmanager.cm_sdk_android_v3.DialogFactory;
import net.consentmanager.cm_sdk_android_v3.WebViewContainer;
import net.consentmanager.cm_sdk_android_v3.WebViewManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0002J$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0002J\f\u0010\u001b\u001a\u00020\u0011*\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0017J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "activity", "Landroid/app/Activity;", "config", "Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;", "webViewContainer", "Lnet/consentmanager/cm_sdk_android_v3/WebViewContainer;", "webViewManager", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;", "dialogFactory", "Lnet/consentmanager/cm_sdk_android_v3/DialogFactory;", "<init>", "(Landroid/app/Activity;Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;Lnet/consentmanager/cm_sdk_android_v3/WebViewContainer;Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;Lnet/consentmanager/cm_sdk_android_v3/DialogFactory;)V", "dialog", "Landroid/app/Dialog;", "show", "", "createRootLayout", "Landroidx/constraintlayout/widget/ConstraintLayout;", "createContainerBackground", "Landroid/graphics/drawable/GradientDrawable;", "isTop", "", "isFullScreen", "setupContainer", "rootLayout", "applyBackgroundStyle", "Landroid/view/Window;", "dismiss", "isShowing", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "Companion", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nConsentLayerDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentLayerDialog.kt\nnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog\n+ 2 ColorDrawable.kt\nandroidx/core/graphics/drawable/ColorDrawableKt\n*L\n1#1,208:1\n28#2:209\n28#2:210\n28#2:211\n28#2:212\n*S KotlinDebug\n*F\n+ 1 ConsentLayerDialog.kt\nnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog\n*L\n46#1:209\n186#1:210\n189#1:211\n192#1:212\n*E\n"})
public final class ConsentLayerDialog
implements DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final ConsentLayerUIConfig config;
    @NotNull
    private final WebViewContainer webViewContainer;
    @NotNull
    private final WebViewManager webViewManager;
    @NotNull
    private final DialogFactory dialogFactory;
    @Nullable
    private Dialog dialog;
    private static final float CONTAINER_ELEVATION = 8.0f;

    public ConsentLayerDialog(@NotNull Activity activity, @NotNull ConsentLayerUIConfig config, @NotNull WebViewContainer webViewContainer, @NotNull WebViewManager webViewManager, @NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)webViewContainer, (String)"webViewContainer");
        Intrinsics.checkNotNullParameter((Object)webViewManager, (String)"webViewManager");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.activity = activity;
        this.config = config;
        this.webViewContainer = webViewContainer;
        this.webViewManager = webViewManager;
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ ConsentLayerDialog(Activity activity, ConsentLayerUIConfig consentLayerUIConfig, WebViewContainer webViewContainer, WebViewManager webViewManager, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            dialogFactory = new DefaultDialogFactory();
        }
        this(activity, consentLayerUIConfig, webViewContainer, webViewManager, dialogFactory);
    }

    /*
     * WARNING - void declaration
     */
    public final void show() {
        void $this$show_u24lambda_u242;
        Dialog dialog;
        this.dismiss();
        Dialog dialog2 = dialog = this.dialogFactory.createDialog(this.activity);
        ConsentLayerDialog consentLayerDialog = this;
        boolean bl = false;
        ConstraintLayout rootLayout = this.createRootLayout();
        $this$show_u24lambda_u242.setContentView((View)rootLayout);
        $this$show_u24lambda_u242.setCancelable(this.config.isCancelable());
        Window window = $this$show_u24lambda_u242.getWindow();
        if (window != null) {
            ConsentLayerUIConfig.Position position;
            Window window2;
            Window $this$show_u24lambda_u242_u24lambda_u240 = window2 = window;
            boolean bl2 = false;
            $this$show_u24lambda_u242_u24lambda_u240.setLayout(-1, -1);
            int $this$toDrawable$iv = 0;
            boolean $i$f$toDrawable = false;
            $this$show_u24lambda_u242_u24lambda_u240.setBackgroundDrawable((Drawable)new ColorDrawable($this$toDrawable$iv));
            this.applyBackgroundStyle($this$show_u24lambda_u242_u24lambda_u240);
            if (Build.VERSION.SDK_INT >= 30) {
                WindowCompat.setDecorFitsSystemWindows((Window)$this$show_u24lambda_u242_u24lambda_u240, (boolean)false);
            }
            if (Intrinsics.areEqual((Object)(position = this.config.getPosition()), (Object)ConsentLayerUIConfig.Position.HALF_SCREEN_BOTTOM)) {
                $this$show_u24lambda_u242_u24lambda_u240.setGravity(80);
                ConsentLayerDialog.setupContainer$default(this, rootLayout, false, false, 4, null);
            } else if (Intrinsics.areEqual((Object)position, (Object)ConsentLayerUIConfig.Position.HALF_SCREEN_TOP)) {
                $this$show_u24lambda_u242_u24lambda_u240.setGravity(48);
                ConsentLayerDialog.setupContainer$default(this, rootLayout, true, false, 4, null);
            } else {
                $this$show_u24lambda_u242_u24lambda_u240.setGravity(17);
                ConsentLayerDialog.setupContainer$default(this, rootLayout, false, true, 2, null);
            }
        }
        $this$show_u24lambda_u242.setOnDismissListener(ConsentLayerDialog::show$lambda$2$lambda$1);
        $this$show_u24lambda_u242.show();
        consentLayerDialog.dialog = dialog;
        if (this.activity instanceof LifecycleOwner) {
            ((LifecycleOwner)this.activity).getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    private final ConstraintLayout createRootLayout() {
        ConstraintLayout constraintLayout;
        ConstraintLayout $this$createRootLayout_u24lambda_u243 = constraintLayout = new ConstraintLayout((Context)this.activity);
        boolean bl = false;
        $this$createRootLayout_u24lambda_u243.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        $this$createRootLayout_u24lambda_u243.setId(View.generateViewId());
        return constraintLayout;
    }

    private final GradientDrawable createContainerBackground(boolean isTop, boolean isFullScreen) {
        GradientDrawable gradientDrawable;
        GradientDrawable $this$createContainerBackground_u24lambda_u244 = gradientDrawable = new GradientDrawable();
        boolean bl = false;
        if (!isFullScreen) {
            float[] fArray;
            if (isTop) {
                float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.config.getCornerRadius(), this.config.getCornerRadius(), this.config.getCornerRadius(), this.config.getCornerRadius()};
                fArray = fArray2;
            } else {
                float[] fArray3 = new float[]{this.config.getCornerRadius(), this.config.getCornerRadius(), this.config.getCornerRadius(), this.config.getCornerRadius(), 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray3;
            }
            $this$createContainerBackground_u24lambda_u244.setCornerRadii(fArray);
        } else {
            $this$createContainerBackground_u24lambda_u244.setCornerRadius(this.config.getCornerRadius());
        }
        $this$createContainerBackground_u24lambda_u244.setColor(-1);
        return gradientDrawable;
    }

    static /* synthetic */ GradientDrawable createContainerBackground$default(ConsentLayerDialog consentLayerDialog, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return consentLayerDialog.createContainerBackground(bl, bl2);
    }

    private final void setupContainer(ConstraintLayout rootLayout, boolean isTop, boolean isFullScreen) {
        ConstraintLayout.LayoutParams layoutParams;
        FrameLayout container = this.webViewContainer.createContainer((Context)this.activity);
        if (isFullScreen) {
            ConstraintLayout.LayoutParams layoutParams2 = layoutParams = new ConstraintLayout.LayoutParams(-1, -1);
            FrameLayout frameLayout = container;
            boolean bl = false;
            $this$setupContainer_u24lambda_u245.topToTop = 0;
            $this$setupContainer_u24lambda_u245.bottomToBottom = 0;
            $this$setupContainer_u24lambda_u245.startToStart = 0;
            $this$setupContainer_u24lambda_u245.endToEnd = 0;
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.config.getRespectsSafeArea()) {
                ViewCompat.setOnApplyWindowInsetsListener((View)((View)container), ConsentLayerDialog::setupContainer$lambda$6);
            }
        } else {
            ConstraintLayout.LayoutParams $this$setupContainer_u24lambda_u245 = layoutParams = new ConstraintLayout.LayoutParams(-1, this.activity.getResources().getDisplayMetrics().heightPixels / 2);
            FrameLayout frameLayout = container;
            boolean bl = false;
            if (isTop) {
                $this$setupContainer_u24lambda_u247.topToTop = 0;
            } else {
                $this$setupContainer_u24lambda_u247.bottomToBottom = 0;
            }
            $this$setupContainer_u24lambda_u247.startToStart = 0;
            $this$setupContainer_u24lambda_u247.endToEnd = 0;
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.config.getRespectsSafeArea()) {
                ViewCompat.setOnApplyWindowInsetsListener((View)((View)rootLayout), ConsentLayerDialog::setupContainer$lambda$8);
            }
        }
        ConstraintLayout.LayoutParams $this$setupContainer_u24lambda_u249 = layoutParams = container;
        boolean bl = false;
        $this$setupContainer_u24lambda_u249.setBackground((Drawable)this.createContainerBackground(isTop, isFullScreen));
        $this$setupContainer_u24lambda_u249.setElevation(8.0f);
        rootLayout.addView((View)container);
    }

    static /* synthetic */ void setupContainer$default(ConsentLayerDialog consentLayerDialog, ConstraintLayout constraintLayout, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        consentLayerDialog.setupContainer(constraintLayout, bl, bl2);
    }

    private final void applyBackgroundStyle(Window $this$applyBackgroundStyle) {
        ConsentLayerUIConfig.BackgroundStyle style = this.config.getBackgroundStyle();
        if (style instanceof ConsentLayerUIConfig.BackgroundStyle.Dimmed) {
            int dimColor;
            int $this$toDrawable$iv = dimColor = Color.argb((int)((int)(((ConsentLayerUIConfig.BackgroundStyle.Dimmed)style).alpha * (float)255)), (int)Color.red((int)((ConsentLayerUIConfig.BackgroundStyle.Dimmed)style).color), (int)Color.green((int)((ConsentLayerUIConfig.BackgroundStyle.Dimmed)style).color), (int)Color.blue((int)((ConsentLayerUIConfig.BackgroundStyle.Dimmed)style).color));
            boolean $i$f$toDrawable = false;
            $this$applyBackgroundStyle.setBackgroundDrawable((Drawable)new ColorDrawable($this$toDrawable$iv));
        } else if (style instanceof ConsentLayerUIConfig.BackgroundStyle.Solid) {
            int $this$toDrawable$iv = ((ConsentLayerUIConfig.BackgroundStyle.Solid)style).color;
            boolean $i$f$toDrawable = false;
            $this$applyBackgroundStyle.setBackgroundDrawable((Drawable)new ColorDrawable($this$toDrawable$iv));
        } else if (style instanceof ConsentLayerUIConfig.BackgroundStyle.None) {
            int $this$toDrawable$iv = 0;
            boolean $i$f$toDrawable = false;
            $this$applyBackgroundStyle.setBackgroundDrawable((Drawable)new ColorDrawable($this$toDrawable$iv));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void dismiss() {
        block1: {
            Dialog dialog = this.dialog;
            if (dialog != null) {
                dialog.dismiss();
            }
            this.dialog = null;
            Activity activity = this.activity;
            LifecycleOwner lifecycleOwner = activity instanceof LifecycleOwner ? (LifecycleOwner)activity : null;
            if (lifecycleOwner == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block1;
            lifecycleOwner.removeObserver((LifecycleObserver)this);
        }
    }

    public final boolean isShowing() {
        Dialog dialog = this.dialog;
        return dialog != null ? dialog.isShowing() : false;
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.dismiss();
    }

    private static final void show$lambda$2$lambda$1(DialogInterface it) {
        Log.d((String)"CMPConsentLayerDialog", (String)"Dialog dismissed");
    }

    private static final WindowInsetsCompat setupContainer$lambda$6(View view, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets systemBars = insets2;
        Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"getInsets(...)");
        Insets displayCutout = insets3;
        int topInset = Math.max(systemBars.top, displayCutout.top);
        int bottomInset = Math.max(systemBars.bottom, displayCutout.bottom);
        int leftInset = Math.max(systemBars.left, displayCutout.left);
        int rightInset = Math.max(systemBars.right, displayCutout.right);
        view.setPadding(leftInset, topInset, rightInset, bottomInset);
        return insets;
    }

    private static final WindowInsetsCompat setupContainer$lambda$8(View view, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets systemBars = insets2;
        Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"getInsets(...)");
        Insets displayCutout = insets3;
        int topInset = Math.max(systemBars.top, displayCutout.top);
        int bottomInset = Math.max(systemBars.bottom, displayCutout.bottom);
        int leftInset = Math.max(systemBars.left, displayCutout.left);
        int rightInset = Math.max(systemBars.right, displayCutout.right);
        view.setPadding(leftInset, topInset, rightInset, bottomInset);
        return insets;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog$Companion;", "", "<init>", "()V", "CONTAINER_ELEVATION", "", "cm-sdk-android-v3_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

