/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/FirebaseConsentManager;", "", "<init>", "()V", "Companion", "cm-sdk-android-v3_release"})
@Keep
public final class FirebaseConsentManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "FirebaseConsentManager";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/FirebaseConsentManager$Companion;", "", "<init>", "()V", "TAG", "", "appHasFirebaseAnalyticsSdk", "", "setFirebaseAnalyticsConsent", "context", "Landroid/content/Context;", "consentSettings", "", "cm-sdk-android-v3_release"})
    @SourceDebugExtension(value={"SMAP\nFirebaseConsentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseConsentManager.kt\nnet/consentmanager/cm_sdk_android_v3/FirebaseConsentManager$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,123:1\n216#2,2:124\n*S KotlinDebug\n*F\n+ 1 FirebaseConsentManager.kt\nnet/consentmanager/cm_sdk_android_v3/FirebaseConsentManager$Companion\n*L\n75#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean appHasFirebaseAnalyticsSdk() {
            boolean bl;
            try {
                Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                bl = true;
            }
            catch (ClassNotFoundException exception) {
                bl = false;
            }
            return bl;
        }

        public final boolean setFirebaseAnalyticsConsent(@NotNull Context context, @NotNull Map<String, String> consentSettings) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(consentSettings, (String)"consentSettings");
            if (!this.appHasFirebaseAnalyticsSdk()) {
                return false;
            }
            Class<?> analyticsClass = null;
            Object analyticsInstance = null;
            try {
                analyticsClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                Object[] objectArray = new Class[]{Context.class};
                Method getInstance = analyticsClass.getDeclaredMethod("getInstance", (Class<?>[])objectArray);
                objectArray = new Object[]{context};
                analyticsInstance = getInstance.invoke(null, objectArray);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                int n = exception2 instanceof ClassNotFoundException ? Log.w((String)FirebaseConsentManager.TAG, (String)"FirebaseAnalytics SDK is not linked in") : (exception2 instanceof NoSuchMethodException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to invoke FirebaseAnalytics getInstance method") : (exception2 instanceof IllegalAccessException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to invoke FirebaseAnalytics getInstance method") : (exception2 instanceof InvocationTargetException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to invoke FirebaseAnalytics getInstance method") : Log.w((String)FirebaseConsentManager.TAG, (String)("Unknown error when getting FirebaseAnalytics instance: " + exception.getMessage())))));
                return false;
            }
            Class<?> consentTypeClass = null;
            Class<?> consentStatusClass = null;
            try {
                consentTypeClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics$ConsentType");
                consentStatusClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics$ConsentStatus");
            }
            catch (ClassNotFoundException exception) {
                Log.w((String)FirebaseConsentManager.TAG, (String)"FirebaseAnalytics SDK does not support setConsent API");
                return false;
            }
            Map firebaseConsentMap = new LinkedHashMap();
            try {
                Map<String, String> $this$forEach$iv = consentSettings;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Object firebaseConsentStatus;
                    Object object2;
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> entry = element$iv = object.next();
                    boolean bl = false;
                    String consentType = entry.getKey();
                    String consentValue = entry.getValue();
                    switch (consentType) {
                        case "analytics_storage": {
                            object2 = consentTypeClass.getDeclaredField("ANALYTICS_STORAGE").get(null);
                            break;
                        }
                        case "ad_storage": {
                            object2 = consentTypeClass.getDeclaredField("AD_STORAGE").get(null);
                            break;
                        }
                        case "ad_user_data": {
                            object2 = consentTypeClass.getDeclaredField("AD_USER_DATA").get(null);
                            break;
                        }
                        case "ad_personalization": {
                            object2 = consentTypeClass.getDeclaredField("AD_PERSONALIZATION").get(null);
                            break;
                        }
                        default: {
                            object2 = null;
                        }
                    }
                    Object firebaseConsentType = object2;
                    String string = consentValue;
                    Object object3 = Intrinsics.areEqual((Object)string, (Object)"granted") ? consentStatusClass.getDeclaredField("GRANTED").get(null) : (firebaseConsentStatus = Intrinsics.areEqual((Object)string, (Object)"denied") ? consentStatusClass.getDeclaredField("DENIED").get(null) : null);
                    if (firebaseConsentType == null || firebaseConsentStatus == null) continue;
                    firebaseConsentMap.put(firebaseConsentType, firebaseConsentStatus);
                }
            }
            catch (Exception exception) {
                Exception $i$f$forEach = exception;
                int n = $i$f$forEach instanceof NoSuchFieldException ? Log.w((String)FirebaseConsentManager.TAG, (String)"FirebaseAnalytics SDK does not support required consent type") : ($i$f$forEach instanceof IllegalAccessException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to access consent fields") : Log.w((String)FirebaseConsentManager.TAG, (String)("Error setting up consent map: " + exception.getMessage())));
                return false;
            }
            try {
                Object[] $i$f$forEach = new Class[]{Map.class};
                Method setConsent = analyticsClass.getDeclaredMethod("setConsent", (Class<?>[])$i$f$forEach);
                $i$f$forEach = new Object[]{firebaseConsentMap};
                setConsent.invoke(analyticsInstance, $i$f$forEach);
                Log.i((String)FirebaseConsentManager.TAG, (String)"Successfully set consent via reflection");
                return true;
            }
            catch (Exception exception) {
                object = exception;
                int n = object instanceof NoSuchMethodException ? Log.w((String)FirebaseConsentManager.TAG, (String)"FirebaseAnalytics SDK does not support setConsent API") : (object instanceof IllegalAccessException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to invoke FirebaseAnalytics setConsent method") : (object instanceof InvocationTargetException ? Log.w((String)FirebaseConsentManager.TAG, (String)"Unable to invoke FirebaseAnalytics setConsent method") : Log.w((String)FirebaseConsentManager.TAG, (String)("Error setting consent: " + exception.getMessage()))));
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

