/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/ThirdPartyConsentManager;", "", "<init>", "()V", "Companion", "cm-sdk-android-v3_release"})
@Keep
public final class ThirdPartyConsentManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "ThirdPartyConsentManager";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fJ\u0006\u0010\r\u001a\u00020\u0007J\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fJ\u0006\u0010\u000f\u001a\u00020\u0007J\"\u0010\u0010\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fJ.\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/ThirdPartyConsentManager$Companion;", "", "<init>", "()V", "TAG", "", "appHasAppsFlyerSdk", "", "setAppsFlyerConsent", "context", "Landroid/content/Context;", "consentSettings", "", "appHasAdjustSdk", "setAdjustConsent", "appHasBranchSdk", "setBranchConsent", "setAllThirdPartyConsent", "cm-sdk-android-v3_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean appHasAppsFlyerSdk() {
            boolean bl;
            try {
                Class.forName("com.appsflyer.AppsFlyerLib");
                bl = true;
            }
            catch (ClassNotFoundException exception) {
                bl = false;
            }
            return bl;
        }

        public final boolean setAppsFlyerConsent(@NotNull Context context, @NotNull Map<String, String> consentSettings) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(consentSettings, (String)"consentSettings");
            if (!this.appHasAppsFlyerSdk()) {
                return false;
            }
            try {
                Object object;
                Method forGDPRUser;
                Object[] objectArray;
                Class<?> appsFlyerClass = Class.forName("com.appsflyer.AppsFlyerLib");
                Method getInstance = appsFlyerClass.getDeclaredMethod("getInstance", new Class[0]);
                Object appsFlyerInstance = getInstance.invoke(null, new Object[0]);
                try {
                    Boolean initialized;
                    Method isInitialized = appsFlyerClass.getDeclaredMethod("isInit", new Class[0]);
                    Object object2 = isInitialized.invoke(appsFlyerInstance, new Object[0]);
                    Boolean bl = initialized = object2 instanceof Boolean ? (Boolean)object2 : null;
                    if (Intrinsics.areEqual((Object)initialized, (Object)false)) {
                        Log.w((String)ThirdPartyConsentManager.TAG, (String)"AppsFlyer SDK is present but not initialized by the app yet");
                    }
                }
                catch (Exception e) {
                    Log.d((String)ThirdPartyConsentManager.TAG, (String)"Could not check AppsFlyer initialization status, proceeding anyway");
                }
                Class<?> consentClass = Class.forName("com.appsflyer.AppsFlyerConsent");
                boolean adStorageConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_storage"), (Object)"granted");
                boolean adPersonalizationConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_personalization"), (Object)"granted");
                if (adStorageConsent || adPersonalizationConsent) {
                    objectArray = new Class[]{Boolean.TYPE, Boolean.TYPE};
                    forGDPRUser = consentClass.getDeclaredMethod("forGDPRUser", (Class<?>[])objectArray);
                    objectArray = new Object[]{adStorageConsent, adPersonalizationConsent};
                    object = forGDPRUser.invoke(null, objectArray);
                } else {
                    objectArray = new Class[]{Boolean.TYPE, Boolean.TYPE};
                    forGDPRUser = consentClass.getDeclaredMethod("forGDPRUser", (Class<?>[])objectArray);
                    objectArray = new Object[]{false, false};
                    object = forGDPRUser.invoke(null, objectArray);
                }
                Object consentObject = object;
                objectArray = new Class[]{consentClass};
                Method setConsentDataMethod = appsFlyerClass.getDeclaredMethod("setConsentData", (Class<?>[])objectArray);
                objectArray = new Object[]{consentObject};
                setConsentDataMethod.invoke(appsFlyerInstance, objectArray);
                Log.i((String)ThirdPartyConsentManager.TAG, (String)("Successfully set AppsFlyer consent via reflection (adStorage: " + adStorageConsent + ", adPersonalization: " + adPersonalizationConsent + ')'));
                return true;
            }
            catch (Exception exception) {
                int n;
                Exception exception2 = exception;
                if (exception2 instanceof ClassNotFoundException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"AppsFlyer SDK classes not found");
                } else if (exception2 instanceof NoSuchMethodException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"AppsFlyer SDK method not found - possibly incompatible version");
                } else if (exception2 instanceof IllegalAccessException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Unable to access AppsFlyer methods");
                } else if (exception2 instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Error invoking AppsFlyer method: " + (throwable != null ? throwable.getMessage() : null)));
                } else {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Unexpected error setting AppsFlyer consent: " + exception.getMessage()));
                }
                return false;
            }
        }

        public final boolean appHasAdjustSdk() {
            boolean bl;
            try {
                Class.forName("com.adjust.sdk.Adjust");
                bl = true;
            }
            catch (ClassNotFoundException exception) {
                bl = false;
            }
            return bl;
        }

        public final boolean setAdjustConsent(@NotNull Context context, @NotNull Map<String, String> consentSettings) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(consentSettings, (String)"consentSettings");
            if (!this.appHasAdjustSdk()) {
                return false;
            }
            try {
                Object object;
                Method setAdStorageConsent;
                Object object2;
                Method setAnalyticsConsent;
                Object object3;
                Method setAdPersonalizationConsent;
                Object[] objectArray;
                Class<?> adjustClass = Class.forName("com.adjust.sdk.Adjust");
                boolean adStorageConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_storage"), (Object)"granted");
                boolean analyticsStorageConsent = Intrinsics.areEqual((Object)consentSettings.get("analytics_storage"), (Object)"granted");
                boolean adPersonalizationConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_personalization"), (Object)"granted");
                Class<?> consentClass = Class.forName("com.adjust.sdk.Adjust$PrivacyConsent");
                if (adPersonalizationConsent) {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAdPersonalizationConsent = adjustClass.getDeclaredMethod("setGdprAdPersonalizationConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{true};
                    object3 = setAdPersonalizationConsent.invoke(null, objectArray);
                } else {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAdPersonalizationConsent = adjustClass.getDeclaredMethod("setGdprAdPersonalizationConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{false};
                    object3 = setAdPersonalizationConsent.invoke(null, objectArray);
                }
                if (analyticsStorageConsent) {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAnalyticsConsent = adjustClass.getDeclaredMethod("setGdprAnalyticsConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{true};
                    object2 = setAnalyticsConsent.invoke(null, objectArray);
                } else {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAnalyticsConsent = adjustClass.getDeclaredMethod("setGdprAnalyticsConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{false};
                    object2 = setAnalyticsConsent.invoke(null, objectArray);
                }
                if (adStorageConsent) {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAdStorageConsent = adjustClass.getDeclaredMethod("setGdprAdStorageConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{true};
                    object = setAdStorageConsent.invoke(null, objectArray);
                } else {
                    objectArray = new Class[]{Boolean.TYPE};
                    setAdStorageConsent = adjustClass.getDeclaredMethod("setGdprAdStorageConsent", (Class<?>[])objectArray);
                    objectArray = new Object[]{false};
                    object = setAdStorageConsent.invoke(null, objectArray);
                }
                Log.i((String)ThirdPartyConsentManager.TAG, (String)("Successfully set Adjust consent via reflection (adStorage: " + adStorageConsent + ", analyticsStorage: " + analyticsStorageConsent + ", adPersonalization: " + adPersonalizationConsent + ')'));
                return true;
            }
            catch (Exception exception) {
                int n;
                Exception exception2 = exception;
                if (exception2 instanceof ClassNotFoundException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Adjust SDK classes not found");
                } else if (exception2 instanceof NoSuchMethodException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Adjust SDK method not found - possibly incompatible version");
                } else if (exception2 instanceof IllegalAccessException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Unable to access Adjust methods");
                } else if (exception2 instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Error invoking Adjust method: " + (throwable != null ? throwable.getMessage() : null)));
                } else {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Unexpected error setting Adjust consent: " + exception.getMessage()));
                }
                return false;
            }
        }

        public final boolean appHasBranchSdk() {
            boolean bl;
            try {
                Class.forName("io.branch.referral.Branch");
                bl = true;
            }
            catch (ClassNotFoundException exception) {
                bl = false;
            }
            return bl;
        }

        public final boolean setBranchConsent(@NotNull Context context, @NotNull Map<String, String> consentSettings) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(consentSettings, (String)"consentSettings");
            if (!this.appHasBranchSdk()) {
                return false;
            }
            try {
                Object object;
                Method setTrackingMethod;
                Object[] objectArray;
                Class<?> branchClass = Class.forName("io.branch.referral.Branch");
                Class<?> userDataClass = Class.forName("io.branch.referral.util.BranchUserData");
                boolean adStorageConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_storage"), (Object)"granted");
                boolean analyticsStorageConsent = Intrinsics.areEqual((Object)consentSettings.get("analytics_storage"), (Object)"granted");
                boolean adUserDataConsent = Intrinsics.areEqual((Object)consentSettings.get("ad_user_data"), (Object)"granted");
                Method getInstance = branchClass.getDeclaredMethod("getInstance", new Class[0]);
                Object branchInstance = getInstance.invoke(null, new Object[0]);
                Method getUserDataMethod = branchClass.getDeclaredMethod("getUserData", new Class[0]);
                Object userDataInstance = getUserDataMethod.invoke(branchInstance, new Object[0]);
                if (adStorageConsent || analyticsStorageConsent) {
                    objectArray = new Class[]{Boolean.TYPE};
                    setTrackingMethod = userDataClass.getDeclaredMethod("setTrackingDisabled", (Class<?>[])objectArray);
                    objectArray = new Object[]{false};
                    object = setTrackingMethod.invoke(userDataInstance, objectArray);
                } else {
                    objectArray = new Class[]{Boolean.TYPE};
                    setTrackingMethod = userDataClass.getDeclaredMethod("setTrackingDisabled", (Class<?>[])objectArray);
                    objectArray = new Object[]{true};
                    object = setTrackingMethod.invoke(userDataInstance, objectArray);
                }
                objectArray = new Class[]{Boolean.TYPE};
                Method setGdprMethod = userDataClass.getDeclaredMethod("setIsGDPR", (Class<?>[])objectArray);
                objectArray = new Object[]{true};
                setGdprMethod.invoke(userDataInstance, objectArray);
                Object[] objectArray2 = new Class[]{Boolean.TYPE};
                Method setDmaConsentMethod = userDataClass.getDeclaredMethod("setDMAConsentStatus", (Class<?>[])objectArray2);
                objectArray2 = new Object[]{adStorageConsent || adUserDataConsent};
                setDmaConsentMethod.invoke(userDataInstance, objectArray2);
                Log.i((String)ThirdPartyConsentManager.TAG, (String)("Successfully set Branch consent via reflection (tracking" + (adStorageConsent || analyticsStorageConsent ? " enabled" : " disabled") + ", DMA consent " + (adStorageConsent || adUserDataConsent ? "granted" : "denied") + ')'));
                return true;
            }
            catch (Exception exception) {
                int n;
                Exception exception2 = exception;
                if (exception2 instanceof ClassNotFoundException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Branch SDK classes not found");
                } else if (exception2 instanceof NoSuchMethodException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Branch SDK method not found - possibly incompatible version");
                } else if (exception2 instanceof IllegalAccessException) {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)"Unable to access Branch methods");
                } else if (exception2 instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Error invoking Branch method: " + (throwable != null ? throwable.getMessage() : null)));
                } else {
                    n = Log.w((String)ThirdPartyConsentManager.TAG, (String)("Unexpected error setting Branch consent: " + exception.getMessage()));
                }
                return false;
            }
        }

        @NotNull
        public final Map<String, Boolean> setAllThirdPartyConsent(@NotNull Context context, @NotNull Map<String, String> consentSettings) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(consentSettings, (String)"consentSettings");
            Map results = new LinkedHashMap();
            if (this.appHasAppsFlyerSdk()) {
                results.put("AppsFlyer", this.setAppsFlyerConsent(context, consentSettings));
            }
            if (this.appHasAdjustSdk()) {
                results.put("Adjust", this.setAdjustConsent(context, consentSettings));
            }
            if (this.appHasBranchSdk()) {
                results.put("Branch", this.setBranchConsent(context, consentSettings));
            }
            return results;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

