/*
 * Decompiled with CFR 0.152.
 */
package net.contargo.validation.bigdecimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.contargo.validation.bigdecimal.BigDecimalValidationResult;
import net.contargo.validation.bigdecimal.BigDecimalValidationRules;

public class BigDecimalValidator {
    private final boolean checkFractions;

    public BigDecimalValidator() {
        this(true);
    }

    public BigDecimalValidator(boolean checkFractions) {
        this.checkFractions = checkFractions;
    }

    public BigDecimalValidationResult validate(BigDecimal bigDecimal, BigDecimalValidationRules bigDecimalValidationRules) {
        BigDecimalValidationResult result = new BigDecimalValidationResult();
        BigDecimal thisBigDecimal = this.parse(bigDecimal, result);
        if (!result.isValid()) {
            return result;
        }
        if (thisBigDecimal.scale() < 0) {
            thisBigDecimal = new BigDecimal(thisBigDecimal.unscaledValue().multiply(BigInteger.TEN.pow(Math.abs(thisBigDecimal.scale()))));
        }
        if (this.isDecimalOutOfRange(thisBigDecimal, bigDecimalValidationRules, result)) {
            return result;
        }
        if (this.checkFractions && this.isFractionalOutOfRange(thisBigDecimal, bigDecimalValidationRules, result)) {
            return result;
        }
        if (this.isTooBig(thisBigDecimal, bigDecimalValidationRules, result)) {
            return result;
        }
        if (this.isTooSmall(thisBigDecimal, bigDecimalValidationRules, result)) {
            return result;
        }
        return result;
    }

    private BigDecimal parse(BigDecimal bigDecimal, BigDecimalValidationResult result) {
        BigDecimal thisBigDecimal = bigDecimal;
        if (thisBigDecimal == null) {
            result.setFailMessage("Cannot parse null value.");
        } else if (!this.checkFractions) {
            thisBigDecimal = new BigDecimal(bigDecimal.intValue());
        }
        return thisBigDecimal;
    }

    private boolean isDecimalOutOfRange(BigDecimal bigDecimal, BigDecimalValidationRules validationRules, BigDecimalValidationResult result) {
        int actualDecimalPlaces;
        int actualScale = bigDecimal.scale();
        int actualPrecision = bigDecimal.precision();
        if (actualPrecision <= actualScale) {
            actualPrecision = actualScale + 1;
        }
        if ((long)(actualDecimalPlaces = actualPrecision - actualScale) < validationRules.getMinDecimalPlaces() || (long)actualDecimalPlaces > validationRules.getMaxDecimalPlaces()) {
            result.setFailMessage("The count of the digits before the point is out of range. It should be in the range " + validationRules.getMinDecimalPlaces() + " - " + validationRules.getMaxDecimalPlaces() + " but is " + actualDecimalPlaces + ".");
            return true;
        }
        return false;
    }

    private boolean isFractionalOutOfRange(BigDecimal bigDecimal, BigDecimalValidationRules validationRules, BigDecimalValidationResult result) {
        int actualFractionalPlaces = bigDecimal.scale();
        if ((long)actualFractionalPlaces > validationRules.getMaxFractionalPlaces()) {
            result.setFailMessage("The count of the digits after the point is too high. It should be less than or equal to " + validationRules.getMaxFractionalPlaces() + " but is " + actualFractionalPlaces + ".");
            return true;
        }
        return false;
    }

    private boolean isTooBig(BigDecimal bigDecimal, BigDecimalValidationRules validationRules, BigDecimalValidationResult result) {
        if (bigDecimal.compareTo(validationRules.getMaxValue()) > 0) {
            result.setFailMessage("The value " + bigDecimal.doubleValue() + " is too high. It should be less than or equal to " + validationRules.getMaxValue().doubleValue() + ".");
            return true;
        }
        return false;
    }

    private boolean isTooSmall(BigDecimal bigDecimal, BigDecimalValidationRules validationRules, BigDecimalValidationResult result) {
        if (bigDecimal.compareTo(validationRules.getMinValue()) < 0) {
            result.setFailMessage("The value " + bigDecimal.doubleValue() + " is too small. It should be greater than or equal to " + validationRules.getMinValue().doubleValue() + ".");
            return true;
        }
        return false;
    }
}

