/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.Cash;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.flows.StartableByRPC;
import net.corda.core.identity.Party;
import net.corda.core.serialization.OpaqueBytes;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.AbstractCashFlow;
import net.corda.flows.CashException;
import org.jetbrains.annotations.NotNull;

@StartableByRPC
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lnet/corda/flows/CashExitFlow;", "Lnet/corda/flows/AbstractCashFlow;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueRef", "Lnet/corda/core/serialization/OpaqueBytes;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;Lnet/corda/core/utilities/ProgressTracker;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueRef", "()Lnet/corda/core/serialization/OpaqueBytes;", "call", "Lnet/corda/core/transactions/SignedTransaction;", "Companion", "finance_main"})
public final class CashExitFlow
extends AbstractCashFlow {
    @NotNull
    private final Amount<Currency> amount;
    @NotNull
    private final OpaqueBytes issueRef;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Suspendable
    @NotNull
    public SignedTransaction call() throws CashException {
        Iterator iterator;
        Object $receiver$iv$iv;
        Object destination$iv$iv;
        Object $receiver$iv;
        ContractState contractState;
        Object object;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.GENERATING_TX.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        PartyAndReference issuer = this.getServiceHub().getMyInfo().getLegalIdentity().ref(this.issueRef);
        List exitStates = this.getServiceHub().getVaultService().unconsumedStatesForSpending(this.amount, SetsKt.setOf((Object)issuer.getParty()), builder.getNotary(), builder.getLockId(), SetsKt.setOf((Object)issuer.getReference()));
        try {
            new Cash().generateExit(builder, ContractsDSL.issuedBy(this.amount, (PartyAndReference)issuer), exitStates);
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Exiting more cash than exists", e));
        }
        Map inputStatesNullable = this.getServiceHub().getVaultService().statesForRefs(builder.inputStates());
        Iterable iterable = $receiver$iv2 = (Iterable)CollectionsKt.filterNotNull((Iterable)inputStatesNullable.values());
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            Iterator it;
            TransactionState transactionState = (TransactionState)item$iv$iv;
            object = destination$iv$iv2;
            contractState = it.getData();
            object.add(contractState);
        }
        List inputStates = (List)destination$iv$iv2;
        if (inputStatesNullable.size() != inputStates.size()) {
            Map.Entry it;
            destination$iv$iv2 = $receiver$iv = inputStatesNullable;
            destination$iv$iv = new LinkedHashMap();
            iterator = $receiver$iv$iv;
            for (Map.Entry element$iv$iv : iterator.entrySet()) {
                it = element$iv$iv;
                if (!(it.getValue() == null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            iterator = $receiver$iv$iv;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                it = item$iv$iv;
                object = destination$iv$iv;
                contractState = (StateRef)it.getKey();
                object.add(contractState);
            }
            List unresolvedStateRefs = (List)destination$iv$iv;
            throw (Throwable)new IllegalStateException("Failed to resolve input StateRefs: " + unresolvedStateRefs);
        }
        $receiver$iv = inputStates;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof Cash.State)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Cash.State $i$f$filterIsInstanceTo = (Cash.State)item$iv$iv;
            object = destination$iv$iv;
            contractState = this.getServiceHub().getIdentityService().partyFromAnonymous(it.getOwner());
            object.add(contractState);
        }
        Set participants = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.SIGNING_TX.INSTANCE);
        SignedTransaction tx = this.getServiceHub().signInitialTransaction(builder);
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.FINALISING_TX.INSTANCE);
        this.finaliseTx$finance_main(participants, tx, "Unable to notarise exit");
        return tx;
    }

    @NotNull
    public final Amount<Currency> getAmount() {
        return this.amount;
    }

    @NotNull
    public final OpaqueBytes getIssueRef() {
        return this.issueRef;
    }

    public CashExitFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef, @NotNull ProgressTracker progressTracker) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        super(progressTracker);
        this.amount = amount;
        this.issueRef = issueRef;
    }

    public CashExitFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        this(amount, issueRef, Companion.tracker());
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/flows/CashExitFlow$Companion;", "", "()V", "tracker", "Lnet/corda/core/utilities/ProgressTracker;", "finance_main"})
    public static final class Companion {
        @NotNull
        public final ProgressTracker tracker() {
            return new ProgressTracker(new ProgressTracker.Step[]{AbstractCashFlow.Companion.GENERATING_TX.INSTANCE, AbstractCashFlow.Companion.SIGNING_TX.INSTANCE, AbstractCashFlow.Companion.FINALISING_TX.INSTANCE});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

