/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.Cash;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.TransactionType;
import net.corda.core.flows.FlowLogic;
import net.corda.core.flows.StartableByRPC;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.Party;
import net.corda.core.serialization.OpaqueBytes;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.AbstractCashFlow;
import net.corda.flows.FinalityFlow;
import org.jetbrains.annotations.NotNull;

@StartableByRPC
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lnet/corda/flows/CashIssueFlow;", "Lnet/corda/flows/AbstractCashFlow;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueRef", "Lnet/corda/core/serialization/OpaqueBytes;", "recipient", "Lnet/corda/core/identity/Party;", "notary", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;Lnet/corda/core/identity/Party;Lnet/corda/core/identity/Party;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;Lnet/corda/core/identity/Party;Lnet/corda/core/identity/Party;Lnet/corda/core/utilities/ProgressTracker;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueRef", "()Lnet/corda/core/serialization/OpaqueBytes;", "getNotary", "()Lnet/corda/core/identity/Party;", "getRecipient", "call", "Lnet/corda/core/transactions/SignedTransaction;", "finance_main"})
public final class CashIssueFlow
extends AbstractCashFlow {
    @NotNull
    private final Amount<Currency> amount;
    @NotNull
    private final OpaqueBytes issueRef;
    @NotNull
    private final Party recipient;
    @NotNull
    private final Party notary;

    @Suspendable
    @NotNull
    public SignedTransaction call() {
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.GENERATING_TX.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder(this.notary);
        PartyAndReference issuer = this.getServiceHub().getMyInfo().getLegalIdentity().ref(this.issueRef);
        new Cash().generateIssue(builder, (Amount<Issued<Currency>>)ContractsDSL.issuedBy(this.amount, (PartyAndReference)issuer), (AbstractParty)this.recipient, this.notary);
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.SIGNING_TX.INSTANCE);
        SignedTransaction tx = this.getServiceHub().signInitialTransaction(builder);
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.FINALISING_TX.INSTANCE);
        this.subFlow((FlowLogic)new FinalityFlow(tx));
        return tx;
    }

    @NotNull
    public final Amount<Currency> getAmount() {
        return this.amount;
    }

    @NotNull
    public final OpaqueBytes getIssueRef() {
        return this.issueRef;
    }

    @NotNull
    public final Party getRecipient() {
        return this.recipient;
    }

    @NotNull
    public final Party getNotary() {
        return this.notary;
    }

    public CashIssueFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef, @NotNull Party recipient, @NotNull Party notary, @NotNull ProgressTracker progressTracker) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        super(progressTracker);
        this.amount = amount;
        this.issueRef = issueRef;
        this.recipient = recipient;
        this.notary = notary;
    }

    public CashIssueFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef, @NotNull Party recipient, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        this(amount, issueRef, recipient, notary, AbstractCashFlow.Companion.tracker());
    }
}

