/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.TransactionType;
import net.corda.core.flows.StartableByRPC;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.Party;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.AbstractCashFlow;
import net.corda.flows.CashException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StartableByRPC
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lnet/corda/flows/CashPaymentFlow;", "Lnet/corda/flows/AbstractCashFlow;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "recipient", "Lnet/corda/core/identity/Party;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/Party;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "issuerConstraint", "", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/Party;Lnet/corda/core/utilities/ProgressTracker;Ljava/util/Set;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssuerConstraint", "()Ljava/util/Set;", "getRecipient", "()Lnet/corda/core/identity/Party;", "call", "Lnet/corda/core/transactions/SignedTransaction;", "finance_main"})
public class CashPaymentFlow
extends AbstractCashFlow {
    @NotNull
    private final Amount<Currency> amount;
    @NotNull
    private final Party recipient;
    @Nullable
    private final Set<Party> issuerConstraint;

    /*
     * WARNING - void declaration
     */
    @Suspendable
    @NotNull
    public SignedTransaction call() {
        void keysForSigning;
        void spendTX;
        Pair pair;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.GENERATING_TX.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        try {
            pair = this.getServiceHub().getVaultService().generateSpend(builder, this.amount, (AbstractParty)this.recipient, this.issuerConstraint);
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Insufficient cash for spend: " + e.getMessage(), e));
        }
        Pair pair2 = pair;
        TransactionBuilder transactionBuilder = (TransactionBuilder)pair2.component1();
        List list = (List)pair2.component2();
        pair2 = null;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.SIGNING_TX.INSTANCE);
        SignedTransaction tx = this.getServiceHub().signInitialTransaction((TransactionBuilder)spendTX, (List)keysForSigning);
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.FINALISING_TX.INSTANCE);
        this.finaliseTx$finance_main(SetsKt.setOf((Object)this.recipient), tx, "Unable to notarise spend");
        return tx;
    }

    @NotNull
    public final Amount<Currency> getAmount() {
        return this.amount;
    }

    @NotNull
    public final Party getRecipient() {
        return this.recipient;
    }

    @Nullable
    public final Set<Party> getIssuerConstraint() {
        return this.issuerConstraint;
    }

    public CashPaymentFlow(@NotNull Amount<Currency> amount, @NotNull Party recipient, @NotNull ProgressTracker progressTracker, @Nullable Set<Party> issuerConstraint) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        super(progressTracker);
        this.amount = amount;
        this.recipient = recipient;
        this.issuerConstraint = issuerConstraint;
    }

    public /* synthetic */ CashPaymentFlow(Amount amount, Party party, ProgressTracker progressTracker, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set = null;
        }
        this((Amount<Currency>)amount, party, progressTracker, set);
    }

    public CashPaymentFlow(@NotNull Amount<Currency> amount, @NotNull Party recipient) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        this(amount, recipient, AbstractCashFlow.Companion.tracker(), null, 8, null);
    }
}

