/*
 * Decompiled with CFR 0.152.
 */
package net.corda.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.text.StringsKt;
import net.corda.jackson.JacksonSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 (*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0002:\u0003()*B\u0017\b\u0016\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005B!\b\u0007\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J)\u0010\u001c\u001a\f0\u001dR\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010 JC\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\"2\u0006\u0010#\u001a\u00020\f2\u001c\u0010$\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060%0\u00152\u0006\u0010&\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010'R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/jackson/StringToMethodCallParser;", "T", "", "targetType", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "Ljava/lang/Class;", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "availableCommands", "", "", "getAvailableCommands", "()Ljava/util/Map;", "methodMap", "Lcom/google/common/collect/Multimap;", "Ljava/lang/reflect/Method;", "getMethodMap", "()Lcom/google/common/collect/Multimap;", "methodParamNames", "", "getMethodParamNames", "paramNamesFromConstructor", "ctor", "Ljava/lang/reflect/Constructor;", "paramNamesFromMethod", "method", "parse", "Lnet/corda/jackson/StringToMethodCallParser$ParsedMethodCall;", "target", "command", "(Ljava/lang/Object;Ljava/lang/String;)Lnet/corda/jackson/StringToMethodCallParser$ParsedMethodCall;", "parseArguments", "", "methodNameHint", "parameters", "Lkotlin/Pair;", "args", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)[Ljava/lang/Object;", "Companion", "ParsedMethodCall", "UnparseableCallException", "jackson_main"})
@ThreadSafe
public class StringToMethodCallParser<T> {
    @NotNull
    private final Multimap<String, Method> methodMap;
    @NotNull
    private final Map<String, List<String>> methodParamNames;
    private final ObjectMapper om;
    private static final List<String> ignoredNames;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final Multimap<String, Method> getMethodMap() {
        return this.methodMap;
    }

    @NotNull
    public final Map<String, List<String>> getMethodParamNames() {
        return this.methodParamNames;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> paramNamesFromMethod(@NotNull Method method) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        KFunction kf = ReflectJvmMapping.getKotlinFunction((Method)method);
        Object[] objectArray = $receiver$iv = (Object[])method.getParameters();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int index$iv$iv = 0;
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void index;
            String string;
            void param;
            void item$iv$iv = $receiver$iv$iv[i];
            int n = index$iv$iv++;
            Parameter parameter = (Parameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            if (param.isNamePresent()) {
                string = param.getName();
            } else if (kf != null) {
                string = ((KParameter)kf.getParameters().get((int)(index + true))).getName();
                if (string == null) {
                    String string2 = method.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"method.name");
                    throw (Throwable)new UnparseableCallException.ReflectionDataMissing(string2, (int)index);
                }
            } else {
                String string3 = method.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"method.name");
                throw (Throwable)new UnparseableCallException.ReflectionDataMissing(string3, (int)index);
            }
            String string4 = string;
            collection.add(string4);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> paramNamesFromConstructor(@NotNull Constructor<?> ctor) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(ctor, (String)"ctor");
        KFunction kf = ReflectJvmMapping.getKotlinFunction(ctor);
        Object[] objectArray = $receiver$iv = (Object[])ctor.getParameters();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int index$iv$iv = 0;
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void index;
            String string;
            void param;
            void item$iv$iv = $receiver$iv$iv[i];
            int n = index$iv$iv++;
            Parameter parameter = (Parameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            if (param.isNamePresent()) {
                string = param.getName();
            } else if (kf != null) {
                string = ((KParameter)kf.getParameters().get((int)index)).getName();
                if (string == null) {
                    throw (Throwable)new UnparseableCallException.ReflectionDataMissing("<init>", (int)index);
                }
            } else {
                throw (Throwable)new UnparseableCallException.ReflectionDataMissing("<init>", (int)index);
            }
            String string2 = string;
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ParsedMethodCall parse(@Nullable T target, @NotNull String command) throws UnparseableCallException {
        String string;
        String name;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        StringToMethodCallParser.Companion.getLog().debug("Parsing call command from string: {}", (Object)command);
        int spaceIndex = StringsKt.indexOf$default((CharSequence)command, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (spaceIndex != -1) {
            String string3 = command;
            int n = 0;
            String string4 = string3.substring(n, spaceIndex);
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = name = command;
        }
        if (spaceIndex != -1) {
            String string5 = command;
            String string6 = string5.substring(spaceIndex);
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        String argStr = string;
        Collection collection = this.methodMap.get((Object)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"methodMap[name]");
        Collection methods = collection;
        if (methods.isEmpty()) {
            throw (Throwable)new UnparseableCallException.UnknownMethod(name);
        }
        StringToMethodCallParser.Companion.getLog().debug("Parsing call for method {}", (Object)name);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)methods)) {
            int index = indexedValue.component1();
            Method method = (Method)indexedValue.component2();
            try {
                Iterable iterable = this.paramNamesFromMethod(method);
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"method.parameterTypes");
                Object[] args = this.parseArguments(name, CollectionsKt.zip((Iterable)iterable, (Object[])classArray), argStr);
                return new ParsedMethodCall(target, method, args);
            }
            catch (UnparseableCallException e) {
                if (index != methods.size() - 1) continue;
                throw (Throwable)e;
            }
        }
        throw (Throwable)new UnparseableCallException("No overloads of the method matched", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object[] parseArguments(@NotNull String methodNameHint, @NotNull List<? extends Pair<String, ? extends Class<?>>> parameters, @NotNull String args) throws UnparseableCallException {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)methodNameHint, (String)"methodNameHint");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String parameterString = "{ " + args + " }";
        JsonNode jsonNode = this.om.readTree(parameterString);
        if (jsonNode == null) {
            throw (Throwable)new UnparseableCallException(args, null, 2, null);
        }
        JsonNode tree = jsonNode;
        if (tree.size() > parameters.size()) {
            throw (Throwable)new UnparseableCallException.TooManyParameters(methodNameHint, args);
        }
        Iterable iterable = $receiver$iv = (Iterable)parameters;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object object;
            void $argName_argType;
            int n = index$iv$iv++;
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            String argName = (String)$argName_argType.component1();
            Class argType = (Class)$argName_argType.component2();
            if (tree.get(argName) == null) {
                throw (Throwable)new UnparseableCallException.MissingParameter(methodNameHint, argName, args);
            }
            try {
                JsonNode entry;
                object = this.om.readValue(entry.traverse((ObjectCodec)this.om), argType);
            }
            catch (Exception e) {
                throw (Throwable)new UnparseableCallException.FailedParse(e);
            }
            Object object2 = object;
            collection.add(object2);
        }
        List inOrderParams = (List)destination$iv$iv;
        if (StringToMethodCallParser.Companion.getLog().isDebugEnabled()) {
            $receiver$iv = inOrderParams;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void param;
                int n = index$iv++;
                Iterator<Object> iterator = item$iv;
                int i = n;
                String tmp = param != null ? param.getClass().getName() + " -> " + param : "(null)";
                StringToMethodCallParser.Companion.getLog().debug("Parameter " + i + ". " + tmp);
            }
        }
        Iterable thisCollection$iv = $receiver$iv = (Collection)inOrderParams;
        Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getAvailableCommands() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.methodMap.entries();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void name;
            String string;
            void args;
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object var7_7 = entry;
            void var8_8 = var7_7;
            String string2 = (String)var8_8.getKey();
            var8_8 = var7_7;
            Method method = (Method)var8_8.getValue();
            var7_7 = null;
            if (args.getParameterCount() == 0) {
                string = "";
            } else {
                void $receiver$iv$iv2;
                List<String> paramNames;
                String string3;
                Collection collection2;
                void $receiver$iv$iv3;
                Object[] $receiver$iv2;
                if (this.methodParamNames.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                Object[] objectArray = $receiver$iv2 = (Object[])args.getParameters();
                Iterable destination$iv$iv2 = new ArrayList($receiver$iv2.length);
                for (int i = 0; i < ((void)$receiver$iv$iv3).length; ++i) {
                    void it;
                    void item$iv$iv2 = $receiver$iv$iv3[i];
                    Parameter parameter = (Parameter)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    string3 = it.getType().getSimpleName();
                    collection2.add(string3);
                }
                List typeNames = (List)destination$iv$iv2;
                List paramTypes = CollectionsKt.zip((Iterable)paramNames, (Iterable)typeNames);
                Iterable $receiver$iv3 = paramTypes;
                destination$iv$iv2 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv3 : $receiver$iv$iv2) {
                    void it;
                    Pair $i$a$1$map = (Pair)item$iv$iv3;
                    collection2 = destination$iv$iv3;
                    string3 = (String)it.getFirst() + ": " + (String)it.getSecond();
                    collection2.add(string3);
                }
                string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            }
            String argStr = string;
            Pair pair = new Pair((Object)name, (Object)argStr);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public StringToMethodCallParser(@NotNull Class<? extends T> targetType, @NotNull ObjectMapper om) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(targetType, (String)"targetType");
        Intrinsics.checkParameterIsNotNull((Object)om, (String)"om");
        this.om = om;
        this.methodMap = StringToMethodCallParser.Companion.methodsFromType(targetType);
        Object[] objectArray = targetType.getDeclaredMethods();
        StringToMethodCallParser stringToMethodCallParser = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            Pair pair;
            Pair pair2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i];
            Method it = (Method)element$iv$iv;
            try {
                String string = it.getName();
                Method method = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"it");
                pair2 = TuplesKt.to((Object)string, this.paramNamesFromMethod(method));
            }
            catch (KotlinReflectionInternalError e) {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        stringToMethodCallParser.methodParamNames = MapsKt.toMap((Iterable)list);
    }

    @JvmOverloads
    public /* synthetic */ StringToMethodCallParser(Class clazz, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectMapper = JacksonSupport.createNonRpcMapper((JsonFactory)new YAMLFactory());
        }
        this(clazz, objectMapper);
    }

    @JvmOverloads
    public StringToMethodCallParser(@NotNull Class<? extends T> targetType) {
        this(targetType, null, 2, null);
    }

    public StringToMethodCallParser(@NotNull KClass<? extends T> targetType) {
        Intrinsics.checkParameterIsNotNull(targetType, (String)"targetType");
        this(JvmClassMappingKt.getJavaClass(targetType), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Companion = new Companion(null);
        Object[] objectArray = $receiver$iv = (Object[])Object.class.getMethods();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            Method method = (Method)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getName();
            collection.add(string);
        }
        ignoredNames = (List)var2_2;
        Logger logger = LoggerFactory.getLogger(StringToMethodCallParser.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        log = logger;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0086\u0002R\u001b\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$ParsedMethodCall;", "Ljava/util/concurrent/Callable;", "", "target", "method", "Ljava/lang/reflect/Method;", "args", "", "(Lnet/corda/jackson/StringToMethodCallParser;Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)V", "getArgs", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getMethod", "()Ljava/lang/reflect/Method;", "Ljava/lang/Object;", "call", "invoke", "jackson_main"})
    public final class ParsedMethodCall
    implements Callable<Object> {
        private final T target;
        @NotNull
        private final Method method;
        @NotNull
        private final Object[] args;

        @Nullable
        public final Object invoke() {
            return this.call();
        }

        @Override
        @Nullable
        public Object call() {
            if (this.target == null) {
                throw (Throwable)new IllegalStateException("No target object was specified");
            }
            if (Companion.getLog().isDebugEnabled()) {
                Companion.getLog().debug("Invoking call " + this.method.getName() + "(" + this.args + ")");
            }
            return this.method.invoke(this.target, Arrays.copyOf(this.args, this.args.length));
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        @NotNull
        public final Object[] getArgs() {
            return this.args;
        }

        public ParsedMethodCall(@NotNull T target, @NotNull Method method, Object[] args) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.target = target;
            this.method = method;
            this.args = args;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0005\b\t\n\u000b\fB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "command", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "FailedParse", "MissingParameter", "ReflectionDataMissing", "TooManyParameters", "UnknownMethod", "jackson_main"})
    public static class UnparseableCallException
    extends Exception {
        public UnparseableCallException(@NotNull String command, @Nullable Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            super("Could not parse as a command: " + command, cause);
        }

        public /* synthetic */ UnparseableCallException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException$UnknownMethod;", "Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "methodName", "", "(Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "jackson_main"})
        public static final class UnknownMethod
        extends UnparseableCallException {
            @NotNull
            private final String methodName;

            @NotNull
            public final String getMethodName() {
                return this.methodName;
            }

            public UnknownMethod(@NotNull String methodName) {
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                super("Unknown command name: " + methodName, null, 2, null);
                this.methodName = methodName;
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException$MissingParameter;", "Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "methodName", "", "paramName", "command", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getParamName", "()Ljava/lang/String;", "jackson_main"})
        public static final class MissingParameter
        extends UnparseableCallException {
            @NotNull
            private final String paramName;

            @NotNull
            public final String getParamName() {
                return this.paramName;
            }

            public MissingParameter(@NotNull String methodName, @NotNull String paramName, @NotNull String command) {
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                super("Parameter " + paramName + " missing from attempt to invoke " + methodName + " in command: " + command, null, 2, null);
                this.paramName = paramName;
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException$TooManyParameters;", "Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "methodName", "", "command", "(Ljava/lang/String;Ljava/lang/String;)V", "jackson_main"})
        public static final class TooManyParameters
        extends UnparseableCallException {
            public TooManyParameters(@NotNull String methodName, @NotNull String command) {
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                super("Too many parameters provided for " + methodName + ": " + command, null, 2, null);
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException$ReflectionDataMissing;", "Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "methodName", "", "argIndex", "", "(Ljava/lang/String;I)V", "jackson_main"})
        public static final class ReflectionDataMissing
        extends UnparseableCallException {
            public ReflectionDataMissing(@NotNull String methodName, int argIndex) {
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                super("Method " + methodName + " missing parameter name at index " + argIndex, null, 2, null);
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException$FailedParse;", "Lnet/corda/jackson/StringToMethodCallParser$UnparseableCallException;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;)V", "jackson_main"})
        public static final class FailedParse
        extends UnparseableCallException {
            public FailedParse(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                super(string, e);
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R*\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lnet/corda/jackson/StringToMethodCallParser$Companion;", "", "()V", "ignoredNames", "", "", "kotlin.jvm.PlatformType", "ignoredNames$annotations", "getIgnoredNames", "()Ljava/util/List;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "methodsFromType", "Lcom/google/common/collect/Multimap;", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "jackson_main"})
    public static final class Companion {
        private static /* synthetic */ void ignoredNames$annotations() {
        }

        private final List<String> getIgnoredNames() {
            return ignoredNames;
        }

        private final Multimap<String, Method> methodsFromType(Class<?> clazz) {
            Method it;
            Object $receiver$iv$iv;
            HashMultimap result = HashMultimap.create();
            Object $receiver$iv = clazz.getMethods();
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                it = (Method)element$iv$iv;
                if (it.isSynthetic() && Companion.getIgnoredNames().contains(it.getName()) ^ true) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (Method)item$iv$iv;
                Collection collection = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)it);
                collection.add(pair);
            }
            for (Pair pair : (List)destination$iv$iv) {
                String key = (String)pair.component1();
                Method value = (Method)pair.component2();
                result.put((Object)key, (Object)value);
            }
            HashMultimap hashMultimap = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"result");
            return (Multimap)hashMultimap;
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

