/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.EnumConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.Utils;
import net.corda.webserver.CmdLineOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/webserver/ArgsParser;", "", "()V", "baseDirectoryArg", "Ljoptsimple/ArgumentAcceptingOptionSpec;", "", "kotlin.jvm.PlatformType", "configFileArg", "helpArg", "Ljoptsimple/AbstractOptionSpec;", "Ljava/lang/Void;", "logToConsoleArg", "Ljoptsimple/OptionSpecBuilder;", "loggerLevel", "Lorg/slf4j/event/Level;", "optionParser", "Ljoptsimple/OptionParser;", "parse", "Lnet/corda/webserver/CmdLineOptions;", "args", "", "([Ljava/lang/String;)Lnet/corda/webserver/CmdLineOptions;", "printHelp", "", "sink", "Ljava/io/PrintStream;", "webserver_main"})
public final class ArgsParser {
    private final OptionParser optionParser = new OptionParser();
    private final ArgumentAcceptingOptionSpec<String> baseDirectoryArg = this.optionParser.accepts("base-directory", "The node working directory where all the files are kept").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
    private final ArgumentAcceptingOptionSpec<String> configFileArg = this.optionParser.accepts("config-file", "The path to the config file").withRequiredArg().defaultsTo((Object)"node.conf", (Object[])new String[0]);
    private final ArgumentAcceptingOptionSpec<Level> loggerLevel = this.optionParser.accepts("logging-level", "Enable logging at this level and higher").withRequiredArg().withValuesConvertedBy((ValueConverter)new EnumConverter<Level>(Level.class){}).defaultsTo((Object)Level.INFO, (Object[])new Level[0]);
    private final OptionSpecBuilder logToConsoleArg = this.optionParser.accepts("log-to-console", "If set, prints logging to the console as well as to a file.");
    private final AbstractOptionSpec<Void> helpArg = this.optionParser.accepts("help").forHelp();

    @NotNull
    public final CmdLineOptions parse(String ... args) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        OptionSet optionSet = this.optionParser.parse(Arrays.copyOf(args, args.length));
        boolean bl2 = bl = !optionSet.has((OptionSpec)this.baseDirectoryArg) || !optionSet.has((OptionSpec)this.configFileArg);
        if (!bl) {
            String string = (String)this.baseDirectoryArg.options().get(0) + " and " + (String)this.configFileArg.options().get(0) + " cannot be specified together";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path baseDirectory = Paths.get((String)optionSet.valueOf((OptionSpec)this.baseDirectoryArg), new String[0]).normalize().toAbsolutePath();
        Object object = optionSet.valueOf((OptionSpec)this.configFileArg);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"optionSet.valueOf(configFileArg)");
        Path configFile = Utils.div((Path)baseDirectory, (String)((String)object));
        boolean help = optionSet.has((OptionSpec)this.helpArg);
        Level loggingLevel = (Level)optionSet.valueOf((OptionSpec)this.loggerLevel);
        boolean logToConsole = optionSet.has((OptionSpec)this.logToConsoleArg);
        Path path = baseDirectory;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"baseDirectory");
        Level level = loggingLevel;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"loggingLevel");
        return new CmdLineOptions(path, configFile, help, level, logToConsole);
    }

    public final void printHelp(@NotNull PrintStream sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.optionParser.printHelpOn((OutputStream)sink);
    }
}

