/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J<\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u00062\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00010!H\u0002J(\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00010!J\t\u0010#\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lnet/corda/webserver/CmdLineOptions;", "", "baseDirectory", "Ljava/nio/file/Path;", "configFile", "help", "", "loggingLevel", "Lorg/slf4j/event/Level;", "logToConsole", "(Ljava/nio/file/Path;Ljava/nio/file/Path;ZLorg/slf4j/event/Level;Z)V", "getBaseDirectory", "()Ljava/nio/file/Path;", "getConfigFile", "getHelp", "()Z", "getLogToConsole", "getLoggingLevel", "()Lorg/slf4j/event/Level;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "loadConfig", "Lcom/typesafe/config/Config;", "allowMissingConfig", "configOverrides", "", "", "toString", "webserver_main"})
public final class CmdLineOptions {
    @NotNull
    private final Path baseDirectory;
    @NotNull
    private final Path configFile;
    private final boolean help;
    @NotNull
    private final Level loggingLevel;
    private final boolean logToConsole;

    @NotNull
    public final Config loadConfig(boolean allowMissingConfig, @NotNull Map<String, ? extends Object> configOverrides) {
        Intrinsics.checkParameterIsNotNull(configOverrides, (String)"configOverrides");
        return this.loadConfig(this.baseDirectory, this.configFile, allowMissingConfig, configOverrides);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Config loadConfig$default(CmdLineOptions cmdLineOptions, boolean bl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return cmdLineOptions.loadConfig(bl, map);
    }

    private final Config loadConfig(Path baseDirectory, Path configFile, boolean allowMissingConfig, Map<String, ? extends Object> configOverrides) {
        ConfigParseOptions parseOptions = ConfigParseOptions.defaults();
        Config defaultConfig = ConfigFactory.parseResources((String)"web-reference.conf", (ConfigParseOptions)parseOptions.setAllowMissing(false));
        Config appConfig = ConfigFactory.parseFile((File)configFile.toFile(), (ConfigParseOptions)parseOptions.setAllowMissing(allowMissingConfig));
        Config overrideConfig = ConfigFactory.parseMap((Map)MapsKt.plus(configOverrides, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"basedir", (Object)((Object)baseDirectory).toString()))));
        Config finalConfig = overrideConfig.withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)defaultConfig).resolve();
        Logger logger = LoggerFactory.getLogger(CmdLineOptions.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        Logger log = logger;
        log.info("Config:" + "\n" + finalConfig.root().render(ConfigRenderOptions.defaults()));
        Config config = finalConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"finalConfig");
        return config;
    }

    static /* bridge */ /* synthetic */ Config loadConfig$default(CmdLineOptions cmdLineOptions, Path path, Path path2, boolean bl, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            path2 = Utils.div((Path)path, (String)"node.conf");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return cmdLineOptions.loadConfig(path, path2, bl, map);
    }

    @NotNull
    public final Path getBaseDirectory() {
        return this.baseDirectory;
    }

    @NotNull
    public final Path getConfigFile() {
        return this.configFile;
    }

    public final boolean getHelp() {
        return this.help;
    }

    @NotNull
    public final Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public final boolean getLogToConsole() {
        return this.logToConsole;
    }

    public CmdLineOptions(@NotNull Path baseDirectory, @NotNull Path configFile, boolean help, @NotNull Level loggingLevel, boolean logToConsole) {
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
        Intrinsics.checkParameterIsNotNull((Object)loggingLevel, (String)"loggingLevel");
        this.baseDirectory = baseDirectory;
        this.configFile = configFile;
        this.help = help;
        this.loggingLevel = loggingLevel;
        this.logToConsole = logToConsole;
    }

    @NotNull
    public final Path component1() {
        return this.baseDirectory;
    }

    @NotNull
    public final Path component2() {
        return this.configFile;
    }

    public final boolean component3() {
        return this.help;
    }

    @NotNull
    public final Level component4() {
        return this.loggingLevel;
    }

    public final boolean component5() {
        return this.logToConsole;
    }

    @NotNull
    public final CmdLineOptions copy(@NotNull Path baseDirectory, @NotNull Path configFile, boolean help, @NotNull Level loggingLevel, boolean logToConsole) {
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
        Intrinsics.checkParameterIsNotNull((Object)loggingLevel, (String)"loggingLevel");
        return new CmdLineOptions(baseDirectory, configFile, help, loggingLevel, logToConsole);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CmdLineOptions copy$default(CmdLineOptions cmdLineOptions, Path path, Path path2, boolean bl, Level level, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            path = cmdLineOptions.baseDirectory;
        }
        if ((n & 2) != 0) {
            path2 = cmdLineOptions.configFile;
        }
        if ((n & 4) != 0) {
            bl = cmdLineOptions.help;
        }
        if ((n & 8) != 0) {
            level = cmdLineOptions.loggingLevel;
        }
        if ((n & 0x10) != 0) {
            bl2 = cmdLineOptions.logToConsole;
        }
        return cmdLineOptions.copy(path, path2, bl, level, bl2);
    }

    public String toString() {
        return "CmdLineOptions(baseDirectory=" + this.baseDirectory + ", configFile=" + this.configFile + ", help=" + this.help + ", loggingLevel=" + this.loggingLevel + ", logToConsole=" + this.logToConsole + ")";
    }

    public int hashCode() {
        Path path = this.baseDirectory;
        Path path2 = this.configFile;
        int n = ((path != null ? ((Object)path).hashCode() : 0) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0)) * 31;
        int n2 = this.help ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Level level = this.loggingLevel;
        int n3 = ((n + n2) * 31 + (level != null ? level.hashCode() : 0)) * 31;
        int n4 = this.logToConsole ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        return n3 + n4;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CmdLineOptions)) break block3;
                CmdLineOptions cmdLineOptions = (CmdLineOptions)object;
                if (!Intrinsics.areEqual((Object)this.baseDirectory, (Object)cmdLineOptions.baseDirectory) || !Intrinsics.areEqual((Object)this.configFile, (Object)cmdLineOptions.configFile) || !(this.help == cmdLineOptions.help) || !Intrinsics.areEqual((Object)this.loggingLevel, (Object)cmdLineOptions.loggingLevel) || !(this.logToConsole == cmdLineOptions.logToConsole)) break block3;
            }
            return true;
        }
        return false;
    }
}

