/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver.internal;

import com.google.common.html.HtmlEscapers;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.corda.client.rpc.CordaRPCClient;
import net.corda.client.rpc.CordaRPCConnection;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.CordaPluginRegistry;
import net.corda.nodeapi.config.SSLConfiguration;
import net.corda.webserver.WebServerConfig;
import net.corda.webserver.internal.APIServerImpl;
import net.corda.webserver.internal.NodeWebServer;
import net.corda.webserver.servlets.AttachmentDownloadServlet;
import net.corda.webserver.servlets.CorDappInfoServlet;
import net.corda.webserver.servlets.DataUploadServlet;
import net.corda.webserver.servlets.ObjectMapperConfig;
import net.corda.webserver.servlets.ResponseFilter;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001fJ\b\u0010!\u001a\u00020\u0019H\u0002J\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnet/corda/webserver/internal/NodeWebServer;", "", "config", "Lnet/corda/webserver/WebServerConfig;", "(Lnet/corda/webserver/WebServerConfig;)V", "address", "Lcom/google/common/net/HostAndPort;", "getAddress", "()Lcom/google/common/net/HostAndPort;", "getConfig", "()Lnet/corda/webserver/WebServerConfig;", "pluginRegistries", "", "Lnet/corda/core/node/CordaPluginRegistry;", "getPluginRegistries", "()Ljava/util/List;", "pluginRegistries$delegate", "Lkotlin/Lazy;", "renderBasicInfoToConsole", "", "server", "Lorg/eclipse/jetty/server/Server;", "buildServletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "localRpc", "Lnet/corda/core/messaging/CordaRPCOps;", "connectLocalRpcAsNodeUser", "initWebServer", "logAndMaybePrint", "", "description", "", "info", "retryConnectLocalRpc", "run", "start", "Companion", "webserver_main"})
public final class NodeWebServer {
    @NotNull
    private final HostAndPort address;
    private boolean renderBasicInfoToConsole;
    private Server server;
    @NotNull
    private final Lazy pluginRegistries$delegate;
    @NotNull
    private final WebServerConfig config;
    @NotNull
    private static final Logger log;
    public static final long retryDelay = 1000L;
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    public final HostAndPort getAddress() {
        return this.address;
    }

    public final void start() {
        NodeWebServer.logAndMaybePrint$default(this, "Starting as webserver: " + this.config.getWebAddress(), null, 2, null);
        this.server = this.initWebServer(this.retryConnectLocalRpc());
    }

    public final void run() {
        while (true) {
            Server server = this.server;
            if (server == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            }
            if (!server.isRunning()) break;
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Server initWebServer(CordaRPCOps localRpc) {
        void elements$iv;
        Connector[] httpConfiguration;
        ServerConnector serverConnector;
        Iterable iterable;
        HandlerCollection handlerCollection;
        HandlerCollection handlerCollection2 = new HandlerCollection();
        if (StringsKt.split$default((CharSequence)this.config.getExportJMXto(), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null).contains("http")) {
            Object v3;
            Iterable $receiver$iv;
            block6: {
                CharSequence charSequence = System.getProperty("java.class.path");
                String[] stringArray = new String[1];
                String string = System.getProperty("path.separator");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"path.separator\")");
                stringArray[0] = string;
                List classpath = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                $receiver$iv = classpath;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"jolokia-agent-war-2", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)".war", (boolean)false, (int)2, null))) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            String warpath = v3;
            if (warpath != null) {
                $receiver$iv = new WebAppContext();
                handlerCollection = handlerCollection2;
                Iterable $receiver = $receiver$iv;
                $receiver.setContextPath("/monitoring/json");
                $receiver.setInitParameter("mimeType", "application/json");
                $receiver.setWar(warpath);
                iterable = $receiver$iv;
                handlerCollection.addHandler((Handler)iterable);
            } else {
                Companion.getLog().warn("Unable to locate Jolokia WAR on classpath");
            }
        }
        handlerCollection2.addHandler((Handler)this.buildServletContextHandler(localRpc));
        Server server = new Server();
        if (this.config.getUseHTTPS()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setOutputBufferSize(32768);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(((Object)this.config.getSslKeystore()).toString());
            sslContextFactory.setKeyStorePassword(this.config.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(this.config.getKeyStorePassword());
            sslContextFactory.setTrustStorePath(((Object)this.config.getTrustStoreFile()).toString());
            sslContextFactory.setTrustStorePassword(this.config.getTrustStorePassword());
            sslContextFactory.setExcludeProtocols(new String[]{"SSL.*", "TLSv1", "TLSv1.1"});
            sslContextFactory.setIncludeProtocols(new String[]{"TLSv1.2"});
            sslContextFactory.setExcludeCipherSuites(new String[]{".*NULL.*", ".*RC4.*", ".*MD5.*", ".*DES.*", ".*DSS.*"});
            sslContextFactory.setIncludeCipherSuites(new String[]{".*AES.*GCM.*"});
            ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{(ConnectionFactory)new SslConnectionFactory(sslContextFactory, "http/1.1"), (ConnectionFactory)new HttpConnectionFactory(httpsConfiguration)});
            sslConnector.setPort(this.address.getPort());
            serverConnector = sslConnector;
        } else {
            httpConfiguration = new HttpConfiguration();
            httpConfiguration.setOutputBufferSize(32768);
            ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{(ConnectionFactory)new HttpConnectionFactory((HttpConfiguration)httpConfiguration)});
            httpConnector.setPort(this.address.getPort());
            serverConnector = httpConnector;
        }
        ServerConnector connector = serverConnector;
        httpConfiguration = new Connector[]{(Connector)connector};
        handlerCollection = server;
        iterable = elements$iv;
        handlerCollection.setConnectors((Connector[])iterable);
        server.setHandler((Handler)handlerCollection2);
        server.start();
        Companion.getLog().info("Starting webserver on address " + this.address);
        return server;
    }

    /*
     * WARNING - void declaration
     */
    private final ServletContextHandler buildServletContextHandler(CordaRPCOps localRpc) {
        void $receiver$iv$iv;
        Object element$iv2;
        Iterable list$iv$iv;
        Map it;
        Object element$iv$iv;
        Iterable $receiver$iv$iv2;
        Object object;
        Iterable iterable;
        Object item$iv$iv2;
        void $receiver$iv$iv3;
        Object customAPI;
        Iterator $receiver$iv$iv4;
        Iterable $receiver$iv;
        ServletContextHandler servletContextHandler;
        String safeLegalName = HtmlEscapers.htmlEscaper().escape(this.config.getMyLegalName());
        ServletContextHandler $receiver = servletContextHandler = new ServletContextHandler();
        $receiver.setContextPath("/");
        $receiver.setErrorHandler(new ErrorHandler(this, safeLegalName, localRpc){
            final /* synthetic */ NodeWebServer this$0;
            final /* synthetic */ String $safeLegalName$inlined;
            final /* synthetic */ CordaRPCOps $localRpc$inlined;
            {
                this.this$0 = nodeWebServer;
                this.$safeLegalName$inlined = string;
                this.$localRpc$inlined = cordaRPCOps;
            }

            protected void writeErrorPageHead(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
                writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"/>\n");
                writer.write("<title>Corda " + this.$safeLegalName$inlined + " : Error " + code + "</title>" + "\n");
            }

            protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
                writer.write("<h1>Corda " + this.$safeLegalName$inlined + "</h1>" + "\n");
                super.writeErrorPageMessage(request, writer, code, message, uri);
            }
        });
        $receiver.setAttribute("rpc", (Object)localRpc);
        $receiver.addServlet(DataUploadServlet.class, "/upload/*");
        $receiver.addServlet(AttachmentDownloadServlet.class, "/attachments/*");
        ResourceConfig resourceConfig = new ResourceConfig().register((Object)new ObjectMapperConfig(localRpc)).register((Object)new ResponseFilter()).register((Object)new APIServerImpl(localRpc));
        Iterable iterable2 = $receiver$iv = (Iterable)this.getPluginRegistries();
        Collection destination$iv$iv = new ArrayList();
        Iterator<Object> iterator = $receiver$iv$iv4.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv2 = iterator.next();
            CordaPluginRegistry x = (CordaPluginRegistry)element$iv$iv2;
            Iterable list$iv$iv2 = x.getWebApis();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        List webAPIsOnClasspath = (List)destination$iv$iv;
        for (Function webapi : webAPIsOnClasspath) {
            Companion.getLog().info("Add plugin web API from attachment " + webapi);
            try {
                iterator = webapi.apply(localRpc);
            }
            catch (InvocationTargetException ex) {
                Companion.getLog().error("Constructor " + webapi + " threw an error: ", ex.getTargetException());
                continue;
            }
            customAPI = iterator;
            resourceConfig.register(customAPI);
        }
        Iterable $receiver$iv2 = this.getPluginRegistries();
        customAPI = $receiver$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv3) {
            void x;
            CordaPluginRegistry $i$a$1$flatMap = (CordaPluginRegistry)item$iv$iv2;
            iterable = destination$iv$iv2;
            object = x.getStaticServeDirs();
            iterable.add(object);
        }
        List staticDirMaps = (List)destination$iv$iv2;
        Iterable $receiver$iv3 = staticDirMaps;
        destination$iv$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        item$iv$iv2 = $receiver$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            element$iv$iv = item$iv$iv2.next();
            it = (Map)element$iv$iv;
            list$iv$iv = it.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $receiver$iv3 = staticDirMaps;
        iterable = (List)destination$iv$iv3;
        $receiver$iv$iv2 = $receiver$iv3;
        destination$iv$iv3 = new ArrayList();
        item$iv$iv2 = $receiver$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            element$iv$iv = item$iv$iv2.next();
            it = (Map)element$iv$iv;
            list$iv$iv = it.values();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        object = (List)destination$iv$iv3;
        List staticDirs = CollectionsKt.zip((Iterable)iterable, (Iterable)((Iterable)object));
        $receiver$iv3 = staticDirs;
        for (Object element$iv2 : $receiver$iv3) {
            Pair it2 = (Pair)element$iv2;
            ServletHolder staticDir = new ServletHolder(DefaultServlet.class);
            staticDir.setInitParameter("resourceBase", (String)it2.getSecond());
            staticDir.setInitParameter("dirAllowed", "true");
            staticDir.setInitParameter("pathInfoOnly", "true");
            $receiver.addServlet(staticDir, "/web/" + (String)it2.getFirst() + "/*");
        }
        resourceConfig.addProperties(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jersey.config.server.application.name", (Object)"node.api"), TuplesKt.to((Object)"jersey.config.server.monitoring.statistics.mbeans.enabled", (Object)"true")}));
        Iterable $receiver$iv4 = this.getPluginRegistries();
        element$iv2 = $receiver$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            CordaPluginRegistry it3 = (CordaPluginRegistry)element$iv$iv3;
            if (StringsKt.startsWith$default((String)it3.getClass().getName(), (String)"net.corda.node.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it3.getClass().getName(), (String)"net.corda.core.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it3.getClass().getName(), (String)"net.corda.nodeapi.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        List filteredPlugins = (List)destination$iv$iv4;
        ServletHolder infoServlet = new ServletHolder((Servlet)new CorDappInfoServlet(filteredPlugins, localRpc));
        $receiver.addServlet(infoServlet, "");
        ServletContainer container = new ServletContainer(resourceConfig);
        ServletHolder jerseyServlet = new ServletHolder((Servlet)container);
        $receiver.addServlet(jerseyServlet, "/api/*");
        jerseyServlet.setInitOrder(0);
        return servletContextHandler;
    }

    private final CordaRPCOps retryConnectLocalRpc() {
        while (true) {
            try {
                return this.connectLocalRpcAsNodeUser();
            }
            catch (ActiveMQNotConnectedException e) {
                Companion.getLog().debug("Could not connect to " + this.config.getP2pAddress() + " due to exception: ", (Throwable)e);
                Thread.sleep(1000L);
                continue;
            }
            catch (NoSuchFileException e) {
                Companion.getLog().debug("Tried to open a file that doesn't yet exist, retrying", (Throwable)e);
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable e) {
                Companion.getLog().error("Cannot start WebServer", e);
                throw e;
            }
            break;
        }
    }

    private final CordaRPCOps connectLocalRpcAsNodeUser() {
        Companion.getLog().info("Connecting to node at " + this.config.getP2pAddress() + " as node user");
        CordaRPCClient client = new CordaRPCClient(this.config.getP2pAddress(), (SSLConfiguration)this.config, null, 4, null);
        CordaRPCConnection connection = client.start("SystemUsers/Node", "SystemUsers/Node");
        return connection.getProxy();
    }

    @NotNull
    public final List<CordaPluginRegistry> getPluginRegistries() {
        Lazy lazy = this.pluginRegistries$delegate;
        NodeWebServer nodeWebServer = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (List)lazy.getValue();
    }

    public final void logAndMaybePrint(@NotNull String description, @Nullable String info) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        String msg = info == null ? description : StringsKt.padEnd$default((String)description, (int)40, (char)'\u0000', (int)2, null) + ": " + info;
        String loggerName = this.renderBasicInfoToConsole ? "BasicInfo" : "Main";
        LoggerFactory.getLogger((String)loggerName).info(msg);
    }

    public static /* bridge */ /* synthetic */ void logAndMaybePrint$default(NodeWebServer nodeWebServer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nodeWebServer.logAndMaybePrint(string, string2);
    }

    @NotNull
    public final WebServerConfig getConfig() {
        return this.config;
    }

    public NodeWebServer(@NotNull WebServerConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.address = this.config.getWebAddress();
        this.renderBasicInfoToConsole = true;
        this.pluginRegistries$delegate = LazyKt.lazy((Function0)pluginRegistries.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(NodeWebServer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        log = logger;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NodeWebServer.class), "pluginRegistries", "getPluginRegistries()Ljava/util/List;"))};
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/webserver/internal/NodeWebServer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "retryDelay", "", "webserver_main"})
    private static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

