/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.asyncapi.exception.DuplicateClassException;
import net.coru.api.generator.plugin.asyncapi.exception.DuplicatedOperationException;
import net.coru.api.generator.plugin.asyncapi.exception.FileSystemException;
import net.coru.api.generator.plugin.asyncapi.exception.KafkaTopicSeparatorException;
import net.coru.api.generator.plugin.asyncapi.parameter.FileSpec;
import net.coru.api.generator.plugin.asyncapi.parameter.OperationParameterObject;
import net.coru.api.generator.plugin.asyncapi.template.TemplateFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="asyncapi-generation", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class OpenAsyncMojo
extends AbstractMojo {
    private static final String DEFAULT_ASYNCAPI_TARGET_PACKAGE = "net.coru.apigenerator.asyncapi";
    private static final String DEFAULT_ASYNCAPI_MODEL_PACKAGE = "net.coru.apigenerator.asyncapi.model";
    private static final String CONSUMER_CLASS_NAME = "Subscriber";
    private static final String SUPPLIER_CLASS_NAME = "Producer";
    private static final String STREAM_BRIDGE_CLASS_NAME = "StreamBridgeProducer";
    public static final String SUBSCRIBE = "subscribe";
    public static final String PUBLISH = "publish";
    public static final String OPERATION_ID = "operationId";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(property="fileSpecs")
    public List<FileSpec> fileSpecs;
    private TemplateFactory templateFactory;
    private final List<String> processedOperationIds = new ArrayList<String>();
    private final List<String> processedClassnames = new ArrayList<String>();
    private final List<String> processedTargetPackages = new ArrayList<String>();
    private final FilenameFilter targetFileFilter = (dir, name) -> name.toLowerCase().contains("target");

    public void execute() {
        this.templateFactory = new TemplateFactory();
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        for (FileSpec fileParameter : this.fileSpecs) {
            this.setUpTemplate(fileParameter);
            this.processDuplicates(fileParameter);
            Path ymlParentPath = Paths.get(fileParameter.getFilePath(), new String[0]).toAbsolutePath().getParent();
            File file = new File(fileParameter.getFilePath());
            try {
                JsonNode node = om.readTree(file);
                JsonNode internalNode = node.get("channels");
                Iterator iter = internalNode.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    JsonNode channel = (JsonNode)entry.getValue();
                    String operationId = this.getOperationId(channel);
                    JsonNode channelPayload = this.getChannelPayload(channel);
                    if (this.isValidOperation(fileParameter.getConsumer(), operationId, channel, SUBSCRIBE, true)) {
                        this.processSubscribeMethod(channelPayload, fileParameter.getConsumer().getModelPackage(), ymlParentPath);
                    } else if (this.isValidOperation(fileParameter.getSupplier(), operationId, channel, PUBLISH, Objects.isNull(fileParameter.getStreamBridge()))) {
                        this.processSupplierMethod(channelPayload, fileParameter.getSupplier().getModelPackage(), ymlParentPath);
                    } else if (this.isValidOperation(fileParameter.getStreamBridge(), operationId, channel, PUBLISH, Objects.isNull(fileParameter.getSupplier()))) {
                        this.processStreamBridgeMethod(channelPayload, fileParameter.getStreamBridge().getModelPackage(), ymlParentPath, (String)entry.getKey());
                    }
                    if (!ObjectUtils.allNull((Object[])new Object[]{fileParameter.getConsumer(), fileParameter.getSupplier(), fileParameter.getStreamBridge()})) continue;
                    if (channel.has(SUBSCRIBE)) {
                        this.processSubscribeMethod(channelPayload, null, ymlParentPath);
                        continue;
                    }
                    this.processSupplierMethod(channelPayload, null, ymlParentPath);
                }
                this.templateFactory.fillTemplate();
                this.templateFactory.clearData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isValidOperation(OperationParameterObject operation, String operationId, JsonNode channel, String channelType, boolean excludingOperationExists) {
        return operation != null && (operation.getOperationIds() != null && operation.getOperationIds().contains(operationId) || operation.getOperationIds() == null && channel.has(channelType) && excludingOperationExists);
    }

    private JsonNode getChannelPayload(JsonNode channel) {
        JsonNode payload = null;
        payload = channel.has(SUBSCRIBE) ? channel.get(SUBSCRIBE) : channel.get(PUBLISH);
        return payload;
    }

    private String getOperationId(JsonNode channel) {
        String operationId = channel.has(SUBSCRIBE) ? channel.get(SUBSCRIBE).get(OPERATION_ID).asText() : channel.get(PUBLISH).get(OPERATION_ID).asText();
        if (this.processedOperationIds.contains(operationId)) {
            throw new DuplicatedOperationException(operationId);
        }
        this.processedOperationIds.add(operationId);
        return operationId;
    }

    private void setUpTemplate(FileSpec fileParameter) {
        this.processPackage(fileParameter);
        this.processFilePaths(fileParameter);
        this.processClassnames(fileParameter);
        this.processEntitiesPostfix(fileParameter);
    }

    private void processFilePaths(FileSpec fileParameter) {
        this.templateFactory.setSupplierFilePath(this.processPath(fileParameter.getSupplier()));
        this.templateFactory.setStreamBridgeFilePath(this.processPath(fileParameter.getStreamBridge()));
        this.templateFactory.setSubscribeFilePath(this.processPath(fileParameter.getConsumer()));
    }

    private void processEntitiesPostfix(FileSpec fileParameter) {
        this.templateFactory.setSupplierEntitiesPostfix(fileParameter.getSupplier() != null && fileParameter.getSupplier().getEntitiesPostfix() != null ? fileParameter.getSupplier().getEntitiesPostfix() : null);
        this.templateFactory.setStreamBridgeEntitiesPostfix(fileParameter.getStreamBridge() != null && fileParameter.getStreamBridge().getEntitiesPostfix() != null ? fileParameter.getStreamBridge().getEntitiesPostfix() : null);
        this.templateFactory.setSubscribeEntitiesPostfix(fileParameter.getConsumer() != null && fileParameter.getConsumer().getEntitiesPostfix() != null ? fileParameter.getConsumer().getEntitiesPostfix() : null);
    }

    private void processDuplicates(FileSpec fileParameter) {
        OperationParameterObject operation;
        if (fileParameter.getConsumer() != null) {
            operation = fileParameter.getConsumer();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), CONSUMER_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(CONSUMER_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, CONSUMER_CLASS_NAME);
        }
        if (fileParameter.getSupplier() != null) {
            operation = fileParameter.getSupplier();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), SUPPLIER_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(SUPPLIER_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, SUPPLIER_CLASS_NAME);
        }
        if (fileParameter.getStreamBridge() != null) {
            operation = fileParameter.getStreamBridge();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), STREAM_BRIDGE_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(STREAM_BRIDGE_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, STREAM_BRIDGE_CLASS_NAME);
        }
    }

    private void checkClassPackageDuplicate(String className, String targetPackage, String defaultClassName) {
        if (className != null && this.processedClassnames.contains(className) && targetPackage != null && this.processedTargetPackages.contains(targetPackage) && this.processedClassnames.lastIndexOf(className) == this.processedTargetPackages.lastIndexOf(targetPackage)) {
            throw new DuplicateClassException(className, targetPackage);
        }
        this.processedClassnames.add(className != null ? className : defaultClassName);
        this.processedTargetPackages.add(targetPackage != null ? targetPackage : DEFAULT_ASYNCAPI_TARGET_PACKAGE);
    }

    private void processClassnames(FileSpec fileParameter) {
        this.templateFactory.setSupplierClassName(fileParameter.getSupplier() != null && fileParameter.getSupplier().getClassNamePostfix() != null ? fileParameter.getSupplier().getClassNamePostfix() : SUPPLIER_CLASS_NAME);
        this.templateFactory.setStreamBridgeClassName(fileParameter.getStreamBridge() != null && fileParameter.getStreamBridge().getClassNamePostfix() != null ? fileParameter.getStreamBridge().getClassNamePostfix() : STREAM_BRIDGE_CLASS_NAME);
        this.templateFactory.setSubscribeClassName(fileParameter.getConsumer() != null && fileParameter.getConsumer().getClassNamePostfix() != null ? fileParameter.getConsumer().getClassNamePostfix() : CONSUMER_CLASS_NAME);
    }

    private Path processPath(OperationParameterObject operationParameter) {
        Path path;
        File[] pathList = Objects.requireNonNull(this.project.getBasedir().listFiles(this.targetFileFilter));
        if (pathList.length > 0) {
            path = pathList[0].toPath().resolve(this.convertPackageToTargetPath(operationParameter));
        } else {
            path = this.project.getBasedir().toPath().resolve("target");
            if (!path.toFile().mkdirs()) {
                throw new FileSystemException("File System error trying to create neccesary folder " + path.toFile());
            }
            path = path.resolve(this.convertPackageToTargetPath(operationParameter));
        }
        if (!path.toFile().isDirectory() && !path.toFile().mkdirs()) {
            throw new FileSystemException("File System error trying to create neccesary folder " + path.toFile());
        }
        this.project.addCompileSourceRoot(path.toString());
        return path;
    }

    private String convertPackageToTargetPath(OperationParameterObject operationParameter) {
        String targetPackage;
        String string = targetPackage = operationParameter != null ? operationParameter.getTargetPackage() : null;
        String path = targetPackage != null ? "generated-sources/corunet/apigenerator/" + targetPackage.replace(".", "/") : (this.project.getModel().getGroupId() != null ? "generated-sources/corunet/apigenerator/" + this.project.getModel().getGroupId().replace(".", "/") : "generated-sources/corunet/apigenerator/" + DEFAULT_ASYNCAPI_TARGET_PACKAGE.replace(".", "/"));
        return path;
    }

    private void processPackage(FileSpec fileParameter) {
        this.templateFactory.setSupplierPackageName(this.evaluatePackage(fileParameter.getSupplier()));
        this.templateFactory.setStreamBridgePackageName(this.evaluatePackage(fileParameter.getStreamBridge()));
        this.templateFactory.setSubscribePackageName(this.evaluatePackage(fileParameter.getConsumer()));
    }

    private String evaluatePackage(OperationParameterObject operation) {
        if (operation != null && operation.getTargetPackage() != null) {
            return operation.getTargetPackage();
        }
        if (this.project.getModel().getGroupId() != null) {
            return this.project.getModel().getGroupId();
        }
        return DEFAULT_ASYNCAPI_TARGET_PACKAGE;
    }

    private void processSupplierMethod(JsonNode channel, String modelPackage, Path ymlParentPath) {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        this.templateFactory.addSupplierMethod((String)result.getKey(), (String)result.getValue());
    }

    private void processStreamBridgeMethod(JsonNode channel, String modelPackage, Path ymlParentPath, String channelName) {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        String regex = "[a-zA-Z0-9\\.\\-]*";
        if (!channelName.matches(regex)) {
            throw new KafkaTopicSeparatorException(channelName);
        }
        this.templateFactory.addStreamBridgeMethod((String)result.getKey(), (String)result.getValue(), channelName);
    }

    private void processSubscribeMethod(JsonNode channel, String modelPackage, Path ymlParentPath) {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        this.templateFactory.addSubscribeMethod((String)result.getKey(), (String)result.getValue());
    }

    private Pair<String, String> processMethod(JsonNode channel, String modelPackage, Path ymlParentPath) {
        JsonNode message = channel.get("message");
        String operationId = channel.get(OPERATION_ID).asText();
        String namespace = "";
        if (message.get("$ref") != null && message.get("$ref").asText().startsWith("#")) {
            String[] pathToObject = message.get("$ref").asText().split("/");
            namespace = this.processModelPackage(pathToObject[pathToObject.length - 1], modelPackage);
        } else if (message.get("$ref") != null) {
            String avroFilePath = message.get("$ref").asText();
            if (message.get("$ref").asText().startsWith("/")) {
                avroFilePath = avroFilePath.replaceFirst("/", "");
            }
            File avroFile = ymlParentPath.resolve(avroFilePath).toFile();
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode fileTree = mapper.readTree(avroFile);
                String fullNamespace = fileTree.get("namespace").asText() + "." + fileTree.get("name").asText();
                namespace = this.processModelPackage(fullNamespace, modelPackage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            namespace = this.processModelPackage((String)message.fieldNames().next(), modelPackage);
        }
        return new MutablePair((Object)operationId, (Object)namespace);
    }

    private String processModelPackage(String extractedPackage, String modelPackage) {
        Object processedPackage;
        if (modelPackage != null) {
            if (extractedPackage.contains(".")) {
                String[] splittedPackage = extractedPackage.split("\\.");
                String className = splittedPackage[splittedPackage.length - 1];
                processedPackage = modelPackage + "." + className;
            } else {
                processedPackage = modelPackage + "." + extractedPackage;
            }
        } else {
            processedPackage = extractedPackage.contains(".") ? extractedPackage : "net.coru.apigenerator.asyncapi.model." + extractedPackage;
        }
        return processedPackage;
    }
}

