/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin;

import freemarker.template.TemplateException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.GlobalObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.template.TemplateFactory;
import net.coru.api.generator.plugin.openapi.utils.MapperAuthUtil;
import net.coru.api.generator.plugin.openapi.utils.MapperContentUtil;
import net.coru.api.generator.plugin.openapi.utils.MapperPathUtil;
import net.coru.api.generator.plugin.openapi.utils.OpenApiUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="openapi-generation", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class OpenapiMultiFileMojo
extends AbstractMojo {
    private static final String DEFAULT_OPENAPI_TARGET_PACKAGE = "net.coru.apigenerator.openapi";
    private static final String DEFAULT_OPENAPI_MODEL_PACKAGE = "net.coru.apigenerator.openapi.model";
    private static final String DEFAULT_OPENAPI_CLIENT_PACKAGE = "net.coru.apigenerator.openapi.client";
    private final FilenameFilter targetFileFilter = (dir, name) -> name.toLowerCase().contains("target");
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(property="fileSpecs")
    public List<FileSpec> fileSpecs;
    @Parameter(name="clientPackage", property="clientPackage")
    private String clientPackage;
    private TemplateFactory templateFactory;
    private Boolean isWebClient = false;
    private Boolean isRestClient = false;
    private List<String> authentications = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        this.templateFactory = new TemplateFactory();
        if (null == this.fileSpecs || this.fileSpecs.isEmpty()) {
            throw new MojoExecutionException("Code generation failed. Not exists FileSpec configuration to generate package and class");
        }
        this.processFileSpec(this.fileSpecs);
        this.createClients();
    }

    private void processFileSpec(List<FileSpec> fileSpecsList) throws MojoExecutionException {
        for (FileSpec fileSpec : fileSpecsList) {
            try {
                this.processPackage(fileSpec.getApiPackage());
                String filePathToSave = this.processPath(fileSpec.getApiPackage(), false);
                this.project.addCompileSourceRoot(filePathToSave);
                this.processFile(fileSpec, filePathToSave);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Code generation failed. See above for the full exception.");
            }
        }
    }

    private void processFile(FileSpec fileSpec, String filePathToSave) throws MojoExecutionException {
        try {
            OpenAPI openAPI = OpenApiUtil.getPojoFromSwagger(fileSpec);
            if (fileSpec.getCallMode().booleanValue()) {
                this.templateFactory.setWebClientPackageName(StringUtils.isNotBlank((CharSequence)this.clientPackage) ? this.clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE);
                this.templateFactory.setAuthPackageName((StringUtils.isNotBlank((CharSequence)this.clientPackage) ? this.clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE) + ".auth");
                this.isWebClient = fileSpec.getIsReactive();
                this.isRestClient = fileSpec.getIsReactive() == false;
            }
            this.createApiTemplate(fileSpec, filePathToSave, openAPI);
            this.createModelTemplate(fileSpec, openAPI);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed: " + e.getMessage());
        }
    }

    private void createClients() {
        if (this.isWebClient.booleanValue() || this.isRestClient.booleanValue()) {
            String clientPath = this.processPath(StringUtils.isNotBlank((CharSequence)this.clientPackage) ? this.clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE, false);
            this.project.addCompileSourceRoot(clientPath);
            try {
                if (this.isWebClient.booleanValue()) {
                    this.templateFactory.fillTemplateWebClient(clientPath);
                }
                if (this.isRestClient.booleanValue()) {
                    this.templateFactory.fillTemplateRestClient(clientPath);
                }
                this.createAuthTemplates();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createAuthTemplates() throws TemplateException, IOException {
        String authFileRoot = (StringUtils.isNotBlank((CharSequence)this.clientPackage) ? this.clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE) + ".auth";
        String authFileToSave = this.processPath(authFileRoot, false);
        this.templateFactory.setAuthPackageName(authFileRoot);
        this.templateFactory.fillTemplateAuth(authFileToSave, "Authentication");
        if (null != this.authentications && !this.authentications.isEmpty()) {
            for (String authentication : this.authentications) {
                this.templateFactory.fillTemplateAuth(authFileToSave, authentication);
            }
        }
    }

    private void createApiTemplate(FileSpec fileSpec, String filePathToSave, OpenAPI openAPI) throws Exception {
        HashMap<String, HashMap<String, PathItem>> apis = OpenApiUtil.mapApiGroups(openAPI, fileSpec.getUseTagsGroup());
        this.templateFactory.addComponents(openAPI.getComponents().getSchemas());
        List<AuthSchemaObject> authSchemaList = MapperAuthUtil.createAuthSchemaList(openAPI);
        GlobalObject globalObject = MapperPathUtil.mapOpenApiObjectToOurModels(openAPI, fileSpec, authSchemaList);
        for (Map.Entry<String, HashMap<String, PathItem>> apisEntry : apis.entrySet()) {
            this.templateFactory.addPathItems(apisEntry.getValue());
            ArrayList<PathObject> pathObject = MapperPathUtil.mapPathObjects(fileSpec, apisEntry, globalObject);
            AuthObject authObject = MapperAuthUtil.getApiAuthObject(globalObject.getAuthSchemas(), pathObject);
            this.templateFactory.fillTemplate(filePathToSave, fileSpec, apisEntry.getKey().substring(0, 1).toUpperCase() + apisEntry.getKey().substring(1), pathObject, authObject);
            if (!fileSpec.getCallMode().booleanValue()) continue;
            this.addAuthentications(authObject);
        }
    }

    private void addAuthentications(AuthObject authObject) {
        if (null != authObject.getSecurityRequirements() && !authObject.getSecurityRequirements().isEmpty()) {
            authObject.getSecurityRequirements().forEach(authType -> {
                if (!this.authentications.contains(authType)) {
                    this.authentications.add((String)authType);
                }
            });
        }
    }

    private void createModelTemplate(FileSpec fileSpec, OpenAPI openAPI) {
        String fileModelToSave = this.processPath(fileSpec.getModelPackage(), true);
        List<String> listObjectsToCreate = OpenApiUtil.getListComponentsObjects(openAPI);
        String modelPackage = this.processModelPackage(fileSpec.getModelPackage());
        HashMap<String, Schema> basicSchemaMap = OpenApiUtil.processBasicSchemas(openAPI);
        this.templateFactory.setModelPackageName(modelPackage);
        listObjectsToCreate.forEach(pojoName -> {
            try {
                this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), MapperContentUtil.mapComponentToSchemaObject((Schema)openAPI.getComponents().getSchemas().get(pojoName), pojoName, fileSpec, modelPackage));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            basicSchemaMap.forEach((schemaName, basicSchema) -> {
                try {
                    this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), MapperContentUtil.mapComponentToSchemaObject(basicSchema, schemaName, fileSpec, modelPackage));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
    }

    private void processPackage(String apiPackage) {
        if (StringUtils.isNotBlank((CharSequence)apiPackage)) {
            this.templateFactory.setPackageName(apiPackage.trim());
        } else if (this.project.getModel().getGroupId() != null) {
            this.templateFactory.setPackageName(this.project.getModel().getGroupId());
        } else {
            this.templateFactory.setPackageName(DEFAULT_OPENAPI_TARGET_PACKAGE);
        }
    }

    private String processModelPackage(String modelPackage) {
        Object modelReturnPackage = "";
        modelReturnPackage = StringUtils.isNotBlank((CharSequence)modelPackage) ? modelPackage.trim() : (this.project.getModel().getGroupId() != null ? this.project.getModel().getGroupId() + ".model" : DEFAULT_OPENAPI_MODEL_PACKAGE);
        return modelReturnPackage;
    }

    private String processPath(String fileSpecPackage, Boolean isModel) {
        Path path;
        File[] pathList = Objects.requireNonNull(this.project.getBasedir().listFiles(this.targetFileFilter));
        if (pathList.length > 0) {
            path = pathList[0].toPath().resolve(this.convertPackageToTargetPath(fileSpecPackage, isModel));
        } else {
            path = this.project.getBasedir().toPath().resolve("target");
            path.toFile().mkdir();
            path = path.resolve(this.convertPackageToTargetPath(fileSpecPackage, isModel));
        }
        if (!path.toFile().isDirectory()) {
            path.toFile().mkdirs();
        }
        return path.toString();
    }

    private String convertPackageToTargetPath(String fileSpecPackage, Boolean isModel) {
        String path;
        if (StringUtils.isNotBlank((CharSequence)fileSpecPackage)) {
            path = "generated-sources/corunet/apigenerator/" + fileSpecPackage.trim().replaceAll("\\.", "/");
        } else if (this.project.getModel().getGroupId() != null) {
            path = "generated-sources/corunet/apigenerator/" + this.project.getModel().getGroupId().replaceAll("\\.", "/");
        } else {
            String pathDefault = isModel != false ? DEFAULT_OPENAPI_MODEL_PACKAGE : DEFAULT_OPENAPI_TARGET_PACKAGE;
            path = "generated-sources/corunet/apigenerator/" + pathDefault.replaceAll("\\.", "/");
        }
        return path;
    }
}

