/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.asyncapi.template;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.asyncapi.MethodObject;
import net.coru.api.generator.plugin.asyncapi.template.ClasspathTemplateLoader;

public class TemplateFactory {
    public static final String SUBSCRIBE_PACKAGE = "subscribePackage";
    public static final String SUPPLIER_PACKAGE = "supplierPackage";
    public static final String STREAM_BRIDGE_PACKAGE = "streamBridgePackage";
    public static final String SUPPLIER_ENTITIES_POSTFIX = "supplierEntitiesPostfix";
    public static final String STREAM_BRIDGE_ENTITIES_POSTFIX = "streamBridgeEntitiesPostfix";
    public static final String SUBSCRIBE_ENTITIES_POSTFIX = "subscribeEntitiesPostfix";
    public static final String FILE_TYPE_JAVA = ".java";
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
    private final Map<String, Object> root = new HashMap<String, Object>();
    private final List<MethodObject> publishMethods = new ArrayList<MethodObject>();
    private final List<MethodObject> subscribeMethods = new ArrayList<MethodObject>();
    private final List<MethodObject> streamBridgeMethods = new ArrayList<MethodObject>();
    private String subscribeFilePath = null;
    private String supplierFilePath = null;
    private String streamBridgeFilePath = null;
    private String supplierClassName = null;
    private String streamBridgeClassName = null;
    private String subscribeClassName = null;

    public TemplateFactory() {
        this.cfg.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(true);
    }

    public void fillTemplate() throws IOException, TemplateException {
        String pathToSaveMainClass;
        File fileToSave;
        this.root.put("publishMethods", this.publishMethods);
        this.root.put("subscribeMethods", this.subscribeMethods);
        this.root.put("streamBridgeMethods", this.streamBridgeMethods);
        if (!this.publishMethods.isEmpty()) {
            fileToSave = new File(this.supplierFilePath);
            pathToSaveMainClass = fileToSave.toPath().resolve(this.supplierClassName + FILE_TYPE_JAVA).toString();
            this.writeTemplateToFile("templateSuppliers.ftlh", this.root, pathToSaveMainClass);
        }
        if (!this.subscribeMethods.isEmpty()) {
            fileToSave = new File(this.subscribeFilePath);
            pathToSaveMainClass = fileToSave.toPath().resolve(this.subscribeClassName + FILE_TYPE_JAVA).toString();
            this.writeTemplateToFile("templateConsumers.ftlh", this.root, pathToSaveMainClass);
        }
        if (!this.streamBridgeMethods.isEmpty()) {
            fileToSave = new File(this.streamBridgeFilePath);
            pathToSaveMainClass = fileToSave.toPath().resolve(this.streamBridgeClassName + FILE_TYPE_JAVA).toString();
            this.writeTemplateToFile("templateStreamBridge.ftlh", this.root, pathToSaveMainClass);
        }
        this.generateInterfaces();
    }

    public void setSubscribePackageName(String packageName) {
        this.root.put(SUBSCRIBE_PACKAGE, packageName);
    }

    public void setSupplierPackageName(String packageName) {
        this.root.put(SUPPLIER_PACKAGE, packageName);
    }

    public void setStreamBridgePackageName(String packageName) {
        this.root.put(STREAM_BRIDGE_PACKAGE, packageName);
    }

    public void setSubscribeClassName(String className) {
        this.root.put("subscribeClassName", className);
        this.subscribeClassName = className;
    }

    public void setSupplierClassName(String className) {
        this.root.put("supplierClassName", className);
        this.supplierClassName = className;
    }

    public void setStreamBridgeClassName(String className) {
        this.root.put("streamBridgeClassName", className);
        this.streamBridgeClassName = className;
    }

    public void setSubscribeFilePath(Path path) {
        this.subscribeFilePath = path.toString();
    }

    public void setSupplierFilePath(Path path) {
        this.supplierFilePath = path.toString();
    }

    public void setStreamBridgeFilePath(Path path) {
        this.streamBridgeFilePath = path.toString();
    }

    public void addSupplierMethod(String operationId, String classNamespace) {
        this.publishMethods.add(new MethodObject(operationId, classNamespace, "publish"));
    }

    public void addStreamBridgeMethod(String operationId, String classNamespace, String channelName) {
        this.streamBridgeMethods.add(new MethodObject(operationId, classNamespace, "streamBridge", channelName));
    }

    public void addSubscribeMethod(String operationId, String classNamespace) {
        this.subscribeMethods.add(new MethodObject(operationId, classNamespace, "subscribe"));
    }

    public void setSupplierEntitiesPostfix(String postfix) {
        this.root.put(SUPPLIER_ENTITIES_POSTFIX, postfix);
    }

    public void setStreamBridgeEntitiesPostfix(String postfix) {
        this.root.put(STREAM_BRIDGE_ENTITIES_POSTFIX, postfix);
    }

    public void setSubscribeEntitiesPostfix(String postfix) {
        this.root.put(SUBSCRIBE_ENTITIES_POSTFIX, postfix);
    }

    public void clearData() {
        this.root.clear();
        this.publishMethods.clear();
        this.subscribeMethods.clear();
        this.subscribeFilePath = null;
        this.supplierFilePath = null;
        this.streamBridgeFilePath = null;
        this.supplierClassName = null;
        this.subscribeClassName = null;
        this.streamBridgeClassName = null;
    }

    private void generateInterfaces() throws IOException, TemplateException {
        ArrayList<MethodObject> allMethods = new ArrayList<MethodObject>(this.subscribeMethods);
        allMethods.addAll(this.publishMethods);
        HashMap<String, Object> interfaceRoot = new HashMap<String, Object>();
        interfaceRoot.put(SUBSCRIBE_PACKAGE, this.root.get(SUBSCRIBE_PACKAGE));
        interfaceRoot.put(SUPPLIER_PACKAGE, this.root.get(SUPPLIER_PACKAGE));
        interfaceRoot.put(SUPPLIER_ENTITIES_POSTFIX, this.root.get(SUPPLIER_ENTITIES_POSTFIX));
        interfaceRoot.put(SUBSCRIBE_ENTITIES_POSTFIX, this.root.get(SUBSCRIBE_ENTITIES_POSTFIX));
        for (MethodObject method : allMethods) {
            String pathToSaveMainClass;
            File fileToSave;
            interfaceRoot.put("method", method);
            if (Objects.equals(method.getType(), "publish")) {
                fileToSave = new File(this.supplierFilePath);
                pathToSaveMainClass = fileToSave.toPath().resolve("I" + method.getOperationId().substring(0, 1).toUpperCase() + method.getOperationId().substring(1) + FILE_TYPE_JAVA).toString();
                this.writeTemplateToFile("interfaceSupplier.ftlh", interfaceRoot, pathToSaveMainClass);
                continue;
            }
            if (!Objects.equals(method.getType(), "subscribe")) continue;
            fileToSave = new File(this.subscribeFilePath);
            pathToSaveMainClass = fileToSave.toPath().resolve("I" + method.getOperationId().substring(0, 1).toUpperCase() + method.getOperationId().substring(1) + FILE_TYPE_JAVA).toString();
            this.writeTemplateToFile("interfaceConsumer.ftlh", interfaceRoot, pathToSaveMainClass);
        }
    }

    private void writeTemplateToFile(String templateName, Map<String, Object> root, String path) throws IOException, TemplateException {
        Template template = this.cfg.getTemplate(templateName);
        FileWriter writer = new FileWriter(path);
        template.process(root, (Writer)writer);
        writer.close();
    }
}

