/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.template;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.model.SchemaObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.template.ClasspathTemplateLoader;

public class TemplateFactory {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
    private final Map<String, Object> root = new HashMap<String, Object>();
    private final HashMap<String, PathItem> itemHashMap = new HashMap();
    private final HashMap<String, Schema> itemSchema = new HashMap();
    private final List<String> basicDataTypes = List.of("Integer", "Long", "Float", "Double", "Boolean", "String", "Char", "Byte", "Short");

    public TemplateFactory() {
        this.cfg.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(true);
        this.root.put("checkBasicTypes", this.basicDataTypes);
    }

    public void fillTemplateSchema(String filePathToSave, Boolean useLombock, SchemaObject schemaObject) throws IOException, TemplateException {
        this.root.put("schema", schemaObject);
        this.root.put("stringBracketOpen", "{");
        this.root.put("stringBracketClose", "}");
        File fileToSave = new File(filePathToSave);
        String pathToSaveMainClass = fileToSave.toPath().resolve(schemaObject.getClassName() + ".java").toString();
        this.writeTemplateToFile(null != useLombock && useLombock != false ? "templateSchemaWithLombok.ftlh" : "templateSchema.ftlh", this.root, pathToSaveMainClass);
    }

    public void fillTemplateWebClient(String filePathToSave) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String pathToSaveMainClass = fileToSave.toPath().resolve("ApiWebClient.java").toString();
        this.writeTemplateToFile("templateWebClient.ftlh", this.root, pathToSaveMainClass);
    }

    public void fillTemplateRestClient(String filePathToSave) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String pathToSaveMainClass = fileToSave.toPath().resolve("ApiRestClient.java").toString();
        this.writeTemplateToFile("templateRestClient.ftlh", this.root, pathToSaveMainClass);
    }

    public void fillTemplateAuth(String filePathToSave, String authName) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String nameAuthClass = authName + ".java";
        String pathToSaveMainClass = fileToSave.toPath().resolve(nameAuthClass).toString();
        this.writeTemplateToFile(this.createNameTemplate(authName), this.root, pathToSaveMainClass);
    }

    public void fillTemplate(String filePathToSave, FileSpec fileSpec, String className, ArrayList<PathObject> pathObject, AuthObject authObject) throws IOException, TemplateException {
        this.root.put("className", className);
        this.root.put("itemHashMap", this.itemHashMap);
        this.root.put("pathObject", pathObject);
        if (Objects.nonNull(fileSpec.getApiPackage())) {
            this.root.put("packageApi", fileSpec.getApiPackage());
        }
        if (Objects.nonNull(fileSpec.getModelPackage())) {
            this.root.put("packageModel", fileSpec.getModelPackage());
        }
        File fileToSave = new File(filePathToSave);
        if (fileSpec.getCallMode().booleanValue()) {
            this.root.put("authObject", authObject);
        }
        String pathToSaveMainClass = fileToSave.toPath().resolve(className + "Api.java").toString();
        this.writeTemplateToFile(fileSpec.getCallMode() != false ? this.getTemplateClientApi(fileSpec) : this.getTemplateApi(fileSpec), this.root, pathToSaveMainClass);
    }

    private void writeTemplateToFile(String templateName, Map<String, Object> root, String path) throws IOException, TemplateException {
        Template template = this.cfg.getTemplate(templateName);
        FileWriter writer = new FileWriter(path);
        template.process(root, (Writer)writer);
        writer.close();
    }

    public void setPackageName(String packageName) {
        this.root.put("package", packageName);
    }

    public void setModelPackageName(String packageName) {
        this.root.put("packageModel", packageName);
    }

    public void setWebClientPackageName(String packageName) {
        this.root.put("packageClient", packageName);
    }

    public void setAuthPackageName(String packageName) {
        this.root.put("packageAuth", packageName);
    }

    public void addPathItems(HashMap<String, PathItem> itemMap) {
        this.itemHashMap.putAll(itemMap);
    }

    public void addComponents(Map<String, Schema> itemMap) {
        this.itemSchema.putAll(itemMap);
    }

    private String createNameTemplate(String classNameAuth) {
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("template").append(classNameAuth).append(".ftlh");
        return buffer.toString();
    }

    private String getTemplateClientApi(FileSpec fileSpec) {
        return fileSpec.getIsReactive() != false ? "templateCallWebClient.ftlh" : "templateCallRestClient.ftlh";
    }

    private String getTemplateApi(FileSpec fileSpec) {
        return fileSpec.getIsReactive() != false ? "templateReactive.ftlh" : "template.ftlh";
    }
}

