/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import org.apache.maven.plugin.MojoExecutionException;

public class OpenApiUtil {
    public static HashMap<String, HashMap<String, PathItem>> mapApiGroups(OpenAPI openAPI, Boolean groupByTags) {
        HashMap<String, HashMap<String, PathItem>> mapApis = new HashMap<String, HashMap<String, PathItem>>();
        if (!openAPI.getPaths().isEmpty()) {
            mapApis = null != groupByTags && groupByTags != false ? OpenApiUtil.mapApiGroupsByTags(openAPI) : OpenApiUtil.mapApiGroupsByUrl(openAPI);
        }
        return mapApis;
    }

    private static HashMap<String, HashMap<String, PathItem>> mapApiGroupsByTags(OpenAPI openAPI) {
        HashMap<String, HashMap<String, PathItem>> mapApis = new HashMap<String, HashMap<String, PathItem>>();
        for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
            HashMap<String, PathItem> mapPathItemsByTag = OpenApiUtil.getMapPathItemsByTag((PathItem)openAPIGetPathsEntry.getValue());
            for (Map.Entry<String, PathItem> mapPathItems : mapPathItemsByTag.entrySet()) {
                if (!mapApis.containsKey(mapPathItems.getKey())) {
                    mapApis.put(mapPathItems.getKey(), new HashMap());
                }
                mapApis.get(mapPathItems.getKey()).put((String)openAPIGetPathsEntry.getKey(), mapPathItems.getValue());
            }
        }
        return mapApis;
    }

    private static HashMap<String, PathItem> getMapPathItemsByTag(PathItem pathItem) {
        HashMap<String, PathItem> mapByTag = new HashMap<String, PathItem>();
        for (Map.Entry operation : pathItem.readOperationsMap().entrySet()) {
            if (null == ((Operation)operation.getValue()).getTags() || ((Operation)operation.getValue()).getTags().isEmpty()) continue;
            PathItem pathItemClone = OpenApiUtil.pathItemOperationsClear(pathItem);
            if (!mapByTag.containsKey(((Operation)operation.getValue()).getTags().get(0))) {
                mapByTag.put((String)((Operation)operation.getValue()).getTags().get(0), pathItemClone);
            }
            mapByTag.get(((Operation)operation.getValue()).getTags().get(0)).operation((PathItem.HttpMethod)operation.getKey(), (Operation)operation.getValue());
        }
        return mapByTag;
    }

    private static PathItem pathItemOperationsClear(PathItem pathItem) {
        PathItem pathItemClone = new PathItem();
        pathItemClone = pathItem;
        pathItemClone.operation(PathItem.HttpMethod.GET, null);
        pathItemClone.operation(PathItem.HttpMethod.POST, null);
        pathItemClone.operation(PathItem.HttpMethod.DELETE, null);
        pathItemClone.operation(PathItem.HttpMethod.PATCH, null);
        pathItemClone.operation(PathItem.HttpMethod.HEAD, null);
        pathItemClone.operation(PathItem.HttpMethod.OPTIONS, null);
        pathItemClone.operation(PathItem.HttpMethod.TRACE, null);
        pathItemClone.operation(PathItem.HttpMethod.PUT, null);
        return pathItemClone;
    }

    private static HashMap<String, HashMap<String, PathItem>> mapApiGroupsByUrl(OpenAPI openAPI) {
        HashMap<String, HashMap<String, PathItem>> mapByUrl = new HashMap<String, HashMap<String, PathItem>>();
        for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
            String[] pathName = ((String)openAPIGetPathsEntry.getKey()).split("/");
            if (!mapByUrl.containsKey(pathName[1])) {
                mapByUrl.put(pathName[1], new HashMap());
            }
            mapByUrl.get(pathName[1]).put((String)openAPIGetPathsEntry.getKey(), (PathItem)openAPIGetPathsEntry.getValue());
        }
        return mapByUrl;
    }

    public static OpenAPI getPojoFromSwagger(FileSpec fileSpec) throws MojoExecutionException {
        OpenAPI openAPI;
        try {
            SwaggerParseResult result = new OpenAPIParser().readLocation(fileSpec.getInputSpec(), null, null);
            openAPI = result.getOpenAPI();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Code generation failed when parser the .yaml file ");
        }
        if (openAPI == null) {
            throw new MojoExecutionException("Code generation failed why .yaml is empty");
        }
        return openAPI;
    }

    public static List<String> getListComponentsObjects(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        ArrayList<String> listObject = new ArrayList<String>();
        if (null == components.getSchemas() || components.getSchemas().isEmpty()) {
            return listObject;
        }
        components.getSchemas().forEach((key, value) -> {
            if (value.getType().equals("object")) {
                listObject.add((String)key);
            }
        });
        return listObject;
    }

    public static HashMap<String, Schema> processBasicSchemas(OpenAPI openApi) {
        HashMap<String, Schema> basicSchemaMap = new HashMap<String, Schema>();
        for (Map.Entry pathItem : openApi.getPaths().entrySet()) {
            if (Objects.nonNull(((PathItem)pathItem.getValue()).getGet())) {
                OpenApiUtil.processContentSchema(basicSchemaMap, ((PathItem)pathItem.getValue()).getGet());
            }
            if (Objects.nonNull(((PathItem)pathItem.getValue()).getPost())) {
                OpenApiUtil.processContentSchema(basicSchemaMap, ((PathItem)pathItem.getValue()).getPost());
            }
            if (Objects.nonNull(((PathItem)pathItem.getValue()).getPut())) {
                OpenApiUtil.processContentSchema(basicSchemaMap, ((PathItem)pathItem.getValue()).getPost());
            }
            if (Objects.nonNull(((PathItem)pathItem.getValue()).getDelete())) {
                OpenApiUtil.processContentSchema(basicSchemaMap, ((PathItem)pathItem.getValue()).getPost());
            }
            if (!Objects.nonNull(((PathItem)pathItem.getValue()).getPatch())) continue;
            OpenApiUtil.processContentSchema(basicSchemaMap, ((PathItem)pathItem.getValue()).getPatch());
        }
        return basicSchemaMap;
    }

    private static void processContentSchema(HashMap<String, Schema> basicSchemaMap, Operation operation) {
        if (Objects.nonNull(operation.getRequestBody()) && Objects.nonNull(operation.getRequestBody().getContent())) {
            String firstLetter = operation.getOperationId().substring(0, 1);
            String remainingLetters = operation.getOperationId().substring(1);
            String operationId = firstLetter.toUpperCase() + remainingLetters;
            operation.getRequestBody().getContent().entrySet().forEach(content -> basicSchemaMap.put("InlineObject" + operationId, ((MediaType)content.getValue()).getSchema()));
        }
        for (Map.Entry response : operation.getResponses().entrySet()) {
            if (!Objects.nonNull(((ApiResponse)response.getValue()).getContent())) continue;
            ((ApiResponse)response.getValue()).getContent().entrySet().forEach(content -> basicSchemaMap.put("InlineResponse" + (String)response.getKey(), ((MediaType)content.getValue()).getSchema()));
        }
    }
}

