/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.asyncapi.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private static final List<String> templateFiles = List.of("templateSuppliers.ftlh", "interfaceConsumer.ftlh", "templateConsumers.ftlh", "interfaceSupplier.ftlh", "templateStreamBridge.ftlh");
    private final Map<String, String> templatesMap = new HashMap<String, String>();
    private static final ClassLoader loader = ClasspathTemplateLoader.class.getClassLoader();

    public ClasspathTemplateLoader() {
        try {
            this.templatesMap.putAll(this.getResourceFolderFiles());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public Object findTemplateSource(String templateName) {
        return this.templatesMap.get(templateName);
    }

    public long getLastModified(Object o) {
        return 0L;
    }

    public Reader getReader(Object template, String charSet) {
        return new StringReader(template.toString());
    }

    public void closeTemplateSource(Object o) {
    }

    private Map<String, String> getResourceFolderFiles() throws URISyntaxException {
        HashMap<String, String> templates = new HashMap<String, String>();
        try {
            for (String templateFile : templateFiles) {
                templates.put(templateFile, this.readFile((InputStream)Objects.requireNonNull(loader.getResource("templates/functional/" + templateFile)).getContent()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return templates;
    }

    private String readFile(InputStream file) throws IOException {
        return new String(file.readAllBytes());
    }
}

