/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private static final List<String> templateFiles = List.of("template.ftlh", "templateSchema.ftlh", "templateSchemaWithLombok.ftlh", "templateCallWebClient.ftlh", "templateWebClient.ftlh", "templateCallRestClient.ftlh", "templateRestClient.ftlh", "templateReactive.ftlh");
    private static final List<String> templateAuthFiles = List.of("templateApiKeyAuth.ftlh", "templateAuthentication.ftlh", "templateHttpBasicAuth.ftlh", "templateHttpBearerAuth.ftlh", "templateOAuth.ftlh", "templateOAuthFlow.ftlh");
    private final Map<String, String> templatesMap = new HashMap<String, String>();
    private static final ClassLoader loader = ClasspathTemplateLoader.class.getClassLoader();

    public ClasspathTemplateLoader() {
        try {
            this.templatesMap.putAll(this.getResourceFolderFiles());
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public Object findTemplateSource(String templateName) throws IOException {
        return this.templatesMap.get(templateName);
    }

    public long getLastModified(Object o) {
        return 0L;
    }

    public Reader getReader(Object template, String charSet) throws IOException {
        return new StringReader(template.toString());
    }

    public void closeTemplateSource(Object o) throws IOException {
    }

    private Map<String, String> getResourceFolderFiles() throws MalformedURLException, URISyntaxException {
        HashMap<String, String> templates = new HashMap<String, String>();
        templateFiles.forEach(templateFile -> {
            try {
                templates.put((String)templateFile, this.readFile((InputStream)Objects.requireNonNull(loader.getResource("templates/openapi/" + templateFile)).getContent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        templateAuthFiles.forEach(templateAuthFile -> {
            try {
                templates.put((String)templateAuthFile, this.readFile((InputStream)Objects.requireNonNull(loader.getResource("templates/openapi/authTemplates/" + templateAuthFile)).getContent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return templates;
    }

    private String readFile(InputStream file) throws IOException {
        return new String(file.readAllBytes());
    }
}

