/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.OperationObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;

public class MapperAuthUtil {
    public static List<AuthSchemaObject> createAuthSchemaList(OpenAPI openAPI) {
        ArrayList<AuthSchemaObject> authList = new ArrayList<AuthSchemaObject>();
        if (null != openAPI.getComponents().getSecuritySchemes() && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
            openAPI.getComponents().getSecuritySchemes().forEach((key, value) -> {
                AuthSchemaObject authSchema = AuthSchemaObject.builder().type(value.getType().toString().equalsIgnoreCase("http") && value.getScheme().equalsIgnoreCase("bearer") ? "HttpBearerAuth" : MapperAuthUtil.getModelTypeAuth(value)).name((String)key).apiKeyParam(value.getType().toString().equalsIgnoreCase("apiKey") ? value.getName() : "").apiKeyPlace(value.getType().toString().equalsIgnoreCase("apiKey") ? value.getIn().toString() : "").bearerSchema(value.getType().toString().equalsIgnoreCase("http") && value.getScheme().equalsIgnoreCase("bearer") ? value.getScheme() : "").build();
                authList.add(authSchema);
            });
        }
        return authList;
    }

    private static String getModelTypeAuth(SecurityScheme securityScheme) {
        String type = securityScheme.getType().toString();
        if (securityScheme.getType().toString().equalsIgnoreCase("apiKey")) {
            type = "ApiKeyAuth";
        } else if (securityScheme.getType().toString().equalsIgnoreCase("oauth2")) {
            type = "OAuth";
        } else if (securityScheme.getType().toString().equalsIgnoreCase("http")) {
            type = "HttpBasicAuth";
        }
        return type;
    }

    public static AuthObject getApiAuthObject(List<AuthSchemaObject> authSchemas, List<PathObject> pathObjects) {
        List<String> authList = MapperAuthUtil.getApiAuthNames(pathObjects);
        ArrayList<String> authApiList = new ArrayList<String>();
        if (null != authSchemas && !authSchemas.isEmpty() && !authList.isEmpty()) {
            authSchemas.forEach(authValue -> {
                if (authList.contains(authValue.getName()) && !authApiList.contains(authValue.getType())) {
                    authApiList.add(authValue.getType());
                }
            });
        }
        return AuthObject.builder().securityRequirements(authApiList).build();
    }

    private static List<String> getApiAuthNames(List<PathObject> pathObjects) {
        ArrayList<OperationObject> operationList = new ArrayList<OperationObject>();
        pathObjects.forEach(pathObject -> operationList.addAll(pathObject.getOperationObject()));
        return MapperAuthUtil.addApiAuthNames(operationList);
    }

    private static List<String> addApiAuthNames(List<OperationObject> operationList) {
        ArrayList<String> authList = new ArrayList<String>();
        operationList.forEach(operationObject -> {
            if (null != operationObject.getSecurity() && !operationObject.getSecurity().isEmpty()) {
                operationObject.getSecurity().forEach(auth -> {
                    if (!authList.contains(auth)) {
                        authList.add((String)auth);
                    }
                });
            }
        });
        return authList;
    }
}

