/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.model.SchemaFieldObject;
import net.coru.api.generator.plugin.openapi.model.SchemaObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.utils.MapperUtil;
import org.apache.commons.lang3.StringUtils;

public class MapperContentUtil {
    public static SchemaObject mapComponentToSchemaObject(Schema schema, String nameSchema, FileSpec fileSpec, String modelPackage) {
        List<SchemaFieldObject> listSchema = MapperContentUtil.getFields(schema, fileSpec);
        return SchemaObject.builder().description(schema.getDescription()).schemaName(schema.getName()).className(MapperUtil.getPojoName(nameSchema, fileSpec)).importList(MapperContentUtil.getImportList(listSchema, modelPackage)).fieldObjectList(listSchema).build();
    }

    private static List<String> getImportList(List<SchemaFieldObject> fieldObjectList, String modelPackage) {
        HashMap<String, List> listHashMap = new HashMap<String, List>();
        ArrayList<String> importList = new ArrayList<String>();
        fieldObjectList.forEach(fieldObject -> {
            ArrayList<Object> arrayImport;
            if (fieldObject.getDataTypeSimple().equals("array") && !listHashMap.containsKey("array")) {
                arrayImport = new ArrayList<Object>();
                arrayImport.add("java.util.List");
                arrayImport.add("java.util.ArrayList");
                listHashMap.put("array", arrayImport);
            }
            if (Objects.equals(fieldObject.getDataTypeSimple(), "map") && !listHashMap.containsKey("map")) {
                arrayImport = new ArrayList();
                arrayImport.add("java.util.Map");
                arrayImport.add("java.util.HashMap");
                listHashMap.put("map", arrayImport);
            }
            if (StringUtils.isNotBlank((CharSequence)fieldObject.getImportClass()) && !listHashMap.containsKey(fieldObject.getImportClass())) {
                arrayImport = new ArrayList();
                arrayImport.add(modelPackage + "." + fieldObject.getImportClass());
                listHashMap.put(fieldObject.getImportClass(), arrayImport);
            }
        });
        if (!listHashMap.isEmpty()) {
            listHashMap.forEach((key, value) -> importList.addAll((Collection<String>)value));
        }
        return importList;
    }

    private static List<SchemaFieldObject> getFields(Schema schema, FileSpec fileSpec) {
        ArrayList<SchemaFieldObject> fieldObjectArrayList = new ArrayList<SchemaFieldObject>();
        HashMap<String, Schema> mapperProperties = new HashMap<String, Schema>(schema.getProperties());
        mapperProperties.forEach((key, value) -> {
            SchemaFieldObject field = SchemaFieldObject.builder().baseName((String)key).dataTypeSimple(MapperUtil.getSimpleType(value)).build();
            if (value instanceof ArraySchema) {
                String typeArray = MapperUtil.getTypeArray((ArraySchema)value, fileSpec);
                field.setDataType(typeArray);
                field.setImportClass(MapperContentUtil.getImportClass(typeArray));
            } else if (value instanceof MapSchema) {
                String typeMap = MapperUtil.getTypeMap((MapSchema)value, fileSpec);
                field.setDataTypeSimple("map");
                field.setDataType(typeMap);
                field.setImportClass(MapperContentUtil.getImportClass(typeMap));
            } else if (value.getType().equals("object")) {
                String typeObject = "";
                if (StringUtils.isNotBlank((CharSequence)value.get$ref())) {
                    String[] pathObjectRef = schema.get$ref().split("/");
                    typeObject = MapperUtil.getPojoName(pathObjectRef[pathObjectRef.length - 1], fileSpec);
                }
                field.setImportClass(MapperContentUtil.getImportClass(typeObject));
                field.setDataType(typeObject);
            }
            fieldObjectArrayList.add(field);
        });
        return fieldObjectArrayList;
    }

    private static String getImportClass(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !type.equals("String") && !type.equals("Integer") ? type : "";
    }
}

