/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.coru.api.generator.plugin.exception.SCSMultiApiMavenPluginException;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.BasicTypeConstants;
import net.coru.api.generator.plugin.openapi.model.ContentObject;
import net.coru.api.generator.plugin.openapi.model.GlobalObject;
import net.coru.api.generator.plugin.openapi.model.OperationObject;
import net.coru.api.generator.plugin.openapi.model.ParameterObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.model.RequestObject;
import net.coru.api.generator.plugin.openapi.model.ResponseObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.utils.MapperUtil;
import org.apache.commons.lang3.StringUtils;

public class MapperPathUtil {
    public static GlobalObject mapOpenApiObjectToOurModels(OpenAPI openAPI, FileSpec fileSpec, List<AuthSchemaObject> authSchemaList) {
        List<String> authList = MapperPathUtil.getSecurityRequirementList(openAPI.getSecurity(), new ArrayList<String>());
        return GlobalObject.builder().url(((Server)openAPI.getServers().get(0)).getUrl()).version(openAPI.getInfo().getVersion()).title(openAPI.getInfo().getTitle()).license(openAPI.getInfo().getLicense().getName()).authSchemas(authSchemaList).authentications(authList).componentsTypeMap(MapperPathUtil.getMapComponentsTypes(openAPI.getComponents(), fileSpec)).build();
    }

    private static HashMap<String, String> getMapComponentsTypes(Components components, FileSpec fileSpec) {
        HashMap<String, String> mapComponents = new HashMap<String, String>();
        if (null == components.getSchemas() || components.getSchemas().isEmpty()) {
            return mapComponents;
        }
        components.getSchemas().forEach((key, value) -> {
            if (!mapComponents.containsKey(key)) {
                String type = MapperPathUtil.checkSchemaType(value, fileSpec);
                mapComponents.put((String)key, type.equalsIgnoreCase("object") ? MapperUtil.getPojoName(key, fileSpec) : type);
            }
        });
        return mapComponents;
    }

    private static String checkSchemaType(Schema schema, FileSpec fileSpec) {
        Object dataType = schema.getType();
        if (schema instanceof ArraySchema) {
            dataType = "array-" + MapperUtil.getTypeArray((ArraySchema)schema, fileSpec);
        } else if (schema instanceof MapSchema) {
            dataType = "map-" + MapperUtil.getTypeMap((MapSchema)schema, fileSpec);
        } else if (schema.getType().equals("object") && StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            String[] pathObjectRef = schema.get$ref().split("/");
            dataType = MapperUtil.getPojoName(pathObjectRef[pathObjectRef.length - 1], fileSpec);
        }
        return dataType;
    }

    public static ArrayList<PathObject> mapPathObjects(FileSpec fileSpec, Map.Entry<String, HashMap<String, PathItem>> path, GlobalObject globalObject) {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        for (Map.Entry<String, PathItem> pathItem : path.getValue().entrySet()) {
            if (Objects.nonNull(pathItem.getValue().getParameters())) {
                globalObject.setParameterObjects(MapperPathUtil.mapGlobalParameterObjects(pathItem.getValue().getParameters()));
            }
            PathObject pathObject = PathObject.builder().pathName(pathItem.getKey()).globalObjects(globalObject).operationObject(MapperPathUtil.mapOperationObject(fileSpec, pathItem, globalObject)).build();
            pathObjects.add(pathObject);
        }
        return pathObjects;
    }

    private static List<OperationObject> mapOperationObject(FileSpec fileSpec, Map.Entry<String, PathItem> path, GlobalObject globalObject) {
        ArrayList<OperationObject> operationObjects = new ArrayList<OperationObject>();
        ArrayList<String> operationIdList = new ArrayList<String>();
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getGet()))) {
            operationObjects.add(MapperPathUtil.createOperation(path.getValue().getGet(), "GET", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPost()))) {
            operationObjects.add(MapperPathUtil.createOperation(path.getValue().getPost(), "POST", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getDelete()))) {
            operationObjects.add(MapperPathUtil.createOperation(path.getValue().getDelete(), "DELETE", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPut()))) {
            operationObjects.add(MapperPathUtil.createOperation(path.getValue().getPut(), "PUT", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPatch()))) {
            operationObjects.add(MapperPathUtil.createOperation(path.getValue().getPatch(), "PATCH", fileSpec, globalObject, operationIdList));
        }
        return operationObjects;
    }

    private static OperationObject createOperation(Operation operation, String operationType, FileSpec fileSpec, GlobalObject globalObject, List<String> operationIdList) {
        return OperationObject.builder().operationId(MapperPathUtil.mapOperationId(operation.getOperationId(), operationIdList)).operationType(operationType).summary(operation.getSummary()).tags(operation.getTags()).requestObjects(MapperPathUtil.mapRequestObject(fileSpec, operation, globalObject)).responseObjects(MapperPathUtil.mapResponseObject(fileSpec, operation.getResponses(), globalObject)).parameterObjects(MapperPathUtil.mapParameterObjects(operation.getParameters(), globalObject)).security(MapperPathUtil.getSecurityRequirementList(operation.getSecurity(), globalObject.getAuthentications())).consumes(MapperPathUtil.getConsumesList(operation.getRequestBody())).produces(MapperPathUtil.getProducesList(operation.getResponses())).build();
    }

    private static String mapOperationId(String operationId, List<String> operationIdList) {
        if (operationIdList.contains(operationId)) {
            throw new SCSMultiApiMavenPluginException("Do not write the same operationId twice");
        }
        operationIdList.add(operationId);
        return operationId;
    }

    private static List<String> getConsumesList(RequestBody requestBody) {
        ArrayList<String> consumesList = new ArrayList<String>();
        if (requestBody != null && requestBody.getContent() != null && !requestBody.getContent().isEmpty()) {
            Set consumes = requestBody.getContent().keySet();
            consumes.forEach(key -> {
                if (!key.equalsIgnoreCase("*/*")) {
                    consumesList.add(key.replace("\"", "\\\""));
                }
            });
        }
        return consumesList;
    }

    private static List<String> getProducesList(ApiResponses responses) {
        ArrayList<String> producesList = new ArrayList<String>();
        if (!Objects.nonNull(responses) || responses.isEmpty()) {
            return producesList;
        }
        responses.entrySet().forEach(inputResponse -> {
            if (inputResponse.getValue() != null && ((ApiResponse)inputResponse.getValue()).getContent() != null && !((ApiResponse)inputResponse.getValue()).getContent().isEmpty()) {
                Set produces = ((ApiResponse)inputResponse.getValue()).getContent().keySet();
                produces.forEach(key -> {
                    if (!key.equalsIgnoreCase("*/*") && !producesList.contains(key)) {
                        producesList.add(key.replace("\"", "\\\""));
                    }
                });
            }
        });
        return producesList;
    }

    private static List<RequestObject> mapRequestObject(FileSpec fileSpec, Operation operation, GlobalObject globalObject) {
        ArrayList<RequestObject> requestObjects = new ArrayList<RequestObject>();
        String firstLetter = operation.getOperationId().substring(0, 1);
        String remainingLetters = operation.getOperationId().substring(1);
        String operationId = firstLetter.toUpperCase() + remainingLetters;
        if (Objects.nonNull(operation.getRequestBody())) {
            requestObjects.add(RequestObject.builder().description(operation.getRequestBody().getDescription()).required(operation.getRequestBody().getRequired()).contentObject(MapperPathUtil.mapContentObject(fileSpec, operation.getRequestBody().getContent(), "InlineObject" + operationId, globalObject)).build());
        }
        return requestObjects;
    }

    private static List<ParameterObject> mapParameterObjects(List<Parameter> parameters, GlobalObject globalObject) {
        ArrayList<ParameterObject> parameterObjects = new ArrayList<ParameterObject>();
        if (Objects.nonNull(globalObject.getParameterObjects())) {
            if (Objects.nonNull(globalObject.getParameterObjects()) && Objects.nonNull(parameters)) {
                throw new SCSMultiApiMavenPluginException("Defining parameters in both Path and Operations is not supported in this plugin");
            }
            globalObject.getParameterObjects().forEach(parameter -> parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(parameter.getClassName()).isCollection(parameter.getIsCollection()).build()));
        } else if (Objects.nonNull(parameters)) {
            parameters.forEach(parameter -> parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(MapperUtil.getSimpleType(parameter.getSchema())).isCollection(parameter.getSchema().getType().equalsIgnoreCase("array")).build()));
        }
        return parameterObjects;
    }

    private static List<ParameterObject> mapGlobalParameterObjects(List<Parameter> parameters) {
        ArrayList<ParameterObject> parameterObjects = new ArrayList<ParameterObject>();
        if (Objects.nonNull(parameters)) {
            parameters.forEach(parameter -> parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(MapperUtil.getSimpleType(parameter.getSchema())).isCollection(parameter.getSchema().getType().equalsIgnoreCase("array")).build()));
        }
        return parameterObjects;
    }

    private static List<ResponseObject> mapResponseObject(FileSpec fileSpec, ApiResponses responses, GlobalObject globalObject) {
        ArrayList<ResponseObject> responseObjects = new ArrayList<ResponseObject>();
        if (Objects.nonNull(responses)) {
            for (Map.Entry response : responses.entrySet()) {
                responseObjects.add(ResponseObject.builder().responseName((String)response.getKey()).description(((ApiResponse)response.getValue()).getDescription()).contentObject(MapperPathUtil.mapContentObject(fileSpec, ((ApiResponse)response.getValue()).getContent(), "InlineResponse" + (String)response.getKey(), globalObject)).build());
            }
        }
        return responseObjects;
    }

    private static List<ContentObject> mapContentObject(FileSpec fileSpec, Content content, String inlineObject, GlobalObject globalObject) {
        ArrayList<ContentObject> contentObjects = new ArrayList<ContentObject>();
        if (Objects.nonNull(content)) {
            for (Map.Entry mediaTypeEntry : content.entrySet()) {
                if (Objects.nonNull(((MediaType)mediaTypeEntry.getValue()).getSchema().getProperties())) {
                    contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).description(((MediaType)mediaTypeEntry.getValue()).getSchema().getDescription()).importName(MapperUtil.getPojoName(inlineObject, fileSpec)).refName(MapperUtil.getPojoName(inlineObject, fileSpec)).build());
                    continue;
                }
                if (Objects.nonNull(((MediaType)mediaTypeEntry.getValue()).getSchema().getType()) && BasicTypeConstants.BASIC_OBJECT_TYPE.contains(((MediaType)mediaTypeEntry.getValue()).getSchema().getType())) {
                    contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).description(((MediaType)mediaTypeEntry.getValue()).getSchema().getDescription()).refName(MapperPathUtil.defineTypeName(((MediaType)mediaTypeEntry.getValue()).getSchema())).build());
                    continue;
                }
                contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).description(((MediaType)mediaTypeEntry.getValue()).getSchema().getDescription()).importName(MapperPathUtil.mapRefName(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).refName(MapperPathUtil.mapRefName(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).build());
            }
        }
        return contentObjects;
    }

    private static String defineTypeName(Schema schema) {
        String typeName = "";
        switch (schema.getType()) {
            case "integer": {
                if ("int32".equalsIgnoreCase(schema.getFormat()) || !Objects.nonNull(schema.getFormat())) {
                    typeName = "Integer";
                    break;
                }
                if (!"int64".equalsIgnoreCase(schema.getFormat())) break;
                typeName = "Long";
                break;
            }
            case "number": {
                if ("float".equalsIgnoreCase(schema.getFormat())) {
                    typeName = "Float";
                    break;
                }
                if ("double".equalsIgnoreCase(schema.getFormat())) {
                    typeName = "Double";
                    break;
                }
                if (!schema.getFormat().isEmpty()) break;
                typeName = "Integer";
                break;
            }
            case "boolean": {
                typeName = "Boolean";
                break;
            }
            default: {
                typeName = "String";
            }
        }
        return typeName;
    }

    private static String mapDataType(Schema schema, Map<String, String> componentsTypes) {
        String type = MapperPathUtil.getSchemaType(schema, componentsTypes);
        return StringUtils.isNotBlank((CharSequence)type) ? type : "";
    }

    private static String getSchemaType(Schema schema, Map<String, String> componentsTypes) {
        String dataType = schema.getType();
        if (!StringUtils.isNotBlank((CharSequence)dataType) && Objects.nonNull(schema.get$ref())) {
            String[] wholeRef = schema.get$ref().split("/");
            dataType = componentsTypes.getOrDefault(wholeRef[wholeRef.length - 1], "");
        }
        return dataType.startsWith("array") ? "array" : (dataType.startsWith("map") ? "map" : dataType);
    }

    private static String mapRefName(Schema schema, Map<String, String> componentsTypes) {
        String refSchema = "";
        if ("array".equalsIgnoreCase(schema.getType())) {
            ArraySchema arraySchema = (ArraySchema)schema;
            refSchema = arraySchema.getItems().get$ref();
        }
        if (Objects.nonNull(schema.get$ref())) {
            refSchema = schema.get$ref();
        }
        return StringUtils.isNotBlank((CharSequence)refSchema) ? MapperPathUtil.getRefSchema(refSchema, componentsTypes) : "";
    }

    private static String getRefSchema(String refSchema, Map<String, String> componentsTypes) {
        String[] wholeRef = refSchema.split("/");
        String refName = componentsTypes.getOrDefault(wholeRef[wholeRef.length - 1], "");
        if (StringUtils.isNotBlank((CharSequence)refName) && refName.contains("-")) {
            String[] wholeRefName = refName.split("-");
            refName = wholeRefName[wholeRefName.length - 1];
        }
        return refName;
    }

    private static Boolean checkIfOperationIsNull(Operation operation) {
        return Objects.nonNull(operation);
    }

    private static List<String> getSecurityRequirementList(List<SecurityRequirement> securityRequirementList, List<String> authentications) {
        ArrayList<String> authSecList = new ArrayList<String>();
        if (null == securityRequirementList || securityRequirementList.isEmpty()) {
            return authentications;
        }
        securityRequirementList.forEach(securityRequirement -> securityRequirement.forEach((key, value) -> authSecList.add((String)key)));
        return authSecList;
    }
}

