/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.asyncapi.exception.AsyncApiGeneratedSourceFolderException;
import net.coru.api.generator.plugin.asyncapi.exception.ChannelNameException;
import net.coru.api.generator.plugin.asyncapi.exception.DuplicateClassException;
import net.coru.api.generator.plugin.asyncapi.exception.DuplicatedOperationException;
import net.coru.api.generator.plugin.asyncapi.exception.ExternalRefComponentNotFoundException;
import net.coru.api.generator.plugin.asyncapi.exception.FileSystemException;
import net.coru.api.generator.plugin.asyncapi.parameter.FileSpec;
import net.coru.api.generator.plugin.asyncapi.parameter.OperationParameterObject;
import net.coru.api.generator.plugin.asyncapi.template.TemplateFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="asyncapi-generation", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class OpenAsyncMojo
extends AbstractMojo {
    public static final String SUBSCRIBE = "subscribe";
    public static final String PUBLISH = "publish";
    public static final String OPERATION_ID = "operationId";
    private static final String DEFAULT_ASYNCAPI_TARGET_PACKAGE = "net.coru.apigenerator.asyncapi";
    private static final String DEFAULT_ASYNCAPI_MODEL_PACKAGE = "net.coru.apigenerator.asyncapi.model";
    private static final String CONSUMER_CLASS_NAME = "Subscriber";
    private static final String SUPPLIER_CLASS_NAME = "Producer";
    private static final String STREAM_BRIDGE_CLASS_NAME = "StreamBridgeProducer";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File targetFolder;
    @Parameter(property="fileSpecs")
    private List<FileSpec> fileSpecs;
    @Parameter(name="generatedSourcesFolder", property="generatedSourcesFolder", defaultValue="generated-sources")
    private String generatedSourcesFolder;
    private TemplateFactory templateFactory;
    private final List<String> processedOperationIds = new ArrayList<String>();
    private final List<String> processedClassnames = new ArrayList<String>();
    private final List<String> processedTargetPackages = new ArrayList<String>();
    private String processedGeneratedSourcesFolder;
    private final FilenameFilter targetFileFilter = (dir, name) -> name.toLowerCase().contains(this.targetFolder.toPath().getFileName().toString());

    public void execute() {
        this.processGeneratedSourcesFolderName();
        this.addGeneratedSourcesToProject();
        this.templateFactory = new TemplateFactory();
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        for (FileSpec fileParameter : this.fileSpecs) {
            this.setUpTemplate(fileParameter);
            this.processDuplicates(fileParameter);
            Path ymlParentPath = Paths.get(fileParameter.getFilePath(), new String[0]).toAbsolutePath().getParent();
            File file = new File(fileParameter.getFilePath());
            try {
                JsonNode node = om.readTree(file);
                JsonNode internalNode = node.get("channels");
                Iterator iter = internalNode.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    JsonNode channel = (JsonNode)entry.getValue();
                    String operationId = this.getOperationId(channel);
                    JsonNode channelPayload = this.getChannelPayload(channel);
                    if (this.isValidOperation(fileParameter.getConsumer(), operationId, channel, SUBSCRIBE, true)) {
                        this.processSubscribeMethod(channelPayload, fileParameter.getConsumer().getModelPackage(), ymlParentPath);
                    } else if (this.isValidOperation(fileParameter.getSupplier(), operationId, channel, PUBLISH, Objects.isNull(fileParameter.getStreamBridge()))) {
                        this.processSupplierMethod(channelPayload, fileParameter.getSupplier().getModelPackage(), ymlParentPath);
                    } else if (this.isValidOperation(fileParameter.getStreamBridge(), operationId, channel, PUBLISH, Objects.isNull(fileParameter.getSupplier()))) {
                        this.processStreamBridgeMethod(channelPayload, fileParameter.getStreamBridge().getModelPackage(), ymlParentPath, (String)entry.getKey());
                    }
                    if (!ObjectUtils.allNull((Object[])new Object[]{fileParameter.getConsumer(), fileParameter.getSupplier(), fileParameter.getStreamBridge()})) continue;
                    if (channel.has(SUBSCRIBE)) {
                        this.processSubscribeMethod(channelPayload, null, ymlParentPath);
                        continue;
                    }
                    this.processSupplierMethod(channelPayload, null, ymlParentPath);
                }
                this.templateFactory.fillTemplate();
                this.templateFactory.clearData();
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processGeneratedSourcesFolderName() {
        if (!this.generatedSourcesFolder.matches("[a-zA-Z\\d\\-]+")) {
            throw new AsyncApiGeneratedSourceFolderException(this.generatedSourcesFolder);
        }
        this.processedGeneratedSourcesFolder = this.generatedSourcesFolder + "/apigenerator/";
    }

    private void addGeneratedSourcesToProject() {
        Path projectPath = this.targetFolder.toPath().resolve(this.processedGeneratedSourcesFolder);
        this.project.addCompileSourceRoot(projectPath.toString());
    }

    private boolean isValidOperation(OperationParameterObject operation, String operationId, JsonNode channel, String channelType, boolean excludingOperationExists) {
        List<String> operationIds;
        boolean result = operation != null ? (operationIds = operation.getOperationIds()).contains(operationId) || operationIds.isEmpty() && channel.has(channelType) && excludingOperationExists : false;
        return result;
    }

    private JsonNode getChannelPayload(JsonNode channel) {
        JsonNode payload = null;
        payload = channel.has(SUBSCRIBE) ? channel.get(SUBSCRIBE) : channel.get(PUBLISH);
        return payload;
    }

    private String getOperationId(JsonNode channel) {
        String operationId = channel.has(SUBSCRIBE) ? channel.get(SUBSCRIBE).get(OPERATION_ID).asText() : channel.get(PUBLISH).get(OPERATION_ID).asText();
        if (this.processedOperationIds.contains(operationId)) {
            throw new DuplicatedOperationException(operationId);
        }
        this.processedOperationIds.add(operationId);
        return operationId;
    }

    private void setUpTemplate(FileSpec fileParameter) {
        this.processPackage(fileParameter);
        this.processFilePaths(fileParameter);
        this.processClassnames(fileParameter);
        this.processEntitiesSuffix(fileParameter);
    }

    private void processFilePaths(FileSpec fileParameter) {
        this.templateFactory.setSupplierFilePath(this.processPath(fileParameter.getSupplier()));
        this.templateFactory.setStreamBridgeFilePath(this.processPath(fileParameter.getStreamBridge()));
        this.templateFactory.setSubscribeFilePath(this.processPath(fileParameter.getConsumer()));
    }

    private void processEntitiesSuffix(FileSpec fileParameter) {
        this.templateFactory.setSupplierEntitiesSuffix(fileParameter.getSupplier() != null && fileParameter.getSupplier().getModelNameSuffix() != null ? fileParameter.getSupplier().getModelNameSuffix() : null);
        this.templateFactory.setStreamBridgeEntitiesSuffix(fileParameter.getStreamBridge() != null && fileParameter.getStreamBridge().getModelNameSuffix() != null ? fileParameter.getStreamBridge().getModelNameSuffix() : null);
        this.templateFactory.setSubscribeEntitiesSuffix(fileParameter.getConsumer() != null && fileParameter.getConsumer().getModelNameSuffix() != null ? fileParameter.getConsumer().getModelNameSuffix() : null);
    }

    private void processDuplicates(FileSpec fileParameter) {
        OperationParameterObject operation;
        if (fileParameter.getConsumer() != null) {
            operation = fileParameter.getConsumer();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), CONSUMER_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(CONSUMER_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, CONSUMER_CLASS_NAME);
        }
        if (fileParameter.getSupplier() != null) {
            operation = fileParameter.getSupplier();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), SUPPLIER_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(SUPPLIER_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, SUPPLIER_CLASS_NAME);
        }
        if (fileParameter.getStreamBridge() != null) {
            operation = fileParameter.getStreamBridge();
            this.checkClassPackageDuplicate(operation.getClassNamePostfix(), operation.getTargetPackage(), STREAM_BRIDGE_CLASS_NAME);
        } else {
            this.checkClassPackageDuplicate(STREAM_BRIDGE_CLASS_NAME, DEFAULT_ASYNCAPI_TARGET_PACKAGE, STREAM_BRIDGE_CLASS_NAME);
        }
    }

    private void checkClassPackageDuplicate(String className, String targetPackage, String defaultClassName) {
        if (className != null && this.processedClassnames.contains(className) && targetPackage != null && this.processedTargetPackages.contains(targetPackage) && this.processedClassnames.lastIndexOf(className) == this.processedTargetPackages.lastIndexOf(targetPackage)) {
            throw new DuplicateClassException(className, targetPackage);
        }
        this.processedClassnames.add(className != null ? className : defaultClassName);
        this.processedTargetPackages.add(targetPackage != null ? targetPackage : DEFAULT_ASYNCAPI_TARGET_PACKAGE);
    }

    private void processClassnames(FileSpec fileParameter) {
        this.templateFactory.setSupplierClassName(fileParameter.getSupplier() != null && fileParameter.getSupplier().getClassNamePostfix() != null ? fileParameter.getSupplier().getClassNamePostfix() : SUPPLIER_CLASS_NAME);
        this.templateFactory.setStreamBridgeClassName(fileParameter.getStreamBridge() != null && fileParameter.getStreamBridge().getClassNamePostfix() != null ? fileParameter.getStreamBridge().getClassNamePostfix() : STREAM_BRIDGE_CLASS_NAME);
        this.templateFactory.setSubscribeClassName(fileParameter.getConsumer() != null && fileParameter.getConsumer().getClassNamePostfix() != null ? fileParameter.getConsumer().getClassNamePostfix() : CONSUMER_CLASS_NAME);
    }

    private Path processPath(OperationParameterObject operationParameter) {
        Path path;
        File[] pathList = Objects.requireNonNull(this.project.getBasedir().listFiles(this.targetFileFilter));
        if (pathList.length > 0) {
            path = pathList[0].toPath().resolve(this.convertPackageToTargetPath(operationParameter));
        } else {
            path = this.targetFolder.toPath();
            if (!path.toFile().mkdirs()) {
                throw new FileSystemException(path.toFile().getName());
            }
            path = path.resolve(this.convertPackageToTargetPath(operationParameter));
        }
        if (!path.toFile().isDirectory() && !path.toFile().mkdirs()) {
            throw new FileSystemException(path.toFile().getName());
        }
        return path;
    }

    private String convertPackageToTargetPath(OperationParameterObject operationParameter) {
        String targetPackage;
        String string = targetPackage = operationParameter != null ? operationParameter.getTargetPackage() : null;
        String path = targetPackage != null ? this.processedGeneratedSourcesFolder + targetPackage.replace(".", "/") : (this.project.getModel().getGroupId() != null ? this.processedGeneratedSourcesFolder + this.project.getModel().getGroupId().replace(".", "/") : this.processedGeneratedSourcesFolder + DEFAULT_ASYNCAPI_TARGET_PACKAGE.replace(".", "/"));
        return path;
    }

    private void processPackage(FileSpec fileParameter) {
        this.templateFactory.setSupplierPackageName(this.evaluatePackage(fileParameter.getSupplier()));
        this.templateFactory.setStreamBridgePackageName(this.evaluatePackage(fileParameter.getStreamBridge()));
        this.templateFactory.setSubscribePackageName(this.evaluatePackage(fileParameter.getConsumer()));
    }

    private String evaluatePackage(OperationParameterObject operation) {
        String evaluated = operation != null && operation.getTargetPackage() != null ? operation.getTargetPackage() : (this.project.getModel().getGroupId() != null ? this.project.getModel().getGroupId() : DEFAULT_ASYNCAPI_TARGET_PACKAGE);
        return evaluated;
    }

    private void processSupplierMethod(JsonNode channel, String modelPackage, Path ymlParentPath) throws IOException {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        this.templateFactory.addSupplierMethod((String)result.getKey(), (String)result.getValue());
    }

    private void processStreamBridgeMethod(JsonNode channel, String modelPackage, Path ymlParentPath, String channelName) throws IOException {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        String regex = "[a-zA-Z0-9\\.\\-]*";
        if (!channelName.matches("[a-zA-Z0-9\\.\\-]*")) {
            throw new ChannelNameException(channelName);
        }
        this.templateFactory.addStreamBridgeMethod((String)result.getKey(), (String)result.getValue(), channelName);
    }

    private void processSubscribeMethod(JsonNode channel, String modelPackage, Path ymlParentPath) throws IOException {
        Pair<String, String> result = this.processMethod(channel, Objects.isNull(modelPackage) ? null : modelPackage, ymlParentPath);
        this.templateFactory.addSubscribeMethod((String)result.getKey(), (String)result.getValue());
    }

    private Pair<String, String> processMethod(JsonNode channel, String modelPackage, Path ymlParentPath) throws IOException {
        JsonNode message = channel.get("message");
        String operationId = channel.get(OPERATION_ID).asText();
        String messageContent = message.get("$ref").asText();
        String namespace = "";
        if (message.get("$ref") != null) {
            if (messageContent.startsWith("#")) {
                String[] pathToObject = messageContent.split("/");
                namespace = this.processModelPackage(pathToObject[pathToObject.length - 1], modelPackage);
            } else {
                namespace = messageContent.contains("#") ? this.processExternalRef(modelPackage, ymlParentPath, message) : this.processExternalAvro(modelPackage, ymlParentPath, messageContent);
            }
        } else {
            namespace = this.processModelPackage((String)message.fieldNames().next(), modelPackage);
        }
        return new MutablePair((Object)operationId, (Object)namespace);
    }

    private String processExternalAvro(String modelPackage, Path ymlParentPath, String messageContent) {
        String avroFilePath = messageContent;
        String namespace = "";
        if (messageContent.startsWith("/")) {
            avroFilePath = avroFilePath.replaceFirst("/", "");
        }
        File avroFile = ymlParentPath.resolve(avroFilePath).toFile();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode fileTree = mapper.readTree(avroFile);
            String fullNamespace = fileTree.get("namespace").asText() + "." + fileTree.get("name").asText();
            namespace = this.processModelPackage(fullNamespace, modelPackage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return namespace;
    }

    private String processExternalRef(String modelPackage, Path ymlParentPath, JsonNode message) throws IOException {
        String[] pathToObject = message.get("$ref").asText().split("/");
        String component = pathToObject[pathToObject.length - 1];
        String[] pathToFile = message.get("$ref").asText().split("#");
        String filePath = pathToFile[0];
        File file = new File(filePath);
        if (filePath.startsWith(".")) {
            file = ymlParentPath.resolve(file.toPath()).toFile();
        }
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode node = om.readTree(file);
        JsonNode internalNode = node.get("components").get("messages");
        if (file.exists()) {
            if (Objects.nonNull(internalNode.findValue(component))) {
                return this.processModelPackage(component, modelPackage);
            }
            throw new ExternalRefComponentNotFoundException(component, filePath);
        }
        throw new FileNotFoundException("File " + filePath + " defined in the YML not found");
    }

    private String processModelPackage(String extractedPackage, String modelPackage) {
        Object processedPackage;
        if (modelPackage != null) {
            if (extractedPackage.contains(".")) {
                String[] splittedPackage = extractedPackage.split("\\.");
                String className = splittedPackage[splittedPackage.length - 1];
                processedPackage = modelPackage + "." + className;
            } else {
                processedPackage = modelPackage + "." + extractedPackage;
            }
        } else {
            processedPackage = extractedPackage.contains(".") ? extractedPackage : "net.coru.apigenerator.asyncapi.model." + extractedPackage;
        }
        return processedPackage;
    }
}

