/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin;

import freemarker.template.TemplateException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.coru.api.generator.plugin.openapi.exception.DuplicateModelClassException;
import net.coru.api.generator.plugin.openapi.exception.OpenApiGeneratedSourceFolderException;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.GlobalObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.model.SchemaFieldObject;
import net.coru.api.generator.plugin.openapi.model.SchemaObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.template.TemplateFactory;
import net.coru.api.generator.plugin.openapi.utils.MapperAuthUtil;
import net.coru.api.generator.plugin.openapi.utils.MapperContentUtil;
import net.coru.api.generator.plugin.openapi.utils.MapperPathUtil;
import net.coru.api.generator.plugin.openapi.utils.OpenApiUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="openapi-generation", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class OpenapiMultiFileMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(OpenapiMultiFileMojo.class);
    private static final String DEFAULT_OPENAPI_TARGET_PACKAGE = "net.coru.apigenerator.openapi";
    private static final String DEFAULT_OPENAPI_MODEL_PACKAGE = "net.coru.apigenerator.openapi.model";
    private static final String DEFAULT_OPENAPI_CLIENT_PACKAGE = "net.coru.apigenerator.openapi.client";
    private Boolean generateExceptionTemplate = false;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File targetFolder;
    @Parameter(property="fileSpecs")
    private List<FileSpec> fileSpecs;
    @Parameter(name="overwriteModel", property="overwriteModel", defaultValue="true")
    private Boolean overwriteModel;
    @Parameter(name="generatedSourcesFolder", property="generatedSourcesFolder", defaultValue="generated-sources")
    private String generatedSourcesFolder;
    private final FilenameFilter targetFileFilter = (dir, name) -> name.toLowerCase().contains(this.targetFolder.toPath().getFileName().toString());
    private final Set<String> overwriteModelList = new HashSet<String>();
    private TemplateFactory templateFactory;
    private Boolean isWebClient = false;
    private Boolean isRestClient = false;
    private final List<String> authentications = new ArrayList<String>();
    private String processedGeneratedSourcesFolder;

    public void execute() throws MojoExecutionException {
        this.processGeneratedSourcesFolderName();
        this.addGeneratedSourcesToProject();
        this.templateFactory = new TemplateFactory();
        if (null == this.fileSpecs || this.fileSpecs.isEmpty()) {
            throw new MojoExecutionException("Code generation failed. Not exists FileSpec configuration to generate package and class");
        }
        this.processFileSpec(this.fileSpecs);
    }

    private void processGeneratedSourcesFolderName() {
        if (!this.generatedSourcesFolder.matches("[a-zA-Z\\d\\-]+")) {
            throw new OpenApiGeneratedSourceFolderException(this.generatedSourcesFolder);
        }
        this.processedGeneratedSourcesFolder = this.generatedSourcesFolder + "/apigenerator/";
    }

    private void addGeneratedSourcesToProject() {
        Path projectPath = this.targetFolder.toPath().resolve(this.processedGeneratedSourcesFolder);
        this.project.addCompileSourceRoot(projectPath.toString());
    }

    private void processFileSpec(List<FileSpec> fileSpecsList) throws MojoExecutionException {
        for (FileSpec fileSpec : fileSpecsList) {
            try {
                this.processPackage(fileSpec.getApiPackage());
                String filePathToSave = this.processPath(fileSpec.getApiPackage(), false);
                this.processFile(fileSpec, filePathToSave);
                this.createClients(fileSpec);
            }
            catch (TemplateException | IOException | MojoExecutionException e) {
                this.getLog().error(e);
                throw new MojoExecutionException("Code generation failed. See above for the full exception.");
            }
        }
    }

    private void processFile(FileSpec fileSpec, String filePathToSave) throws MojoExecutionException, TemplateException, IOException {
        OpenAPI openAPI = OpenApiUtil.getPojoFromSwagger(fileSpec);
        String clientPackage = fileSpec.getClientPackage();
        if (Boolean.TRUE.equals(fileSpec.getCallMode())) {
            this.templateFactory.setWebClientPackageName(StringUtils.isNotBlank((CharSequence)clientPackage) ? clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE);
            this.templateFactory.setAuthPackageName((StringUtils.isNotBlank((CharSequence)clientPackage) ? clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE) + ".auth");
            this.isWebClient = fileSpec.getIsReactive();
            this.isRestClient = fileSpec.getIsReactive() == false;
        }
        this.createApiTemplate(fileSpec, filePathToSave, openAPI);
        this.createModelTemplate(fileSpec, openAPI);
    }

    private void createClients(FileSpec fileSpec) {
        String clientPackage = fileSpec.getClientPackage();
        if (this.isWebClient.booleanValue() || this.isRestClient.booleanValue()) {
            String clientPath = this.processPath(StringUtils.isNotBlank((CharSequence)clientPackage) ? clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE, false);
            try {
                if (Boolean.TRUE.equals(this.isWebClient)) {
                    this.templateFactory.fillTemplateWebClient(clientPath);
                }
                if (Boolean.TRUE.equals(this.isRestClient)) {
                    this.templateFactory.fillTemplateRestClient(clientPath);
                }
                this.createAuthTemplates(fileSpec);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createAuthTemplates(FileSpec fileSpec) throws TemplateException, IOException {
        String clientPackage = fileSpec.getClientPackage();
        String authFileRoot = (StringUtils.isNotBlank((CharSequence)clientPackage) ? clientPackage : DEFAULT_OPENAPI_CLIENT_PACKAGE) + ".auth";
        String authFileToSave = this.processPath(authFileRoot, false);
        this.templateFactory.setAuthPackageName(authFileRoot);
        this.templateFactory.fillTemplateAuth(authFileToSave, "Authentication");
        if (null != this.authentications && !this.authentications.isEmpty()) {
            for (String authentication : this.authentications) {
                this.templateFactory.fillTemplateAuth(authFileToSave, authentication);
            }
        }
    }

    private void createApiTemplate(FileSpec fileSpec, String filePathToSave, OpenAPI openAPI) {
        Map<String, HashMap<String, PathItem>> apis = OpenApiUtil.mapApiGroups(openAPI, fileSpec.getUseTagsGroup());
        List<AuthSchemaObject> authSchemaList = MapperAuthUtil.createAuthSchemaList(openAPI);
        GlobalObject globalObject = MapperPathUtil.mapOpenApiObjectToOurModels(openAPI, fileSpec, authSchemaList);
        for (Map.Entry<String, HashMap<String, PathItem>> apisEntry : apis.entrySet()) {
            String javaFileName = OpenApiUtil.processJavaFileName(apisEntry.getKey());
            List<PathObject> pathObjects = MapperPathUtil.mapPathObjects(openAPI, fileSpec, apisEntry, globalObject);
            AuthObject authObject = MapperAuthUtil.getApiAuthObject(globalObject.getAuthSchemas(), pathObjects);
            try {
                this.templateFactory.fillTemplate(filePathToSave, fileSpec, javaFileName, pathObjects, authObject);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
            if (!Boolean.TRUE.equals(fileSpec.getCallMode())) continue;
            this.addAuthentications(authObject);
        }
    }

    private void addAuthentications(AuthObject authObject) {
        if (null != authObject.getSecurityRequirements() && !authObject.getSecurityRequirements().isEmpty()) {
            authObject.getSecurityRequirements().forEach(authType -> {
                if (!this.authentications.contains(authType)) {
                    this.authentications.add((String)authType);
                }
            });
        }
    }

    private void createModelTemplate(FileSpec fileSpec, OpenAPI openAPI) throws TemplateException, IOException {
        String fileModelToSave = this.processPath(fileSpec.getModelPackage(), true);
        List<String> listObjectsToCreate = OpenApiUtil.getListComponentsObjects(openAPI);
        String modelPackage = this.processModelPackage(fileSpec.getModelPackage());
        Map<String, Schema<?>> basicSchemaMap = OpenApiUtil.processBasicSchemas(openAPI);
        this.templateFactory.setModelPackageName(modelPackage);
        if (Boolean.TRUE.equals(this.overwriteModel)) {
            this.processModelsWhenOverWriteIsTrue(fileSpec, openAPI, fileModelToSave, listObjectsToCreate, modelPackage, basicSchemaMap);
        } else {
            this.processWhenOverwriteModelIsFalse(fileSpec, openAPI, fileModelToSave, listObjectsToCreate, modelPackage, basicSchemaMap);
        }
    }

    private void processPackage(String apiPackage) {
        if (StringUtils.isNotBlank((CharSequence)apiPackage)) {
            this.templateFactory.setPackageName(apiPackage.trim());
        } else if (this.project.getModel().getGroupId() != null) {
            this.templateFactory.setPackageName(this.project.getModel().getGroupId());
        } else {
            this.templateFactory.setPackageName(DEFAULT_OPENAPI_TARGET_PACKAGE);
        }
    }

    private String processModelPackage(String modelPackage) {
        Object modelReturnPackage = "";
        modelReturnPackage = StringUtils.isNotBlank((CharSequence)modelPackage) ? modelPackage.trim() : (this.project.getModel().getGroupId() != null ? this.project.getModel().getGroupId() + ".model" : DEFAULT_OPENAPI_MODEL_PACKAGE);
        return modelReturnPackage;
    }

    private String processPath(String fileSpecPackage, Boolean isModel) {
        Path path;
        File[] pathList = Objects.requireNonNull(this.project.getBasedir().listFiles(this.targetFileFilter));
        if (pathList.length > 0) {
            path = pathList[0].toPath().resolve(this.convertPackageToTargetPath(fileSpecPackage, isModel));
        } else {
            path = this.targetFolder.toPath();
            path.toFile().mkdir();
            path = path.resolve(this.convertPackageToTargetPath(fileSpecPackage, isModel));
        }
        if (!path.toFile().isDirectory()) {
            path.toFile().mkdirs();
        }
        return path.toString();
    }

    private String convertPackageToTargetPath(String fileSpecPackage, Boolean isModel) {
        String path;
        if (StringUtils.isNotBlank((CharSequence)fileSpecPackage)) {
            path = this.processedGeneratedSourcesFolder + fileSpecPackage.trim().replaceAll("\\.", "/");
        } else if (this.project.getModel().getGroupId() != null) {
            path = this.processedGeneratedSourcesFolder + this.project.getModel().getGroupId().replaceAll("\\.", "/");
        } else {
            String pathDefault = Boolean.TRUE.equals(isModel) ? DEFAULT_OPENAPI_MODEL_PACKAGE : DEFAULT_OPENAPI_TARGET_PACKAGE;
            path = this.processedGeneratedSourcesFolder + pathDefault.replaceAll("\\.", "/");
        }
        return path;
    }

    private void processModelsWhenOverWriteIsTrue(FileSpec fileSpec, OpenAPI openAPI, String fileModelToSave, List<String> listObjectsToCreate, String modelPackage, Map<String, Schema<?>> basicSchemaMap) throws TemplateException, IOException {
        for (String pojoName : listObjectsToCreate) {
            SchemaObject schemaObject = MapperContentUtil.mapComponentToSchemaObject(openAPI.getComponents().getSchemas(), (Schema)openAPI.getComponents().getSchemas().get(pojoName), StringUtils.capitalize((String)pojoName), fileSpec, modelPackage);
            this.checkRequiredOrCombinatorExists(schemaObject);
            try {
                this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), schemaObject);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        }
        basicSchemaMap.forEach((schemaName, basicSchema) -> {
            SchemaObject basicSchemaObject = MapperContentUtil.mapComponentToSchemaObject(openAPI.getComponents().getSchemas(), basicSchema, schemaName, fileSpec, modelPackage);
            this.checkRequiredOrCombinatorExists(basicSchemaObject);
            try {
                this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), basicSchemaObject);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        });
        if (Boolean.TRUE.equals(this.generateExceptionTemplate)) {
            this.templateFactory.fillTemplateModelClassException(fileModelToSave);
        }
    }

    private void checkRequiredOrCombinatorExists(SchemaObject schema) {
        if ("anyOf".equals(schema.getSchemaCombinator()) || "oneOf".equals(schema.getSchemaCombinator())) {
            this.generateExceptionTemplate = true;
        } else if (Objects.nonNull(schema.getFieldObjectList())) {
            for (SchemaFieldObject field : schema.getFieldObjectList()) {
                if (!field.getRequired().booleanValue()) continue;
                this.generateExceptionTemplate = true;
            }
        }
    }

    private void processWhenOverwriteModelIsFalse(FileSpec fileSpec, OpenAPI openAPI, String fileModelToSave, List<String> listObjectsToCreate, String modelPackage, Map<String, Schema<?>> basicSchemaMap) {
        for (String string : listObjectsToCreate) {
            String objectAndModelPackage = string + modelPackage;
            if (this.overwriteModelList.add(objectAndModelPackage)) {
                this.overwriteModelList.add(objectAndModelPackage);
                try {
                    this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), MapperContentUtil.mapComponentToSchemaObject(openAPI.getComponents().getSchemas(), (Schema)openAPI.getComponents().getSchemas().get(string), StringUtils.capitalize((String)string), fileSpec, modelPackage));
                }
                catch (TemplateException | IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            throw new DuplicateModelClassException(string, modelPackage);
        }
        for (Map.Entry entry : basicSchemaMap.entrySet()) {
            String schemaName = (String)entry.getKey();
            Schema basicSchema = (Schema)entry.getValue();
            if (!this.overwriteModelList.add(schemaName + modelPackage)) {
                throw new DuplicateModelClassException(schemaName, modelPackage);
            }
            try {
                this.templateFactory.fillTemplateSchema(fileModelToSave, fileSpec.getUseLombokModelAnnotation(), MapperContentUtil.mapComponentToSchemaObject(openAPI.getComponents().getSchemas(), basicSchema, schemaName, fileSpec, modelPackage));
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

