/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private static final List<String> TEMPLATE_FILES = List.of("template.ftlh", "templateSchema.ftlh", "templateSchemaWithLombok.ftlh", "templateCallWebClient.ftlh", "templateWebClient.ftlh", "templateCallRestClient.ftlh", "templateRestClient.ftlh", "templateReactive.ftlh", "templateModelClassException.ftlh");
    private static final List<String> TEMPLATE_AUTH_FILES = List.of("templateApiKeyAuth.ftlh", "templateAuthentication.ftlh", "templateHttpBasicAuth.ftlh", "templateHttpBearerAuth.ftlh", "templateOAuth.ftlh", "templateOAuthFlow.ftlh");
    private static final ClassLoader LOADER = ClasspathTemplateLoader.class.getClassLoader();
    private final Map<String, String> templatesMap = new HashMap<String, String>();

    public ClasspathTemplateLoader() {
        this.templatesMap.putAll(this.getResourceFolderFiles());
    }

    public final Object findTemplateSource(String templateName) {
        return this.templatesMap.get(templateName);
    }

    public final long getLastModified(Object o) {
        return 0L;
    }

    public final Reader getReader(Object template, String charSet) {
        return new StringReader(template.toString());
    }

    public void closeTemplateSource(Object o) {
    }

    private Map<String, String> getResourceFolderFiles() {
        HashMap<String, String> templates = new HashMap<String, String>();
        TEMPLATE_FILES.forEach(templateFile -> {
            try {
                templates.put((String)templateFile, this.readFile((InputStream)Objects.requireNonNull(LOADER.getResource("templates/openapi/" + templateFile)).getContent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        TEMPLATE_AUTH_FILES.forEach(templateAuthFile -> {
            try {
                templates.put((String)templateAuthFile, this.readFile((InputStream)Objects.requireNonNull(LOADER.getResource("templates/openapi/authTemplates/" + templateAuthFile)).getContent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return templates;
    }

    private String readFile(InputStream file) throws IOException {
        return new String(file.readAllBytes());
    }
}

