/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.template;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.exception.OverwritingApiFilesException;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.model.SchemaObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.template.ClasspathTemplateLoader;

public class TemplateFactory {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
    private final Map<String, Object> root = new HashMap<String, Object>();

    public TemplateFactory() {
        this.cfg.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(true);
        List<String> basicDataTypes = List.of("Integer", "Long", "Float", "Double", "Boolean", "String", "Char", "Byte", "Short");
        this.root.put("checkBasicTypes", basicDataTypes);
    }

    public final void fillTemplateSchema(String filePathToSave, Boolean useLombok, SchemaObject schemaObject) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        if (Objects.nonNull(schemaObject.getFieldObjectList()) && !schemaObject.getFieldObjectList().isEmpty()) {
            this.root.put("schema", schemaObject);
            String pathToSaveMainClass = fileToSave.toPath().resolve(schemaObject.getClassName() + ".java").toString();
            this.writeTemplateToFile(null != useLombok && useLombok != false ? "templateSchemaWithLombok.ftlh" : "templateSchema.ftlh", this.root, pathToSaveMainClass);
        }
    }

    public final void fillTemplateModelClassException(String filePathToSave) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        Path pathToExceptionPackage = fileToSave.toPath().resolve("exception");
        pathToExceptionPackage.toFile().mkdirs();
        String pathToSaveMainClass = pathToExceptionPackage.resolve("ModelClassException.java").toString();
        this.writeTemplateToFile("templateModelClassException.ftlh", this.root, pathToSaveMainClass);
    }

    public final void fillTemplateWebClient(String filePathToSave) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String pathToSaveMainClass = fileToSave.toPath().resolve("ApiWebClient.java").toString();
        this.writeTemplateToFile("templateWebClient.ftlh", this.root, pathToSaveMainClass);
    }

    public final void fillTemplateRestClient(String filePathToSave) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String pathToSaveMainClass = fileToSave.toPath().resolve("ApiRestClient.java").toString();
        this.writeTemplateToFile("templateRestClient.ftlh", this.root, pathToSaveMainClass);
    }

    public final void fillTemplateAuth(String filePathToSave, String authName) throws IOException, TemplateException {
        File fileToSave = new File(filePathToSave);
        String nameAuthClass = authName + ".java";
        String pathToSaveMainClass = fileToSave.toPath().resolve(nameAuthClass).toString();
        this.writeTemplateToFile(this.createNameTemplate(authName), this.root, pathToSaveMainClass);
    }

    public final void fillTemplate(String filePathToSave, FileSpec fileSpec, String className, List<PathObject> pathObjects, AuthObject authObject) throws IOException, TemplateException {
        this.root.put("className", className);
        this.root.put("pathObjects", pathObjects);
        if (Objects.nonNull(fileSpec.getApiPackage())) {
            this.root.put("packageApi", fileSpec.getApiPackage());
        }
        if (Objects.nonNull(fileSpec.getModelPackage())) {
            this.root.put("packageModel", fileSpec.getModelPackage());
        }
        File fileToSave = new File(filePathToSave);
        if (Boolean.TRUE.equals(fileSpec.getCallMode())) {
            this.root.put("authObject", authObject);
        }
        String pathToSaveMainClass = fileToSave.toPath().resolve(className + "Api.java").toString();
        this.writeTemplateToFile(Boolean.TRUE.equals(fileSpec.getCallMode()) ? this.getTemplateClientApi(fileSpec) : this.getTemplateApi(fileSpec), this.root, pathToSaveMainClass);
    }

    private void writeTemplateToFile(String templateName, Map<String, Object> root, String path) throws IOException, TemplateException {
        Template template = this.cfg.getTemplate(templateName);
        if (Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
            throw new OverwritingApiFilesException();
        }
        FileWriter writer = new FileWriter(path);
        template.process(root, (Writer)writer);
        writer.close();
    }

    public final void setPackageName(String packageName) {
        this.root.put("package", packageName);
    }

    public final void setModelPackageName(String packageName) {
        this.root.put("packageModel", packageName);
    }

    public final void setWebClientPackageName(String packageName) {
        this.root.put("packageClient", packageName);
    }

    public final void setAuthPackageName(String packageName) {
        this.root.put("packageAuth", packageName);
    }

    private String createNameTemplate(String classNameAuth) {
        return "template" + classNameAuth + ".ftlh";
    }

    private String getTemplateClientApi(FileSpec fileSpec) {
        return fileSpec.getIsReactive() != false ? "templateCallWebClient.ftlh" : "templateCallRestClient.ftlh";
    }

    private String getTemplateApi(FileSpec fileSpec) {
        return fileSpec.getIsReactive() != false ? "templateReactive.ftlh" : "template.ftlh";
    }
}

