/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.coru.api.generator.plugin.openapi.model.AuthObject;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.OperationObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MapperAuthUtil {
    private static final String API_KEY = "apiKey";

    private MapperAuthUtil() {
    }

    public static List<AuthSchemaObject> createAuthSchemaList(OpenAPI openAPI) {
        ArrayList<AuthSchemaObject> authList = new ArrayList<AuthSchemaObject>();
        if (MapUtils.isNotEmpty((Map)openAPI.getComponents().getSecuritySchemes())) {
            openAPI.getComponents().getSecuritySchemes().forEach((key, value) -> {
                String typeStr = value.getType().toString();
                boolean isHttpBearer = "http".equalsIgnoreCase(typeStr) && "bearer".equalsIgnoreCase(value.getScheme());
                AuthSchemaObject authSchema = AuthSchemaObject.builder().type(isHttpBearer ? "HttpBearerAuth" : MapperAuthUtil.getModelTypeAuth(value)).name((String)key).apiKeyParam(API_KEY.equalsIgnoreCase(typeStr) ? value.getName() : "").apiKeyPlace(API_KEY.equalsIgnoreCase(typeStr) ? value.getIn().toString() : "").bearerSchema(isHttpBearer ? value.getScheme() : "").build();
                authList.add(authSchema);
            });
        }
        return authList;
    }

    private static String getModelTypeAuth(SecurityScheme securityScheme) {
        String type = securityScheme.getType().toString();
        if (securityScheme.getType().toString().equalsIgnoreCase(API_KEY)) {
            type = "ApiKeyAuth";
        } else if (securityScheme.getType().toString().equalsIgnoreCase("oauth2")) {
            type = "OAuth";
        } else if (securityScheme.getType().toString().equalsIgnoreCase("http")) {
            type = "HttpBasicAuth";
        }
        return type;
    }

    public static AuthObject getApiAuthObject(List<AuthSchemaObject> authSchemas, List<PathObject> pathObjects) {
        List<String> authList = MapperAuthUtil.getApiAuthNames(pathObjects);
        ArrayList<String> authApiList = new ArrayList<String>();
        if (null != authSchemas && !authSchemas.isEmpty() && !authList.isEmpty()) {
            authSchemas.forEach(authValue -> {
                if (authList.contains(authValue.getName()) && !authApiList.contains(authValue.getType())) {
                    authApiList.add(authValue.getType());
                }
            });
        }
        return AuthObject.builder().securityRequirements(authApiList).build();
    }

    private static List<String> getApiAuthNames(List<PathObject> pathObjects) {
        ArrayList<OperationObject> operationList = new ArrayList<OperationObject>();
        pathObjects.forEach(pathObject -> operationList.addAll(pathObject.getOperationObjects()));
        return MapperAuthUtil.addApiAuthNames(operationList);
    }

    private static List<String> addApiAuthNames(List<OperationObject> operationList) {
        ArrayList<String> authList = new ArrayList<String>();
        operationList.forEach(operationObject -> {
            if (CollectionUtils.isNotEmpty(operationObject.getSecurities())) {
                operationObject.getSecurities().forEach(auth -> {
                    if (!authList.contains(auth)) {
                        authList.add((String)auth);
                    }
                });
            }
        });
        return authList;
    }
}

