/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.exception.BadDefinedEnumException;
import net.coru.api.generator.plugin.openapi.model.SchemaFieldObject;
import net.coru.api.generator.plugin.openapi.model.SchemaObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.utils.MapperUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MapperContentUtil {
    private static final String ARRAY = "array";
    private static final String MAP = "map";
    private static final String BIG_DECIMAL = "bigDecimal";
    private static final String INTEGER = "integer";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String LONG = "long";
    private static final String STRING = "string";
    private static String schemaCombinatorType;

    private MapperContentUtil() {
    }

    public static SchemaObject mapComponentToSchemaObject(Map<String, Schema> totalSchemas, Schema<?> schema, String nameSchema, FileSpec fileSpec, String modelPackage) {
        List<SchemaFieldObject> listSchema = MapperContentUtil.getFields(totalSchemas, schema, fileSpec);
        return SchemaObject.builder().schemaName(schema.getName()).className(MapperUtil.getPojoName(nameSchema, fileSpec)).importList(MapperContentUtil.getImportList(listSchema, modelPackage)).schemaCombinator(StringUtils.isNotBlank((CharSequence)schemaCombinatorType) ? schemaCombinatorType : "").fieldObjectList(listSchema).build();
    }

    private static List<String> getImportList(List<SchemaFieldObject> fieldObjectList, String modelPackage) {
        HashMap<String, List<String>> listHashMap = new HashMap<String, List<String>>();
        ArrayList<String> importList = new ArrayList<String>();
        for (SchemaFieldObject fieldObject : fieldObjectList) {
            MapperContentUtil.getTypeImports(listHashMap, fieldObject);
            if (!StringUtils.isNotBlank((CharSequence)fieldObject.getImportClass()) || listHashMap.containsKey(fieldObject.getImportClass())) continue;
            listHashMap.put(StringUtils.capitalize((String)fieldObject.getImportClass()), List.of(modelPackage + "." + StringUtils.capitalize((String)fieldObject.getImportClass())));
        }
        if (!listHashMap.isEmpty()) {
            listHashMap.forEach((key, value) -> importList.addAll((Collection<String>)value));
        }
        return importList;
    }

    private static void getTypeImports(HashMap<String, List<String>> listHashMap, SchemaFieldObject fieldObject) {
        if (Objects.nonNull(fieldObject.getDataTypeSimple())) {
            if (fieldObject.getDataTypeSimple().equals(ARRAY)) {
                listHashMap.computeIfAbsent(ARRAY, key -> List.of("java.util.List", "java.util.ArrayList"));
            } else if (Objects.equals(fieldObject.getDataTypeSimple(), MAP)) {
                listHashMap.computeIfAbsent(MAP, key -> List.of("java.util.Map", "java.util.HashMap"));
            } else if (Objects.nonNull(fieldObject.getDataType()) && fieldObject.getDataType().equals(BIG_DECIMAL)) {
                listHashMap.computeIfAbsent(BIG_DECIMAL, key -> List.of("java.math.BigDecimal"));
            }
        }
    }

    private static List<SchemaFieldObject> getFields(Map<String, Schema> totalSchemas, Schema<?> schema, FileSpec fileSpec) {
        ArrayList<SchemaFieldObject> fieldObjectArrayList = new ArrayList<SchemaFieldObject>();
        if (Objects.nonNull(schema.getProperties())) {
            fieldObjectArrayList.addAll(MapperContentUtil.processFieldObjectList(schema, fileSpec));
        } else if (Objects.nonNull(schema.getAllOf())) {
            fieldObjectArrayList.addAll(MapperContentUtil.processAllOf(totalSchemas, schema.getAllOf(), fileSpec));
            schemaCombinatorType = "allOf";
        } else if (Objects.nonNull(schema.getAnyOf())) {
            fieldObjectArrayList.addAll(MapperContentUtil.processAnyOfOneOf(totalSchemas, schema.getAnyOf(), fileSpec));
            schemaCombinatorType = "anyOf";
        } else if (Objects.nonNull(schema.getOneOf())) {
            fieldObjectArrayList.addAll(MapperContentUtil.processAnyOfOneOf(totalSchemas, schema.getOneOf(), fileSpec));
            schemaCombinatorType = "oneOf";
        }
        return fieldObjectArrayList;
    }

    private static List<SchemaFieldObject> processAllOf(Map<String, Schema> totalSchemas, List<Schema> schemaList, FileSpec fileSpec) {
        ArrayList<SchemaFieldObject> fieldObjectArrayList = new ArrayList<SchemaFieldObject>();
        for (Schema ref : schemaList) {
            if (!Objects.nonNull(ref.get$ref())) continue;
            String[] pathObjectRef = ref.get$ref().split("/");
            String schemaName = pathObjectRef[pathObjectRef.length - 1];
            Schema schemaToProcess = totalSchemas.get(schemaName);
            fieldObjectArrayList.addAll(MapperContentUtil.processFieldObjectList(schemaToProcess, fileSpec));
            for (SchemaFieldObject fieldObject : fieldObjectArrayList) {
                fieldObject.setRequired(true);
            }
        }
        return fieldObjectArrayList;
    }

    private static List<SchemaFieldObject> processAnyOfOneOf(Map<String, Schema> totalSchemas, List<Schema> schemaList, FileSpec fileSpec) {
        ArrayList<SchemaFieldObject> fieldObjectArrayList = new ArrayList<SchemaFieldObject>();
        for (Schema internalSchema : schemaList) {
            if (Objects.nonNull(internalSchema.get$ref())) {
                String[] pathObjectRef = internalSchema.get$ref().split("/");
                String schemaName = pathObjectRef[pathObjectRef.length - 1];
                Schema schemaToProcess = totalSchemas.get(schemaName);
                fieldObjectArrayList.addAll(MapperContentUtil.processFieldObjectList(schemaToProcess, fileSpec));
                continue;
            }
            for (SchemaFieldObject fieldObject : fieldObjectArrayList) {
                if (!internalSchema.getRequired().contains(fieldObject.getBaseName())) continue;
                fieldObject.setRequired(true);
            }
        }
        return fieldObjectArrayList;
    }

    private static List<SchemaFieldObject> processFieldObjectList(Schema<?> schema, FileSpec fileSpec) {
        HashMap<String, Schema> mapperProperties = new HashMap<String, Schema>(schema.getProperties());
        ArrayList<SchemaFieldObject> fieldObjectArrayList = new ArrayList<SchemaFieldObject>();
        mapperProperties.forEach((key, value) -> {
            List enumValues = value.getEnum();
            if (CollectionUtils.isNotEmpty((Collection)enumValues)) {
                MapperContentUtil.processEnumField(key, value, fileSpec, fieldObjectArrayList, enumValues, schema);
            } else {
                SchemaFieldObject field = SchemaFieldObject.builder().baseName((String)key).dataTypeSimple(MapperUtil.getSimpleType(value, fileSpec)).build();
                MapperContentUtil.setFieldType(field, value, schema, fileSpec, key);
                fieldObjectArrayList.add(field);
            }
        });
        return fieldObjectArrayList;
    }

    private static void setFieldType(SchemaFieldObject field, Schema<?> value, Schema<?> schema, FileSpec fileSpec, String key) {
        field.setRequired(Objects.nonNull(schema.getRequired()) && schema.getRequired().contains(key));
        if (value instanceof ArraySchema) {
            String typeArray = MapperUtil.getTypeArray((ArraySchema)value, fileSpec);
            field.setDataType(typeArray);
            field.setImportClass(MapperContentUtil.getImportClass(typeArray));
        } else if (value instanceof MapSchema) {
            String typeMap = MapperUtil.getTypeMap((MapSchema)value, fileSpec);
            field.setDataTypeSimple(MAP);
            field.setDataType(typeMap);
            field.setImportClass(MapperContentUtil.getImportClass(typeMap));
        } else if (Objects.nonNull(value.getType()) && value.getType().equals("object")) {
            String typeObject = "";
            if (StringUtils.isNotBlank((CharSequence)value.get$ref())) {
                String[] pathObjectRef = schema.get$ref().split("/");
                typeObject = MapperUtil.getPojoName(pathObjectRef[pathObjectRef.length - 1], fileSpec);
            }
            field.setImportClass(MapperContentUtil.getImportClass(typeObject));
            field.setDataType(typeObject);
        }
    }

    private static void processEnumField(String key, Schema<?> value, FileSpec fileSpec, ArrayList<SchemaFieldObject> fieldObjectArrayList, List<?> enumValues, Schema<?> schema) {
        SchemaFieldObject field = SchemaFieldObject.builder().baseName(key).dataTypeSimple("enum").build();
        field.setRequired(Objects.nonNull(schema.getRequired()) && schema.getRequired().contains(key));
        String dataType = MapperUtil.getSimpleType(value, fileSpec);
        field.setDataType(dataType);
        HashMap<String, String> enumValuesMap = new HashMap<String, String>();
        block15: for (Object enumValue : enumValues) {
            String valueName = enumValue.toString();
            valueName = valueName.replaceAll("\\.", "_DOT_");
            switch (dataType) {
                case "integer": {
                    enumValuesMap.put("INTEGER_" + valueName, enumValue.toString());
                    continue block15;
                }
                case "long": {
                    enumValuesMap.put("LONG_" + valueName, enumValue.toString() + "l");
                    continue block15;
                }
                case "double": {
                    enumValuesMap.put("DOUBLE_" + valueName, enumValue.toString());
                    continue block15;
                }
                case "float": {
                    enumValuesMap.put("FLOAT_" + valueName, enumValue.toString() + "f");
                    continue block15;
                }
                case "bigDecimal": {
                    enumValuesMap.put("BIG_DECIMAL_" + valueName, "new BigDecimal(\"" + enumValue.toString() + "\")");
                    continue block15;
                }
            }
            enumValuesMap.put(StringUtils.upperCase((String)valueName), "\"" + enumValue.toString() + "\"");
        }
        if (enumValuesMap.isEmpty()) {
            throw new BadDefinedEnumException(key);
        }
        field.setEnumValues(enumValuesMap);
        fieldObjectArrayList.add(field);
    }

    private static String getImportClass(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !"String".equals(type) && !"Integer".equals(type) ? type : "";
    }
}

