/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.coru.api.generator.plugin.openapi.exception.DuplicatedOperationException;
import net.coru.api.generator.plugin.openapi.model.AuthSchemaObject;
import net.coru.api.generator.plugin.openapi.model.BasicTypeConstants;
import net.coru.api.generator.plugin.openapi.model.ContentObject;
import net.coru.api.generator.plugin.openapi.model.GlobalObject;
import net.coru.api.generator.plugin.openapi.model.OperationObject;
import net.coru.api.generator.plugin.openapi.model.ParameterObject;
import net.coru.api.generator.plugin.openapi.model.PathObject;
import net.coru.api.generator.plugin.openapi.model.RequestObject;
import net.coru.api.generator.plugin.openapi.model.ResponseObject;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.utils.MapperUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MapperPathUtil {
    public static final String ARRAY = "array";
    public static final String MAP = "map";
    public static final String OBJECT = "object";
    public static final String INLINE_PARAMETER = "InlineParameter";

    private MapperPathUtil() {
    }

    public static GlobalObject mapOpenApiObjectToOurModels(OpenAPI openAPI, FileSpec fileSpec, List<AuthSchemaObject> authSchemaList) {
        List<String> authList = MapperPathUtil.getSecurityRequirementList(openAPI.getSecurity(), new ArrayList<String>());
        return GlobalObject.builder().url(((Server)openAPI.getServers().get(0)).getUrl()).authSchemas(authSchemaList).authentications(authList).componentsTypeMap(MapperPathUtil.getMapComponentsTypes(openAPI.getComponents(), fileSpec)).build();
    }

    private static List<String> getSecurityRequirementList(List<SecurityRequirement> securityRequirementList, List<String> authentications) {
        List<String> authSecList;
        if (null != securityRequirementList && !securityRequirementList.isEmpty()) {
            authSecList = new ArrayList<String>();
            securityRequirementList.forEach(securityRequirement -> securityRequirement.forEach((key, value) -> authSecList.add((String)key)));
        } else {
            authSecList = authentications;
        }
        return authSecList;
    }

    private static HashMap<String, String> getMapComponentsTypes(Components components, FileSpec fileSpec) {
        HashMap<String, String> mapComponents = new HashMap<String, String>();
        if (MapUtils.isNotEmpty((Map)components.getSchemas())) {
            components.getSchemas().forEach((key, value) -> {
                if (!mapComponents.containsKey(key)) {
                    String type = MapperPathUtil.checkSchemaType(value, fileSpec);
                    mapComponents.put((String)key, OBJECT.equalsIgnoreCase(type) ? MapperUtil.getPojoName(key, fileSpec) : type);
                }
            });
        }
        return mapComponents;
    }

    private static String checkSchemaType(Schema<?> schema, FileSpec fileSpec) {
        Object dataType = "";
        if (schema instanceof ArraySchema) {
            dataType = "array-" + MapperUtil.getTypeArray((ArraySchema)schema, fileSpec);
        } else if (schema instanceof MapSchema) {
            dataType = "map-" + MapperUtil.getTypeMap((MapSchema)schema, fileSpec);
        } else if (OBJECT.equals(schema.getType()) && StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            String[] pathObjectRef = schema.get$ref().split("/");
            dataType = MapperUtil.getPojoName(pathObjectRef[pathObjectRef.length - 1], fileSpec);
        } else {
            dataType = !Objects.nonNull(schema.getType()) && Boolean.TRUE.equals(MapperPathUtil.checkSchemaCombinator(schema)) ? OBJECT : schema.getType();
        }
        return dataType;
    }

    public static Boolean checkSchemaCombinator(Schema<?> schema) {
        return ObjectUtils.anyNotNull((Object[])new Object[]{schema.getAnyOf(), schema.getAllOf(), schema.getOneOf()});
    }

    public static List<PathObject> mapPathObjects(OpenAPI openAPI, FileSpec fileSpec, Map.Entry<String, HashMap<String, PathItem>> path, GlobalObject globalObject) {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        for (Map.Entry<String, PathItem> pathItem : path.getValue().entrySet()) {
            PathObject pathObject = PathObject.builder().pathName(pathItem.getKey()).globalObject(globalObject).operationObjects(MapperPathUtil.mapOperationObject(openAPI, fileSpec, pathItem, globalObject)).build();
            pathObjects.add(pathObject);
        }
        return pathObjects;
    }

    private static List<OperationObject> mapOperationObject(OpenAPI openAPI, FileSpec fileSpec, Map.Entry<String, PathItem> path, GlobalObject globalObject) {
        ArrayList<OperationObject> operationObjects = new ArrayList<OperationObject>();
        ArrayList<String> operationIdList = new ArrayList<String>();
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getGet()))) {
            operationObjects.add(MapperPathUtil.createOperation(openAPI, path.getValue().getGet(), "GET", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPost()))) {
            operationObjects.add(MapperPathUtil.createOperation(openAPI, path.getValue().getPost(), "POST", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getDelete()))) {
            operationObjects.add(MapperPathUtil.createOperation(openAPI, path.getValue().getDelete(), "DELETE", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPut()))) {
            operationObjects.add(MapperPathUtil.createOperation(openAPI, path.getValue().getPut(), "PUT", fileSpec, globalObject, operationIdList));
        }
        if (Boolean.TRUE.equals(MapperPathUtil.checkIfOperationIsNull(path.getValue().getPatch()))) {
            operationObjects.add(MapperPathUtil.createOperation(openAPI, path.getValue().getPatch(), "PATCH", fileSpec, globalObject, operationIdList));
        }
        return operationObjects;
    }

    private static OperationObject createOperation(OpenAPI openAPI, Operation operation, String operationType, FileSpec fileSpec, GlobalObject globalObject, List<String> operationIdList) {
        return OperationObject.builder().operationId(MapperPathUtil.mapOperationId(operation.getOperationId(), operationIdList)).operationType(operationType).summary(operation.getSummary()).tags(operation.getTags()).requestObjects(MapperPathUtil.mapRequestObject(fileSpec, operation, globalObject)).responseObjects(MapperPathUtil.mapResponseObject(fileSpec, operation, globalObject)).parameterObjects(MapperPathUtil.mapParameterObjects(openAPI, operation.getParameters(), fileSpec, operation.getOperationId())).securities(MapperPathUtil.getSecurityRequirementList(operation.getSecurity(), globalObject.getAuthentications())).consumes(MapperPathUtil.getConsumesList(operation.getRequestBody())).produces(MapperPathUtil.getProducesList(operation.getResponses())).build();
    }

    private static String mapOperationId(String operationId, List<String> operationIdList) {
        if (operationIdList.contains(operationId)) {
            throw new DuplicatedOperationException(operationId);
        }
        operationIdList.add(operationId);
        return operationId;
    }

    private static List<String> getConsumesList(RequestBody requestBody) {
        ArrayList<String> consumesList = new ArrayList<String>();
        if (requestBody != null && requestBody.getContent() != null && !requestBody.getContent().isEmpty()) {
            Set consumes = requestBody.getContent().keySet();
            consumes.forEach(key -> {
                if (!key.equalsIgnoreCase("*/*")) {
                    consumesList.add(key.replace("\"", "\\\""));
                }
            });
        }
        return consumesList;
    }

    private static List<String> getProducesList(ApiResponses responses) {
        ArrayList<String> producesList = new ArrayList<String>();
        if (Objects.nonNull(responses) && !responses.isEmpty()) {
            responses.forEach((key1, value) -> {
                if (value != null && value.getContent() != null && !value.getContent().isEmpty()) {
                    Set produces = value.getContent().keySet();
                    produces.forEach(key -> {
                        if (!key.equalsIgnoreCase("*/*") && !producesList.contains(key)) {
                            producesList.add(key.replace("\"", "\\\""));
                        }
                    });
                }
            });
        }
        return producesList;
    }

    private static List<RequestObject> mapRequestObject(FileSpec fileSpec, Operation operation, GlobalObject globalObject) {
        ArrayList<RequestObject> requestObjects = new ArrayList<RequestObject>();
        String operationIdWithCap = operation.getOperationId().substring(0, 1).toUpperCase() + operation.getOperationId().substring(1);
        if (Objects.nonNull(operation.getRequestBody())) {
            requestObjects.add(RequestObject.builder().required(operation.getRequestBody().getRequired()).contentObjects(MapperPathUtil.mapContentObject(fileSpec, operation.getRequestBody().getContent(), "InlineObject" + operationIdWithCap, globalObject)).build());
        }
        return requestObjects;
    }

    private static List<ParameterObject> mapParameterObjects(OpenAPI openAPI, List<Parameter> parameters, FileSpec fileSpec, String contentClassName) {
        ArrayList<ParameterObject> parameterObjects = new ArrayList<ParameterObject>();
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                if (Objects.nonNull(parameter.get$ref())) {
                    String[] wholeRef = parameter.get$ref().split("/");
                    String ref = wholeRef[wholeRef.length - 1];
                    Parameter refParameter = (Parameter)openAPI.getComponents().getParameters().get(ref);
                    parameterObjects.add(ParameterObject.builder().name(refParameter.getName()).required(refParameter.getRequired()).description(refParameter.getDescription()).in(refParameter.getDescription()).className(MapperUtil.getSimpleType(refParameter.getSchema(), fileSpec)).isCollection(ARRAY.equalsIgnoreCase(refParameter.getSchema().getType())).build());
                    continue;
                }
                if (Objects.nonNull(parameter.getContent())) {
                    MapperPathUtil.addInlineParametersToList(contentClassName, parameterObjects, parameter, fileSpec);
                    continue;
                }
                parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(MapperUtil.getSimpleType(parameter.getSchema(), fileSpec)).isCollection(ARRAY.equalsIgnoreCase(parameter.getSchema().getType())).build());
            }
        }
        return parameterObjects;
    }

    private static void addInlineParametersToList(String contentClassName, List<ParameterObject> parameterObjects, Parameter parameter, FileSpec fileSpec) {
        Content content = parameter.getContent();
        for (Map.Entry contentEntrySet : content.entrySet()) {
            if (OBJECT.equalsIgnoreCase(((MediaType)contentEntrySet.getValue()).getSchema().getType())) {
                parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(MapperPathUtil.getPojoName(INLINE_PARAMETER + StringUtils.capitalize((String)contentClassName) + StringUtils.capitalize((String)parameter.getName()), fileSpec)).importName(MapperPathUtil.getPojoName(INLINE_PARAMETER + StringUtils.capitalize((String)contentClassName) + StringUtils.capitalize((String)parameter.getName()), fileSpec)).build());
                continue;
            }
            parameterObjects.add(ParameterObject.builder().name(parameter.getName()).required(parameter.getRequired()).description(parameter.getDescription()).in(parameter.getIn()).className(MapperPathUtil.defineTypeName(((MediaType)contentEntrySet.getValue()).getSchema())).build());
        }
    }

    private static List<ResponseObject> mapResponseObject(FileSpec fileSpec, Operation operation, GlobalObject globalObject) {
        ArrayList<ResponseObject> responseObjects = new ArrayList<ResponseObject>();
        ApiResponses responses = operation.getResponses();
        if (Objects.nonNull(responses)) {
            responses.forEach((key, value) -> {
                String operationIdWithCap = operation.getOperationId().substring(0, 1).toUpperCase() + operation.getOperationId().substring(1);
                responseObjects.add(ResponseObject.builder().responseName((String)key).description(value.getDescription()).contentObjects(MapperPathUtil.mapContentObject(fileSpec, value.getContent(), "InlineResponse" + key + operationIdWithCap, globalObject)).build());
            });
        }
        return responseObjects;
    }

    private static List<ContentObject> mapContentObject(FileSpec fileSpec, Content content, String inlineObject, GlobalObject globalObject) {
        ArrayList<ContentObject> contentObjects = new ArrayList<ContentObject>();
        if (Objects.nonNull(content)) {
            for (Map.Entry mediaTypeEntry : content.entrySet()) {
                if (Objects.nonNull(((MediaType)mediaTypeEntry.getValue()).getSchema().getProperties())) {
                    contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).importName(StringUtils.capitalize((String)MapperPathUtil.getPojoName(inlineObject, fileSpec))).refName(MapperPathUtil.getPojoName(inlineObject, fileSpec)).build());
                    continue;
                }
                if (Objects.nonNull(((MediaType)mediaTypeEntry.getValue()).getSchema().getType()) && BasicTypeConstants.BASIC_OBJECT_TYPE.contains(((MediaType)mediaTypeEntry.getValue()).getSchema().getType())) {
                    contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).refName(MapperPathUtil.defineTypeName(((MediaType)mediaTypeEntry.getValue()).getSchema())).build());
                    continue;
                }
                contentObjects.add(ContentObject.builder().typeData(MapperPathUtil.mapDataType(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).name((String)mediaTypeEntry.getKey()).importName(StringUtils.capitalize((String)MapperPathUtil.mapRefName(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap()))).refName(MapperPathUtil.mapRefName(((MediaType)mediaTypeEntry.getValue()).getSchema(), globalObject.getComponentsTypeMap())).build());
            }
        }
        return contentObjects;
    }

    private static String defineTypeName(Schema<?> schema) {
        String typeName;
        switch (schema.getType()) {
            case "integer": {
                typeName = MapperPathUtil.getIntegerFormat(schema);
                break;
            }
            case "number": {
                typeName = MapperPathUtil.getNumberFormat(schema);
                break;
            }
            case "boolean": {
                typeName = "Boolean";
                break;
            }
            default: {
                typeName = "String";
            }
        }
        return typeName;
    }

    private static String getIntegerFormat(Schema<?> schema) {
        String typeName = "";
        if ("int32".equalsIgnoreCase(schema.getFormat()) || !Objects.nonNull(schema.getFormat())) {
            typeName = "Integer";
        } else if ("int64".equalsIgnoreCase(schema.getFormat())) {
            typeName = "Long";
        }
        return typeName;
    }

    private static String getNumberFormat(Schema<?> schema) {
        String typeName = "";
        if ("float".equalsIgnoreCase(schema.getFormat())) {
            typeName = "Float";
        } else if ("double".equalsIgnoreCase(schema.getFormat())) {
            typeName = "Double";
        } else if (schema.getFormat().isEmpty()) {
            typeName = "Integer";
        }
        return typeName;
    }

    private static String mapDataType(Schema<?> schema, Map<String, String> componentsTypes) {
        String type = MapperPathUtil.getSchemaType(schema, componentsTypes);
        return StringUtils.isNotBlank((CharSequence)type) ? type : "";
    }

    private static String getSchemaType(Schema<?> schema, Map<String, String> componentsTypes) {
        String dataType = schema.getType();
        if (!StringUtils.isNotBlank((CharSequence)dataType) && Objects.nonNull(schema.get$ref())) {
            String[] wholeRef = schema.get$ref().split("/");
            dataType = componentsTypes.getOrDefault(wholeRef[wholeRef.length - 1], "");
        }
        return dataType.startsWith(ARRAY) ? ARRAY : (dataType.startsWith(MAP) ? MAP : dataType);
    }

    private static String mapRefName(Schema<?> schema, Map<String, String> componentsTypes) {
        String refSchema = "";
        if (ARRAY.equalsIgnoreCase(schema.getType())) {
            ArraySchema arraySchema = (ArraySchema)schema;
            refSchema = arraySchema.getItems().get$ref();
        }
        if (Objects.nonNull(schema.get$ref())) {
            refSchema = schema.get$ref();
        }
        return StringUtils.isNotBlank((CharSequence)refSchema) ? MapperPathUtil.getRefSchema(refSchema, componentsTypes) : "";
    }

    private static String getRefSchema(String refSchema, Map<String, String> componentsTypes) {
        String[] wholeRef = refSchema.split("/");
        String refName = componentsTypes.getOrDefault(wholeRef[wholeRef.length - 1], "");
        if (StringUtils.isNotBlank((CharSequence)refName) && refName.contains("-")) {
            String[] wholeRefName = refName.split("-");
            refName = wholeRefName[wholeRefName.length - 1];
        }
        return refName;
    }

    private static Boolean checkIfOperationIsNull(Operation operation) {
        return Objects.nonNull(operation);
    }

    public static String getPojoName(String namePojo, FileSpec fileSpec) {
        return (StringUtils.isNotBlank((CharSequence)fileSpec.getModelNamePrefix()) ? fileSpec.getModelNamePrefix() : "") + namePojo + (StringUtils.isNotBlank((CharSequence)fileSpec.getModelNameSuffix()) ? fileSpec.getModelNameSuffix() : "");
    }
}

