/*
 * Decompiled with CFR 0.152.
 */
package net.coru.api.generator.plugin.openapi.utils;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.exception.ReadContentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.coru.api.generator.plugin.openapi.parameter.FileSpec;
import net.coru.api.generator.plugin.openapi.utils.MapperPathUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class OpenApiUtil {
    private OpenApiUtil() {
    }

    public static Map<String, HashMap<String, PathItem>> mapApiGroups(OpenAPI openAPI, Boolean groupByTags) {
        HashMap<String, HashMap<String, PathItem>> mapApis = new HashMap<String, HashMap<String, PathItem>>();
        if (!openAPI.getPaths().isEmpty()) {
            mapApis = null != groupByTags && groupByTags != false ? OpenApiUtil.mapApiGroupsByTags(openAPI) : OpenApiUtil.mapApiGroupsByUrl(openAPI);
        }
        return mapApis;
    }

    private static HashMap<String, HashMap<String, PathItem>> mapApiGroupsByTags(OpenAPI openAPI) {
        HashMap<String, HashMap<String, PathItem>> mapApis = new HashMap<String, HashMap<String, PathItem>>();
        for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
            HashMap<String, PathItem> mapPathItemsByTag = OpenApiUtil.getMapPathItemsByTag((PathItem)openAPIGetPathsEntry.getValue());
            for (Map.Entry<String, PathItem> mapPathItems : mapPathItemsByTag.entrySet()) {
                mapApis.compute(mapPathItems.getKey(), (key, value) -> OpenApiUtil.initOrInsert(openAPIGetPathsEntry, mapPathItems, value));
            }
        }
        return mapApis;
    }

    private static HashMap<String, PathItem> initOrInsert(Map.Entry<String, PathItem> openAPIGetPathsEntry, Map.Entry<String, PathItem> mapPathItems, HashMap<String, PathItem> value) {
        HashMap<String, Object> newValue = value;
        if (Objects.isNull(newValue)) {
            newValue = new HashMap();
        }
        newValue.put(openAPIGetPathsEntry.getKey(), mapPathItems.getValue());
        return newValue;
    }

    private static HashMap<String, PathItem> getMapPathItemsByTag(PathItem pathItem) {
        HashMap<String, PathItem> mapByTag = new HashMap<String, PathItem>();
        for (Map.Entry operation : pathItem.readOperationsMap().entrySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)((Operation)operation.getValue()).getTags())) continue;
            PathItem pathItemClone = OpenApiUtil.pathItemOperationsClear(pathItem);
            String tag = (String)((Operation)operation.getValue()).getTags().get(0);
            mapByTag.putIfAbsent(tag, pathItemClone);
            mapByTag.get(tag).operation((PathItem.HttpMethod)operation.getKey(), (Operation)operation.getValue());
        }
        return mapByTag;
    }

    private static PathItem pathItemOperationsClear(PathItem pathItem) {
        pathItem.operation(PathItem.HttpMethod.GET, null);
        pathItem.operation(PathItem.HttpMethod.POST, null);
        pathItem.operation(PathItem.HttpMethod.DELETE, null);
        pathItem.operation(PathItem.HttpMethod.PATCH, null);
        pathItem.operation(PathItem.HttpMethod.HEAD, null);
        pathItem.operation(PathItem.HttpMethod.OPTIONS, null);
        pathItem.operation(PathItem.HttpMethod.TRACE, null);
        pathItem.operation(PathItem.HttpMethod.PUT, null);
        return pathItem;
    }

    private static HashMap<String, HashMap<String, PathItem>> mapApiGroupsByUrl(OpenAPI openAPI) {
        HashMap<String, HashMap<String, PathItem>> mapByUrl = new HashMap<String, HashMap<String, PathItem>>();
        for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
            String[] pathName = ((String)openAPIGetPathsEntry.getKey()).split("/");
            mapByUrl.putIfAbsent(pathName[1], new HashMap());
            mapByUrl.get(pathName[1]).put((String)openAPIGetPathsEntry.getKey(), (PathItem)openAPIGetPathsEntry.getValue());
        }
        return mapByUrl;
    }

    public static OpenAPI getPojoFromSwagger(FileSpec fileSpec) throws MojoExecutionException {
        OpenAPI openAPI;
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        try {
            SwaggerParseResult result = new OpenAPIParser().readLocation(fileSpec.getFilePath(), null, options);
            openAPI = result.getOpenAPI();
        }
        catch (ReadContentException e) {
            throw new MojoExecutionException("Code generation failed when parser the .yaml file ");
        }
        if (openAPI == null) {
            throw new MojoExecutionException("Code generation failed why .yaml is empty");
        }
        return openAPI;
    }

    public static List<String> getListComponentsObjects(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        ArrayList<String> listObject = new ArrayList<String>();
        if (MapUtils.isNotEmpty((Map)components.getSchemas())) {
            components.getSchemas().forEach((key, value) -> {
                if ("object".equals(value.getType()) || MapperPathUtil.checkSchemaCombinator(value).booleanValue()) {
                    listObject.add((String)key);
                }
            });
        }
        return listObject;
    }

    public static Map<String, Schema<?>> processBasicSchemas(OpenAPI openApi) {
        HashMap basicSchemaMap = new HashMap();
        for (Map.Entry pathItem : openApi.getPaths().entrySet()) {
            PathItem path = (PathItem)pathItem.getValue();
            if (Objects.nonNull(path.getGet())) {
                OpenApiUtil.processContentForBasicSchemas(basicSchemaMap, path.getGet());
            }
            if (Objects.nonNull(path.getPost())) {
                OpenApiUtil.processContentForBasicSchemas(basicSchemaMap, path.getPost());
            }
            if (Objects.nonNull(path.getPut())) {
                OpenApiUtil.processContentForBasicSchemas(basicSchemaMap, path.getPut());
            }
            if (Objects.nonNull(path.getDelete())) {
                OpenApiUtil.processContentForBasicSchemas(basicSchemaMap, path.getDelete());
            }
            if (!Objects.nonNull(path.getPatch())) continue;
            OpenApiUtil.processContentForBasicSchemas(basicSchemaMap, path.getPatch());
        }
        return basicSchemaMap;
    }

    private static void processContentForBasicSchemas(HashMap<String, Schema<?>> basicSchemaMap, Operation operation) {
        OpenApiUtil.processOperationRequestBody(basicSchemaMap, operation);
        OpenApiUtil.processOperationResponses(basicSchemaMap, operation);
    }

    private static void processOperationRequestBody(HashMap<String, Schema<?>> basicSchemaMap, Operation operation) {
        if (Objects.nonNull(operation.getRequestBody()) && Objects.nonNull(operation.getRequestBody().getContent())) {
            operation.getRequestBody().getContent().forEach((key, value) -> {
                if (value.getSchema().get$ref() == null || Objects.nonNull(value.getSchema().getItems()) && value.getSchema().getItems().get$ref() == null) {
                    basicSchemaMap.put("InlineObject" + StringUtils.capitalize((String)operation.getOperationId()), value.getSchema());
                }
            });
        }
    }

    private static void processOperationResponses(HashMap<String, Schema<?>> basicSchemaMap, Operation operation) {
        for (Map.Entry response : operation.getResponses().entrySet()) {
            if (Objects.nonNull(((ApiResponse)response.getValue()).getContent())) {
                ((ApiResponse)response.getValue()).getContent().forEach((key, value) -> {
                    if (value.getSchema().get$ref() == null || Objects.nonNull(value.getSchema().getItems()) && value.getSchema().getItems().get$ref() == null) {
                        basicSchemaMap.put("InlineResponse" + (String)response.getKey() + StringUtils.capitalize((String)operation.getOperationId()), value.getSchema());
                    }
                });
            }
            if (!Objects.nonNull(operation.getParameters())) continue;
            for (Parameter parameter : operation.getParameters()) {
                if (!Objects.nonNull(parameter.getContent())) continue;
                parameter.getContent().forEach((name, mediaType) -> basicSchemaMap.putIfAbsent("InlineParameter" + StringUtils.capitalize((String)operation.getOperationId()) + StringUtils.capitalize((String)parameter.getName()), mediaType.getSchema()));
            }
        }
    }

    public static String processJavaFileName(String apisEntry) {
        String javaFileName = "";
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        if (apisEntry.contains("/")) {
            String[] wholeApiEntry = apisEntry.split("/");
            javaFileName = OpenApiUtil.capLettersAfterSpecialCharacters(wholeApiEntry[0], positionList);
        } else {
            javaFileName = OpenApiUtil.capLettersAfterSpecialCharacters(apisEntry, positionList);
        }
        javaFileName = StringUtils.capitalize((String)javaFileName.replaceAll("[^A-Za-z0-9]", ""));
        return javaFileName;
    }

    private static String capLettersAfterSpecialCharacters(String pathName, List<Integer> positionList) {
        char[] pathAsChars = pathName.toCharArray();
        for (int i = 0; i < pathAsChars.length; ++i) {
            if (Character.isLetterOrDigit(pathAsChars[i])) continue;
            positionList.add(i);
        }
        Object javaFileName = pathName;
        for (Integer position : positionList) {
            javaFileName = ((String)javaFileName).substring(0, position + 1) + ((String)javaFileName).substring(position + 1, position + 2).toUpperCase(Locale.ROOT) + ((String)javaFileName).substring(position + 2);
        }
        return javaFileName;
    }
}

