/*
 * Decompiled with CFR 0.152.
 */
package net.crizin;

import java.io.Serializable;

public class KoreanCharacter
implements Serializable,
Comparable<KoreanCharacter> {
    private static final long serialVersionUID = -2081434254504406150L;
    public static final int KoreanLowerValue = 44032;
    public static final int KoreanUpperValue = 55203;
    private final char character;
    private Chosung chosung;
    private Jungsung jungsung;
    private Jongsung jongsung;

    public KoreanCharacter(char koreanCharacter) {
        this.character = koreanCharacter;
        if (KoreanCharacter.isKoreanCharacter(this.character)) {
            int value = this.character - 44032;
            this.chosung = Chosung.values()[value / 588];
            this.jungsung = Jungsung.values()[value % 588 / 28];
            this.jongsung = Jongsung.values()[value % 28];
        }
    }

    public KoreanCharacter(Chosung chosung, Jungsung jungsung, Jongsung jongsung) {
        if (chosung == null || jungsung == null || jongsung == null) {
            throw new NullPointerException("All parameters must not be null.");
        }
        this.chosung = chosung;
        this.jungsung = jungsung;
        this.jongsung = jongsung;
        this.character = (char)(chosung.ordinal() * 21 * 28 + jungsung.ordinal() * 28 + jongsung.ordinal() + 44032);
    }

    public boolean isKoreanCharacter() {
        return this.chosung != null && this.jungsung != null && this.jongsung != null;
    }

    public Chosung getChosung() {
        return this.chosung;
    }

    public Jungsung getJungsung() {
        return this.jungsung;
    }

    public Jongsung getJongsung() {
        return this.jongsung;
    }

    public char getCharacter() {
        return this.character;
    }

    public String getRomanizedString() {
        return this.getRomanizedString(null, null, ConsonantAssimilation.Progressive, Type.Typical);
    }

    public String getRomanizedString(KoreanCharacter prevCharacter, KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
        if (!this.isKoreanCharacter()) {
            return this.toString();
        }
        if (type == Type.Name || type == Type.NameTypical) {
            prevCharacter = null;
            nextCharacter = null;
        }
        return this.chosung.getPronunciation(prevCharacter, this, consonantAssimilation, type) + this.jungsung.getPronunciation(prevCharacter, this) + this.jongsung.getPronunciation(nextCharacter, consonantAssimilation, type);
    }

    public static boolean isKoreanCharacter(char character) {
        return '\uac00' <= character && character <= '\ud7a3';
    }

    @Override
    public int compareTo(KoreanCharacter other) {
        return Character.compare(this.character, other.character);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.character == ((KoreanCharacter)other).character;
    }

    public int hashCode() {
        return Character.hashCode(this.character);
    }

    public String toString() {
        return String.valueOf(this.character);
    }

    public static enum Jongsung {
        NONE(""),
        \u3131("k"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u314b: {
                        return "";
                    }
                    case \u3147: {
                        if (type == Type.Compound && nextCharacter.jungsung.isInducePalatalization()) {
                            return "ng";
                        }
                        return "";
                    }
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "ng";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3132("k"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u314b: 
                    case \u3147: 
                    case \u314e: {
                        return "";
                    }
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "ng";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3133("k"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u314b: {
                        return "";
                    }
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "ng";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3134("n"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3139: {
                        switch (consonantAssimilation) {
                            case Regressive: {
                                return "l";
                            }
                        }
                        return "n";
                    }
                    case \u3147: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3135("n"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3139: {
                        switch (consonantAssimilation) {
                            case Regressive: {
                                return "l";
                            }
                        }
                        return "n";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3136("n"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                return \u3134.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
            }
        }
        ,
        \u3137("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3141: {
                        return "n";
                    }
                    case \u3147: 
                    case \u314e: 
                    case \u3138: 
                    case \u314c: {
                        if (type == Type.Substantives) {
                            return this.defaultPronunciation;
                        }
                        return "";
                    }
                    case \u3139: {
                        switch (consonantAssimilation) {
                            case Regressive: {
                                return "l";
                            }
                        }
                        return "n";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3139("l"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3147: {
                        if (type == Type.Compound && nextCharacter.getJungsung().isInducePalatalization()) {
                            return this.defaultPronunciation;
                        }
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u313a("k"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u3147: 
                    case \u314e: 
                    case \u3131: {
                        return "l";
                    }
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "ng";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u313b("m"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3147: 
                    case \u3141: 
                    case \u3139: {
                        return "l";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u313c("l"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3139: {
                        return "m";
                    }
                    case \u314b: 
                    case \u314e: 
                    case \u3138: 
                    case \u314c: 
                    case \u3137: 
                    case \u3142: 
                    case \u3145: 
                    case \u3146: 
                    case \u3148: 
                    case \u3149: 
                    case \u314a: {
                        return "p";
                    }
                    case \u3143: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u313d("l"),
        \u313e("l"),
        \u313f("l"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3139: {
                        return "m";
                    }
                    case \u314b: 
                    case \u314e: 
                    case \u3138: 
                    case \u314c: 
                    case \u3137: 
                    case \u3142: 
                    case \u3145: 
                    case \u3146: 
                    case \u3148: 
                    case \u3149: 
                    case \u314a: {
                        return "p";
                    }
                    case \u3143: 
                    case \u314d: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3140("l"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u314e: {
                        return "";
                    }
                    case \u3147: {
                        if (type == Type.Compound && nextCharacter.getJungsung().isInducePalatalization()) {
                            return this.defaultPronunciation;
                        }
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3141("m"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3147: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3142("p"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "m";
                    }
                    case \u3147: 
                    case \u3143: {
                        return "";
                    }
                    case \u314e: {
                        if (type == Type.Substantives) {
                            return this.defaultPronunciation;
                        }
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3144("p"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "m";
                    }
                    case \u3143: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3145("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                return \u3137.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
            }
        }
        ,
        \u3146("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                return \u3137.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
            }
        }
        ,
        \u3147("ng"),
        \u3148("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                return \u3137.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
            }
        }
        ,
        \u314a("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                return \u3137.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
            }
        }
        ,
        \u314b("k"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u3147: {
                        return "";
                    }
                    case \u3134: 
                    case \u3141: 
                    case \u3139: {
                        return "ng";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u314c("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3134: 
                    case \u3141: {
                        return "n";
                    }
                    case \u3147: 
                    case \u314e: 
                    case \u3138: {
                        return "";
                    }
                    case \u3139: {
                        return "l";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u314d("p"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3147: 
                    case \u3143: {
                        return "";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u314e("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (nextCharacter.getChosung()) {
                    case \u3132: 
                    case \u314b: 
                    case \u3147: 
                    case \u314e: 
                    case \u3138: 
                    case \u314c: 
                    case \u3131: 
                    case \u3137: 
                    case \u3148: 
                    case \u3149: 
                    case \u314a: 
                    case \u314d: {
                        return "";
                    }
                    case \u3134: 
                    case \u3141: {
                        return "n";
                    }
                    case \u3139: {
                        switch (consonantAssimilation) {
                            case Regressive: {
                                return "l";
                            }
                        }
                        return "n";
                    }
                }
                return this.defaultPronunciation;
            }
        };

        protected final String defaultPronunciation;

        private Jongsung(String defaultPronunciation) {
            this.defaultPronunciation = defaultPronunciation;
        }

        public String getPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
            return nextCharacter == null || !nextCharacter.isKoreanCharacter() ? this.defaultPronunciation : this.getComplexPronunciation(nextCharacter, consonantAssimilation, type);
        }

        protected String getComplexPronunciation(KoreanCharacter nextCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
            return this.defaultPronunciation;
        }
    }

    public static enum Jungsung {
        \u314f("a", false),
        \u3150("ae", false),
        \u3151("ya", true),
        \u3152("yae", true),
        \u3153("eo", false),
        \u3154("e", false),
        \u3155("yeo", true),
        \u3156("ye", true),
        \u3157("o", false),
        \u3158("wa", false),
        \u3159("wae", false),
        \u315a("oe", false),
        \u315b("yo", true),
        \u315c("u", false),
        \u315d("wo", false),
        \u315e("we", false),
        \u315f("wi", false),
        \u3160("yu", true),
        \u3161("eu", false),
        \u3162("ui", false),
        \u3163("i", true);

        private final String defaultPronunciation;
        private final boolean inducePalatalization;

        private Jungsung(String defaultPronunciation, boolean inducePalatalization) {
            this.defaultPronunciation = defaultPronunciation;
            this.inducePalatalization = inducePalatalization;
        }

        public String getPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter) {
            boolean insertHyphen = false;
            if (prevCharacter != null && prevCharacter.isKoreanCharacter() && prevCharacter.getJongsung() == Jongsung.NONE && currentCharacter.getChosung() == Chosung.\u3147) {
                switch (prevCharacter.getJungsung().defaultPronunciation.charAt(prevCharacter.getJungsung().defaultPronunciation.length() - 1)) {
                    case 'a': {
                        switch (this.defaultPronunciation.charAt(0)) {
                            case 'a': 
                            case 'e': {
                                insertHyphen = true;
                            }
                        }
                        break;
                    }
                    case 'e': {
                        switch (this.defaultPronunciation.charAt(0)) {
                            case 'a': 
                            case 'e': 
                            case 'o': 
                            case 'u': {
                                insertHyphen = true;
                            }
                        }
                    }
                }
            }
            return insertHyphen ? "-" + this.defaultPronunciation : this.defaultPronunciation;
        }

        public boolean isInducePalatalization() {
            return this.inducePalatalization;
        }
    }

    public static enum Chosung {
        \u3131("g"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u313a: 
                    case \u313b: 
                    case \u313c: 
                    case \u313d: 
                    case \u313e: 
                    case \u313f: 
                    case \u3140: {
                        return "kk";
                    }
                    case \u314e: {
                        return "k";
                    }
                }
                return this.defaultPronunciation;
            }

            @Override
            protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
                return prevCharacterPronunciation.endsWith("n");
            }
        }
        ,
        \u3132("kk"),
        \u3134("n"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u3140: 
                    case \u3139: {
                        return "l";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3137("d"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u313e: {
                        return "tt";
                    }
                    case \u314e: 
                    case \u3136: {
                        return "t";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3138("tt"),
        \u3139("r"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u313a: 
                    case \u313c: 
                    case \u313f: 
                    case \u3131: 
                    case \u3132: 
                    case \u3133: 
                    case \u3141: 
                    case \u3142: 
                    case \u3144: 
                    case \u3147: 
                    case \u314b: 
                    case \u314d: {
                        return "n";
                    }
                    case \u314e: 
                    case \u3136: 
                    case \u3134: 
                    case \u3137: 
                    case \u3135: 
                    case \u3145: 
                    case \u3146: 
                    case \u3148: 
                    case \u314a: {
                        switch (consonantAssimilation) {
                            case Progressive: {
                                return "n";
                            }
                        }
                        return "l";
                    }
                    case \u313b: 
                    case \u313d: 
                    case \u313e: 
                    case \u3140: 
                    case \u3139: 
                    case \u314c: {
                        return "l";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3141("m"),
        \u3142("b"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u313e: {
                        return "pp";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3143("pp"),
        \u3145("s"),
        \u3146("ss"),
        \u3147(""){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u3131: {
                        if (type == Type.Compound && currentCharacter.getJungsung().isInducePalatalization()) {
                            return "n";
                        }
                        return "g";
                    }
                    case \u313a: {
                        return "g";
                    }
                    case \u3132: {
                        return "kk";
                    }
                    case \u313d: 
                    case \u3133: 
                    case \u3144: 
                    case \u3145: {
                        return "s";
                    }
                    case \u3147: {
                        if (type == Type.Compound && currentCharacter.getJungsung().isInducePalatalization()) {
                            return "n";
                        }
                        return this.defaultPronunciation;
                    }
                    case \u3136: 
                    case \u3134: {
                        return "n";
                    }
                    case \u3135: 
                    case \u3148: {
                        return "j";
                    }
                    case \u3137: {
                        return currentCharacter.getJungsung().isInducePalatalization() ? "j" : "d";
                    }
                    case \u3140: 
                    case \u3139: {
                        if (type == Type.Compound && currentCharacter.getJungsung().isInducePalatalization()) {
                            return "l";
                        }
                        return "r";
                    }
                    case \u313b: 
                    case \u3141: {
                        return "m";
                    }
                    case \u313c: 
                    case \u3142: {
                        return "b";
                    }
                    case \u313e: 
                    case \u314c: {
                        return currentCharacter.getJungsung().isInducePalatalization() ? "ch" : "t";
                    }
                    case \u313f: 
                    case \u314d: {
                        return "p";
                    }
                    case \u3146: {
                        return "ss";
                    }
                    case \u314a: {
                        return "ch";
                    }
                    case \u314b: {
                        return "k";
                    }
                }
                return this.defaultPronunciation;
            }

            @Override
            protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
                return prevCharacterPronunciation.endsWith("ng") && currentCharacterPronunciation.isEmpty();
            }
        }
        ,
        \u3148("j"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u314e: {
                        return "ch";
                    }
                }
                return this.defaultPronunciation;
            }
        }
        ,
        \u3149("jj"),
        \u314a("ch"),
        \u314b("k"),
        \u314c("t"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u3148: 
                    case \u314a: {
                        return currentCharacter.getJungsung().isInducePalatalization() ? "ch" : "t";
                    }
                }
                return this.defaultPronunciation;
            }

            @Override
            protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
                return prevCharacterPronunciation.endsWith("t");
            }
        }
        ,
        \u314d("p"){

            @Override
            protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
                return prevCharacterPronunciation.endsWith("p");
            }
        }
        ,
        \u314e("h"){

            @Override
            protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
                switch (prevCharacter.getJongsung()) {
                    case \u3131: {
                        if (type == Type.Substantives) {
                            return this.defaultPronunciation;
                        }
                        return "";
                    }
                    case \u3132: {
                        return "kk";
                    }
                    case \u3137: {
                        if (type == Type.Substantives) {
                            return this.defaultPronunciation;
                        }
                        return currentCharacter.getJungsung().isInducePalatalization() ? "ch" : "t";
                    }
                    case \u313e: 
                    case \u3145: 
                    case \u3146: 
                    case \u3148: 
                    case \u314a: 
                    case \u314c: {
                        return currentCharacter.getJungsung().isInducePalatalization() ? "ch" : "t";
                    }
                    case \u313a: {
                        return "k";
                    }
                    case \u313c: {
                        return "p";
                    }
                    case \u313d: {
                        return "s";
                    }
                    case \u3140: {
                        return "r";
                    }
                    case \u3142: {
                        if (type == Type.Substantives) {
                            return this.defaultPronunciation;
                        }
                        return "p";
                    }
                }
                return this.defaultPronunciation;
            }

            @Override
            protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
                return !currentCharacterPronunciation.isEmpty() && prevCharacterPronunciation.endsWith(String.valueOf(currentCharacterPronunciation.charAt(0)));
            }
        };

        protected final String defaultPronunciation;

        private Chosung(String defaultPronunciation) {
            this.defaultPronunciation = defaultPronunciation;
        }

        public String getPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
            if (prevCharacter == null || !prevCharacter.isKoreanCharacter()) {
                return this.defaultPronunciation;
            }
            String complexPronunciation = this.getComplexPronunciation(prevCharacter, currentCharacter, consonantAssimilation, type);
            return this.isNeedHyphen(prevCharacter.getRomanizedString(null, currentCharacter, consonantAssimilation, type), complexPronunciation) ? "-" + complexPronunciation : complexPronunciation;
        }

        protected String getComplexPronunciation(KoreanCharacter prevCharacter, KoreanCharacter currentCharacter, ConsonantAssimilation consonantAssimilation, Type type) {
            return this.defaultPronunciation;
        }

        protected boolean isNeedHyphen(String prevCharacterPronunciation, String currentCharacterPronunciation) {
            return false;
        }
    }

    public static enum Type {
        Substantives,
        Compound,
        District,
        Name,
        NameTypical,
        Typical;

    }

    public static enum ConsonantAssimilation {
        Progressive,
        Regressive;

    }
}

