/*
 * Decompiled with CFR 0.152.
 */
package net.crizin;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.crizin.KoreanCharacter;

public class KoreanRomanizer {
    private static final Pattern doubleSurnames = Pattern.compile("^(\\s*)(\uac15\uc804|\ub0a8\uad81|\ub3c5\uace0|\ub3d9\ubc29|\ub4f1\uc815|\ub9dd\uc808|\ubb34\ubcf8|\uc0ac\uacf5|\uc11c\ubb38|\uc120\uc6b0|\uc18c\ubd09|\uc5b4\uae08|\uc7a5\uace1|\uc81c\uac08|\ud669\ubaa9|\ud669\ubcf4)(.{1,10})$");
    private static final Pattern districtPostfixes = Pattern.compile("^(.{1,20}?)(\ud2b9\ubcc4\uc790\uce58\ub3c4|\ud2b9\ubcc4\uc790\uce58\uc2dc|\ud2b9\ubcc4\uc2dc|\uad11\uc5ed\uc2dc|\ub300\ub85c|\uad6c|\uad70|\ub3c4|\ub3d9|\ub9ac|\uba74|\uc2dc|\uc74d|\uac00|\uae38|\ub85c)(\\s*)$");
    private static final Pattern districtPostfixesWithNumbers1 = Pattern.compile("^(.{0,20}?)(\\d+)(\\s*)(\uac00\uae38|\uac00|\ubc88\uae38|\ub85c|\ub2e8\uc9c0|\ub3d9)(\\s*)$");
    private static final Pattern districtPostfixesWithNumbers2 = Pattern.compile("^(.{0,20}?)(\ub300?\ub85c)\\s*(\\d+[\uac00\ubc88]?)(\uae38)(\\s*)$");
    private static final Map<String, String> typicalSurenameRules = new HashMap<String, String>(){
        {
            this.put("\uac00", "Ka");
            this.put("\uac04", "Kan");
            this.put("\uac08", "Kal");
            this.put("\uac10", "Kam");
            this.put("\uac15", "Kang");
            this.put("\uac15\uc804", "Kangjun");
            this.put("\uacac", "Kyun");
            this.put("\uacbd", "Kyung");
            this.put("\uacc4", "Kye");
            this.put("\uace0", "Ko");
            this.put("\uacf5", "Kong");
            this.put("\uacfd", "Kwak");
            this.put("\uad6c", "Koo");
            this.put("\uad6d", "Kook");
            this.put("\uad70", "Kun");
            this.put("\uad81", "Koong");
            this.put("\uad89", "Kwok");
            this.put("\uad8c", "Kwon");
            this.put("\uadfc", "Keun");
            this.put("\uae08", "Keum");
            this.put("\uae30", "Ki");
            this.put("\uae38", "Kil");
            this.put("\uae40", "Kim");
            this.put("\ub178", "Noh");
            this.put("\ub450", "Doo");
            this.put("\ub780", "Lan");
            this.put("\ub8b0", "Loi");
            this.put("\ub8e8", "Lu");
            this.put("\ub9dd\uc808", "Mangjul");
            this.put("\uba85", "Myung");
            this.put("\ubb38", "Moon");
            this.put("\ubc15", "Park");
            this.put("\ubcc0", "Byun");
            this.put("\ubd80", "Boo");
            this.put("\uc120", "Sun");
            this.put("\uc120\uc6b0", "Sunwoo");
            this.put("\uc131", "Sung");
            this.put("\uc21c", "Soon");
            this.put("\uc2e0", "Shin");
            this.put("\uc2ec", "Shim");
            this.put("\uc544", "Ah");
            this.put("\uc5b4\uae08", "Eokum");
            this.put("\uc624", "Oh");
            this.put("\uc6b0", "Woo");
            this.put("\uc6b4", "Woon");
            this.put("\uc720", "Yoo");
            this.put("\uc724", "Yoon");
            this.put("\uc774", "Lee");
            this.put("\uc784", "Lim");
            this.put("\uc815", "Jung");
            this.put("\uc870", "Cho");
            this.put("\uc8fc", "Joo");
            this.put("\uc900", "June");
            this.put("\uc999", "Chup");
            this.put("\ucd5c", "Choi");
            this.put("\ud3b8", "Pyun");
            this.put("\ud3c9", "Pyung");
            this.put("\ud48d", "Poong");
            this.put("\ud604", "Hyun");
            this.put("\ud615", "Hyung");
            this.put("\ud765", "Hong");
        }
    };

    public static String romanize(String string) {
        return KoreanRomanizer.romanize(string, null, null);
    }

    public static String romanize(String string, KoreanCharacter.ConsonantAssimilation consonantAssimilation) {
        return KoreanRomanizer.romanize(string, null, consonantAssimilation);
    }

    public static String romanize(String string, KoreanCharacter.Type type) {
        return KoreanRomanizer.romanize(string, type, null);
    }

    public static String romanize(String string, KoreanCharacter.Type type, KoreanCharacter.ConsonantAssimilation consonantAssimilation) {
        if (string == null) {
            throw new NullPointerException("String should not be null.");
        }
        consonantAssimilation = consonantAssimilation == null ? KoreanCharacter.ConsonantAssimilation.Regressive : consonantAssimilation;
        type = type == null ? KoreanCharacter.Type.Typical : type;
        switch (type) {
            case Name: 
            case NameTypical: {
                string = KoreanRomanizer.normalizeName(string, type);
                break;
            }
            case District: {
                string = KoreanRomanizer.normalizeDistrict(string);
            }
        }
        StringBuilder buffer = new StringBuilder(string.length() * 3);
        KoreanCharacter currentCharacter = null;
        KoreanCharacter nextCharacter = null;
        for (int i = 0; i < string.length(); ++i) {
            KoreanCharacter prevCharacter = currentCharacter;
            currentCharacter = nextCharacter == null ? new KoreanCharacter(string.charAt(i)) : nextCharacter;
            KoreanCharacter koreanCharacter = nextCharacter = i < string.length() - 1 ? new KoreanCharacter(string.charAt(i + 1)) : null;
            if (currentCharacter.isKoreanCharacter()) {
                String pronunciation = currentCharacter.getRomanizedString(prevCharacter, nextCharacter, consonantAssimilation, type);
                if (prevCharacter == null || !prevCharacter.isKoreanCharacter()) {
                    if (type == KoreanCharacter.Type.District && prevCharacter != null && (prevCharacter.toString().equals("-") || Character.isDigit(prevCharacter.getCharacter()))) {
                        buffer.append(pronunciation);
                        continue;
                    }
                    buffer.append(Character.toUpperCase(pronunciation.charAt(0)));
                    buffer.append(pronunciation.substring(1));
                    continue;
                }
                buffer.append(pronunciation);
                continue;
            }
            buffer.append(currentCharacter);
        }
        return buffer.toString();
    }

    public static void main(String ... args) {
        Scanner scanner = new Scanner(System.in);
        KoreanCharacter.Type type = null;
        KoreanCharacter.ConsonantAssimilation consonantAssimilation = null;
        if (args.length > 0) {
            try {
                type = KoreanCharacter.Type.valueOf(args[0]);
            }
            catch (IllegalArgumentException ignored) {
                System.err.println("Unknown type: " + args[0]);
            }
        }
        if (args.length > 1) {
            try {
                consonantAssimilation = KoreanCharacter.ConsonantAssimilation.valueOf(args[1]);
            }
            catch (IllegalArgumentException ignored) {
                System.err.println("Unknown consonantAssimilation: " + args[1]);
            }
        }
        while (scanner.hasNext()) {
            System.out.println(KoreanRomanizer.romanize(scanner.nextLine(), type, consonantAssimilation));
        }
    }

    private static String normalizeName(String string, KoreanCharacter.Type type) {
        Matcher matcher = doubleSurnames.matcher(string);
        if (type == KoreanCharacter.Type.NameTypical) {
            if (matcher.find()) {
                return matcher.group(1) + typicalSurenameRules.getOrDefault(matcher.group(2), matcher.group(2)) + " " + matcher.group(3);
            }
            return typicalSurenameRules.getOrDefault(String.valueOf(string.charAt(0)), String.valueOf(string.charAt(0))) + " " + string.substring(1);
        }
        if (matcher.find()) {
            return matcher.group(1) + matcher.group(2) + " " + matcher.group(3);
        }
        return string.charAt(0) + " " + string.substring(1);
    }

    private static String normalizeDistrict(String string) {
        Matcher matcher = districtPostfixesWithNumbers2.matcher(string);
        if (matcher.find()) {
            return matcher.group(1) + "-" + matcher.group(2) + " " + matcher.group(3) + "-" + matcher.group(4) + matcher.group(5);
        }
        matcher = districtPostfixesWithNumbers1.matcher(string);
        if (matcher.find()) {
            return matcher.group(1) + (matcher.group(1).endsWith(" ") ? "" : " ") + matcher.group(2) + "-" + matcher.group(3) + matcher.group(4);
        }
        matcher = districtPostfixes.matcher(string);
        if (matcher.find()) {
            return matcher.group(1) + "-" + matcher.group(2) + matcher.group(3);
        }
        return string;
    }
}

