/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.encrypt.aspect;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import net.croz.nrich.encrypt.api.model.EncryptionContext;
import net.croz.nrich.encrypt.api.service.DataEncryptionService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BaseEncryptDataAdvice {
    private static final String REACTOR_PACKAGE_NAME = "reactor.core.publisher";

    public <T> T encryptResult(EncryptionContext encryptionContext, T result, List<String> pathToEncryptList) {
        Object encryptedResult = this.isCompletableFutureResult(result) ? this.encryptCompletableFuture(encryptionContext, pathToEncryptList, result) : (Boolean.TRUE.equals(this.isReactorResult(result)) ? new ReactorEncryptor(this.getDataEncryptionService()).encryptReactorResult(encryptionContext, pathToEncryptList, result) : this.getDataEncryptionService().encryptData(result, pathToEncryptList, encryptionContext));
        return encryptedResult;
    }

    public Object[] decryptArguments(EncryptionContext encryptionContext, Object[] argumentList, List<String> pathToDecryptList) {
        return Arrays.stream(argumentList).map(argument -> this.decryptArgument(encryptionContext, argument, pathToDecryptList)).toArray();
    }

    public Object decryptArgument(EncryptionContext encryptionContext, Object argument, List<String> pathToDecryptList) {
        return this.getDataEncryptionService().decryptData(argument, pathToDecryptList, encryptionContext);
    }

    protected abstract DataEncryptionService getDataEncryptionService();

    private boolean isCompletableFutureResult(Object forEncryption) {
        return forEncryption instanceof CompletableFuture;
    }

    private Boolean isReactorResult(Object forEncryption) {
        return forEncryption != null && forEncryption.getClass().getPackage().getName().equals(REACTOR_PACKAGE_NAME);
    }

    private <T> T encryptCompletableFuture(EncryptionContext encryptionContext, List<String> pathToEncryptList, T forEncryption) {
        CompletionStage encryptedFuture = ((CompletableFuture)forEncryption).thenApply(completedResult -> this.getDataEncryptionService().encryptData(completedResult, pathToEncryptList, encryptionContext));
        return (T)encryptedFuture;
    }

    private static class ReactorEncryptor {
        private final DataEncryptionService dataEncryptionService;

        public <T> T encryptReactorResult(EncryptionContext encryptionContext, List<String> pathToEncryptList, T forEncryption) {
            if (forEncryption instanceof Mono) {
                Mono encryptedMono = ((Mono)forEncryption).map(completedResult -> this.dataEncryptionService.encryptData(completedResult, pathToEncryptList, encryptionContext));
                return (T)encryptedMono;
            }
            if (forEncryption instanceof Flux) {
                Flux encryptedFlux = ((Flux)forEncryption).map(completedResult -> this.dataEncryptionService.encryptData(completedResult, pathToEncryptList, encryptionContext));
                return (T)encryptedFlux;
            }
            return forEncryption;
        }

        @ConstructorProperties(value={"dataEncryptionService"})
        @Generated
        public ReactorEncryptor(DataEncryptionService dataEncryptionService) {
            this.dataEncryptionService = dataEncryptionService;
        }
    }
}

