/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.encrypt.aspect;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import net.croz.nrich.encrypt.api.annotation.DecryptArgument;
import net.croz.nrich.encrypt.api.annotation.EncryptResult;
import net.croz.nrich.encrypt.api.model.EncryptionContext;
import net.croz.nrich.encrypt.api.service.DataEncryptionService;
import net.croz.nrich.encrypt.aspect.BaseEncryptDataAdvice;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class EncryptDataAspect
extends BaseEncryptDataAdvice {
    private final DataEncryptionService dataEncryptionService;

    @Around(value="execution(* *(.., @net.croz.nrich.encrypt.api.annotation.DecryptArgument (*), ..)))")
    public Object aroundDecryptAnnotatedMethods(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Signature signature = proceedingJoinPoint.getSignature();
        Object[] arguments = proceedingJoinPoint.getArgs();
        if (signature instanceof MethodSignature && arguments.length > 0) {
            MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
            String methodName = methodSignature.getMethod().getName();
            Class<?>[] parameterTypes = methodSignature.getMethod().getParameterTypes();
            Annotation[][] parameterAnnotationList = proceedingJoinPoint.getTarget().getClass().getMethod(methodName, parameterTypes).getParameterAnnotations();
            EncryptionContext context = this.createEncryptionContext((Signature)methodSignature, arguments);
            Object[] decryptedArguments = IntStream.range(0, arguments.length).mapToObj(index -> {
                DecryptArgument argumentAnnotation = this.decryptArgumentAnnotation(parameterAnnotationList[index]);
                if (argumentAnnotation == null) {
                    return arguments[index];
                }
                return this.decryptArgument(context, arguments[index], Arrays.asList(argumentAnnotation.argumentPathList()));
            }).toArray();
            return proceedingJoinPoint.proceed(decryptedArguments);
        }
        return proceedingJoinPoint.proceed(arguments);
    }

    @Around(value="@annotation(annotation)")
    public Object aroundEncryptAnnotatedMethods(ProceedingJoinPoint proceedingJoinPoint, EncryptResult annotation) throws Throwable {
        Signature signature = proceedingJoinPoint.getSignature();
        Object[] arguments = proceedingJoinPoint.getArgs();
        EncryptionContext context = this.createEncryptionContext(signature, arguments);
        Object result = proceedingJoinPoint.proceed(arguments);
        result = this.encryptResult(context, result, Arrays.asList(annotation.resultPathList()));
        return result;
    }

    @Override
    protected DataEncryptionService getDataEncryptionService() {
        return this.dataEncryptionService;
    }

    private DecryptArgument decryptArgumentAnnotation(Annotation[] annotationList) {
        return Arrays.stream(annotationList).filter(DecryptArgument.class::isInstance).findFirst().orElse(null);
    }

    private EncryptionContext createEncryptionContext(Signature signature, Object[] arguments) {
        List<Object> argumentList = Arrays.asList(arguments);
        String methodName = String.format("%s.%s", signature.getDeclaringType().getName(), signature.getName());
        return EncryptionContext.builder().fullyQualifiedMethodName(methodName).methodArguments(argumentList).methodDecryptedArguments(argumentList).build();
    }

    @ConstructorProperties(value={"dataEncryptionService"})
    @Generated
    public EncryptDataAspect(DataEncryptionService dataEncryptionService) {
        this.dataEncryptionService = dataEncryptionService;
    }
}

