/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.encrypt.aspect;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.encrypt.api.model.EncryptionConfiguration;
import net.croz.nrich.encrypt.api.model.EncryptionContext;
import net.croz.nrich.encrypt.api.model.EncryptionOperation;
import net.croz.nrich.encrypt.api.service.DataEncryptionService;
import net.croz.nrich.encrypt.aspect.BaseEncryptDataAdvice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ProxyMethodInvocation;

public class EncryptMethodInterceptor
extends BaseEncryptDataAdvice
implements MethodInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptMethodInterceptor.class);
    private final DataEncryptionService dataEncryptionService;
    private final List<EncryptionConfiguration> encryptionConfigurationList;
    private final List<String> ignoredMethodList;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!(invocation instanceof ProxyMethodInvocation)) {
            log.debug("Found method: {} was not instance of ProxyMethodInvocation it will not be encrypted!!", (Object)this.methodName(invocation));
            return invocation.proceed();
        }
        ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation)invocation;
        String methodName = this.methodName(invocation);
        String anyMethodName = this.anyClassMethod(invocation);
        if (Optional.ofNullable(this.ignoredMethodList).orElse(Collections.emptyList()).contains(methodName)) {
            return invocation.proceed();
        }
        List<EncryptionConfiguration> foundConfigurationList = this.encryptionConfigurationList.stream().filter(configuration -> methodName.equals(configuration.getMethodToEncryptDecrypt()) || anyMethodName.equals(configuration.getMethodToEncryptDecrypt())).collect(Collectors.toList());
        if (!foundConfigurationList.isEmpty()) {
            EncryptionContext context;
            EncryptionConfiguration decryptArgumentsConfiguration = this.findEncryptionConfigurationForOperation(foundConfigurationList, EncryptionOperation.DECRYPT);
            EncryptionConfiguration encryptResultConfiguration = this.findEncryptionConfigurationForOperation(foundConfigurationList, EncryptionOperation.ENCRYPT);
            Object[] arguments = invocation.getArguments();
            Object[] decryptedArguments = null;
            if (decryptArgumentsConfiguration != null) {
                log.debug("Found decrypt arguments configuration: {} for method: {}", (Object)decryptArgumentsConfiguration, (Object)methodName);
                context = this.createEncryptionContext(methodName, arguments);
                decryptedArguments = this.decryptArguments(context, arguments, decryptArgumentsConfiguration.getPropertyToEncryptDecryptList());
                proxyMethodInvocation.setArguments(decryptedArguments);
            }
            if (encryptResultConfiguration != null) {
                log.debug("Found encrypt result configuration: {} for method: {}", (Object)encryptResultConfiguration, (Object)methodName);
                context = this.createEncryptionContext(methodName, decryptedArguments == null ? arguments : decryptedArguments);
                return this.encryptResult(context, proxyMethodInvocation.proceed(), encryptResultConfiguration.getPropertyToEncryptDecryptList());
            }
        }
        return proxyMethodInvocation.proceed();
    }

    @Override
    protected DataEncryptionService getDataEncryptionService() {
        return this.dataEncryptionService;
    }

    private String methodName(MethodInvocation invocation) {
        return String.format("%s.%s", invocation.getThis().getClass().getName(), invocation.getMethod().getName());
    }

    private String anyClassMethod(MethodInvocation invocation) {
        return String.format("%s.%s", invocation.getThis().getClass().getName(), "*");
    }

    private EncryptionConfiguration findEncryptionConfigurationForOperation(List<EncryptionConfiguration> encryptionConfigurationList, EncryptionOperation encryptionOperation) {
        return encryptionConfigurationList.stream().filter(configuration -> configuration.getEncryptionOperation() == encryptionOperation).findFirst().orElse(null);
    }

    private EncryptionContext createEncryptionContext(String methodName, Object[] arguments) {
        List<Object> argumentList = Arrays.asList(arguments);
        return EncryptionContext.builder().fullyQualifiedMethodName(methodName).methodArguments(argumentList).methodDecryptedArguments(argumentList).build();
    }

    @ConstructorProperties(value={"dataEncryptionService", "encryptionConfigurationList", "ignoredMethodList"})
    @Generated
    public EncryptMethodInterceptor(DataEncryptionService dataEncryptionService, List<EncryptionConfiguration> encryptionConfigurationList, List<String> ignoredMethodList) {
        this.dataEncryptionService = dataEncryptionService;
        this.encryptionConfigurationList = encryptionConfigurationList;
        this.ignoredMethodList = ignoredMethodList;
    }
}

