/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.encrypt.service;

import java.beans.ConstructorProperties;
import java.util.Base64;
import lombok.Generated;
import net.croz.nrich.encrypt.api.service.TextEncryptionService;
import net.croz.nrich.encrypt.exception.EncryptOperationFailedException;
import org.springframework.security.crypto.encrypt.BytesEncryptor;

public class BytesEncryptorTextEncryptService
implements TextEncryptionService {
    private final BytesEncryptor encryptor;
    private final String charset;

    public String encryptText(String textToEncrypt) {
        try {
            byte[] encoded = Base64.getUrlEncoder().encode(this.encryptor.encrypt(textToEncrypt.getBytes(this.charset)));
            return new String(encoded, this.charset);
        }
        catch (Exception exception) {
            throw new EncryptOperationFailedException(String.format("Error occurred during encryption for data: %s", textToEncrypt), exception);
        }
    }

    public String decryptText(String textToDecrypt) {
        try {
            byte[] decoded = Base64.getUrlDecoder().decode(textToDecrypt.getBytes(this.charset));
            return new String(this.encryptor.decrypt(decoded), this.charset);
        }
        catch (Exception exception) {
            throw new EncryptOperationFailedException(String.format("Error occurred during decryption for data: %s", textToDecrypt), exception);
        }
    }

    @ConstructorProperties(value={"encryptor", "charset"})
    @Generated
    public BytesEncryptorTextEncryptService(BytesEncryptor encryptor, String charset) {
        this.encryptor = encryptor;
        this.charset = charset;
    }
}

