/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.encrypt.service;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.encrypt.api.model.EncryptionContext;
import net.croz.nrich.encrypt.api.model.EncryptionOperation;
import net.croz.nrich.encrypt.api.service.DataEncryptionService;
import net.croz.nrich.encrypt.api.service.TextEncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.CollectionUtils;

public class DefaultDataEncryptService
implements DataEncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDataEncryptService.class);
    private final TextEncryptionService textEncryptionService;

    public <T> T encryptData(T data, List<String> pathToEncryptDecryptList, EncryptionContext encryptionContext) {
        return this.encryptDecryptData(data, pathToEncryptDecryptList, encryptionContext, EncryptionOperation.ENCRYPT);
    }

    public <T> T decryptData(T data, List<String> pathToEncryptDecryptList, EncryptionContext encryptionContext) {
        return this.encryptDecryptData(data, pathToEncryptDecryptList, encryptionContext, EncryptionOperation.DECRYPT);
    }

    private <T> T encryptDecryptData(T data, List<String> pathToEncryptDecryptList, EncryptionContext encryptionContext, EncryptionOperation encryptionOperation) {
        if (data == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(pathToEncryptDecryptList)) {
            Object encryptedDecryptedValue = this.encryptDecryptValue(encryptionContext, data, encryptionOperation);
            return (T)(encryptedDecryptedValue == null ? data : encryptedDecryptedValue);
        }
        pathToEncryptDecryptList.forEach(path -> this.executeEncryptionOperation(encryptionContext, data, (String)path, encryptionOperation));
        return data;
    }

    private void executeEncryptionOperation(EncryptionContext encryptionContext, Object object, String targetPath, EncryptionOperation operation) {
        String[] pathList = targetPath.split("\\.");
        if (pathList.length > 1) {
            CharSequence[] remainingPath = Arrays.copyOfRange(pathList, 0, pathList.length - 1);
            this.encryptDecryptNestedValue(encryptionContext, this.getPropertyValueByPath(object, String.join((CharSequence)".", remainingPath)), pathList[pathList.length - 1], operation);
        } else {
            this.encryptDecryptNestedValue(encryptionContext, object, targetPath, operation);
        }
    }

    private void encryptDecryptNestedValue(EncryptionContext encryptionContext, Object objectContainingFieldsToEncryptOrDecrypt, String propertyName, EncryptionOperation operation) {
        if (objectContainingFieldsToEncryptOrDecrypt != null && propertyName != null) {
            if (objectContainingFieldsToEncryptOrDecrypt instanceof Collection) {
                ((Collection)objectContainingFieldsToEncryptOrDecrypt).forEach(value -> this.encryptDecryptValue(encryptionContext, value, propertyName, operation));
            } else if (objectContainingFieldsToEncryptOrDecrypt instanceof Object[]) {
                Arrays.stream((Object[])objectContainingFieldsToEncryptOrDecrypt).forEach(value -> this.encryptDecryptValue(encryptionContext, value, propertyName, operation));
            } else {
                this.encryptDecryptValue(encryptionContext, objectContainingFieldsToEncryptOrDecrypt, propertyName, operation);
            }
        }
    }

    private void encryptDecryptValue(EncryptionContext encryptionContext, Object objectContainingFieldsToEncryptOrDecrypt, String propertyName, EncryptionOperation operation) {
        Object value = this.getPropertyValueByPath(objectContainingFieldsToEncryptOrDecrypt, propertyName);
        Object result = this.encryptDecryptValue(encryptionContext, value, operation);
        if (result == null) {
            return;
        }
        this.setPropertyValueByPath(objectContainingFieldsToEncryptOrDecrypt, propertyName, result);
    }

    private Object encryptDecryptValue(EncryptionContext encryptionContext, Object value, EncryptionOperation operation) {
        if (value instanceof String) {
            String textToEncryptOrDecrypt2 = (String)value;
            return this.encryptDecryptText(encryptionContext, textToEncryptOrDecrypt2, operation);
        }
        if (this.isSupportedCollection(value)) {
            if (((Collection)value).stream().allMatch(String.class::isInstance)) {
                Collection textToEncryptOrDecryptList = (Collection)value;
                Collector collector = value instanceof Set ? Collectors.toSet() : Collectors.toList();
                return textToEncryptOrDecryptList.stream().map(textToEncryptOrDecrypt -> this.encryptDecryptText(encryptionContext, (String)textToEncryptOrDecrypt, operation)).collect(collector);
            }
        }
        if (value instanceof String[]) {
            String[] textToEncryptOrDecryptList = (String[])value;
            return Arrays.stream(textToEncryptOrDecryptList).map(textToEncryptOrDecrypt -> this.encryptDecryptText(encryptionContext, (String)textToEncryptOrDecrypt, operation)).toArray(String[]::new);
        }
        log.warn("Unable to {} property, check if the specified path is correct and if the specified property is a string", (Object)operation.name().toLowerCase());
        return null;
    }

    protected Object getPropertyValueByPath(Object holder, String path) {
        if (holder instanceof Map) {
            return ((Map)holder).get(path);
        }
        try {
            return PropertyAccessorFactory.forDirectFieldAccess((Object)holder).getPropertyValue(path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected void setPropertyValueByPath(Object holder, String path, Object value) {
        if (holder instanceof Map) {
            ((Map)holder).put(path, value);
        } else {
            PropertyAccessorFactory.forDirectFieldAccess((Object)holder).setPropertyValue(path, value);
        }
    }

    private boolean isSupportedCollection(Object value) {
        return value instanceof List || value instanceof Set;
    }

    private String encryptDecryptText(EncryptionContext encryptionContext, String text, EncryptionOperation operation) {
        log.debug("Starting encryption operation: {} for method: {}", (Object)operation.name(), (Object)encryptionContext.getFullyQualifiedMethodName());
        return operation == EncryptionOperation.ENCRYPT ? this.textEncryptionService.encryptText(text) : this.textEncryptionService.decryptText(text);
    }

    @ConstructorProperties(value={"textEncryptionService"})
    @Generated
    public DefaultDataEncryptService(TextEncryptionService textEncryptionService) {
        this.textEncryptionService = textEncryptionService;
    }
}

