/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.excel.converter;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.croz.nrich.excel.api.converter.CellValueConverter;
import net.croz.nrich.excel.api.model.CellHolder;
import org.springframework.core.annotation.Order;

@Order
public class DefaultCellValueConverter
implements CellValueConverter {
    private final List<ConverterHolder> converterHolderList = this.initializeConverterList();

    public void setCellValue(CellHolder cell, Object value) {
        Optional.ofNullable(this.findConverter(value)).ifPresent(converterHolder -> ((ConverterHolder)converterHolder).setCellValueFunction.accept(cell, value));
    }

    public boolean supports(CellHolder cell, Object value) {
        return this.findConverter(value) != null;
    }

    private List<ConverterHolder> initializeConverterList() {
        return Arrays.asList(new ConverterHolder(Date.class, CellHolder::setCellValue), new ConverterHolder(Calendar.class, CellHolder::setCellValue), new ConverterHolder(Instant.class, (cell, value) -> cell.setCellValue((Object)new Date(((Instant)value).toEpochMilli()))), new ConverterHolder(LocalDate.class, CellHolder::setCellValue), new ConverterHolder(LocalDateTime.class, CellHolder::setCellValue), new ConverterHolder(ZonedDateTime.class, (cell, value) -> cell.setCellValue((Object)((ZonedDateTime)value).toLocalDateTime())), new ConverterHolder(OffsetDateTime.class, (cell, value) -> cell.setCellValue((Object)((OffsetDateTime)value).toLocalDateTime())), new ConverterHolder(Short.class, (cell, value) -> cell.setCellValue((Object)((Number)value).longValue())), new ConverterHolder(Integer.class, (cell, value) -> cell.setCellValue((Object)((Number)value).longValue())), new ConverterHolder(Long.class, (cell, value) -> cell.setCellValue((Object)((Number)value).longValue())), new ConverterHolder(BigDecimal.class, (cell, value) -> cell.setCellValue((Object)((Number)value).doubleValue())), new ConverterHolder(Float.class, (cell, value) -> cell.setCellValue((Object)((Number)value).doubleValue())), new ConverterHolder(Double.class, (cell, value) -> cell.setCellValue((Object)((Number)value).doubleValue())));
    }

    private ConverterHolder findConverter(Object value) {
        if (value == null) {
            return null;
        }
        return this.converterHolderList.stream().filter(converterHolder -> converterHolder.getType().isAssignableFrom(value.getClass())).findFirst().orElse(null);
    }

    public static class ConverterHolder {
        private final Class<?> type;
        private final BiConsumer<CellHolder, Object> setCellValueFunction;

        @ConstructorProperties(value={"type", "setCellValueFunction"})
        @Generated
        public ConverterHolder(Class<?> type, BiConsumer<CellHolder, Object> setCellValueFunction) {
            this.type = type;
            this.setCellValueFunction = setCellValueFunction;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public BiConsumer<CellHolder, Object> getSetCellValueFunction() {
            return this.setCellValueFunction;
        }
    }
}

