/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.excel.generator;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import net.croz.nrich.excel.api.converter.CellValueConverter;
import net.croz.nrich.excel.api.generator.ExcelReportGenerator;
import net.croz.nrich.excel.api.generator.ExcelReportGeneratorFactory;
import net.croz.nrich.excel.api.model.TypeDataFormat;
import net.croz.nrich.excel.api.request.CreateReportGeneratorRequest;
import net.croz.nrich.excel.generator.PoiExcelReportGenerator;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class PoiExcelReportGeneratorFactory
implements ExcelReportGeneratorFactory {
    private final ResourceLoader resourceLoader;
    private final List<CellValueConverter> cellValueConverterList;
    private final List<TypeDataFormat> typeDataFormatList;

    public ExcelReportGenerator createReportGenerator(CreateReportGeneratorRequest request) {
        Assert.isTrue((request.getOutputStream() != null ? 1 : 0) != 0, (String)"OutputStream cannot be null");
        Assert.hasText((String)request.getTemplatePath(), (String)"Template path cannot be null");
        Assert.isTrue((request.getFirstRowIndex() >= 0 ? 1 : 0) != 0, (String)"Row index must be greater or equal to 0");
        InputStream template = this.resolveTemplate(request.getTemplatePath());
        return new PoiExcelReportGenerator(this.cellValueConverterList, request.getOutputStream(), template, request.getTemplateVariableList(), this.typeDataFormatList, request.getColumnDataFormatList(), request.getFirstRowIndex());
    }

    private InputStream resolveTemplate(String templatePath) {
        return this.resourceLoader.getResource(templatePath).getInputStream();
    }

    @ConstructorProperties(value={"resourceLoader", "cellValueConverterList", "typeDataFormatList"})
    @Generated
    public PoiExcelReportGeneratorFactory(ResourceLoader resourceLoader, List<CellValueConverter> cellValueConverterList, List<TypeDataFormat> typeDataFormatList) {
        this.resourceLoader = resourceLoader;
        this.cellValueConverterList = cellValueConverterList;
        this.typeDataFormatList = typeDataFormatList;
    }
}

