/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.excel.service;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import net.croz.nrich.excel.api.generator.ExcelReportGenerator;
import net.croz.nrich.excel.api.generator.ExcelReportGeneratorFactory;
import net.croz.nrich.excel.api.model.MultiRowDataProvider;
import net.croz.nrich.excel.api.request.CreateExcelReportRequest;
import net.croz.nrich.excel.api.request.CreateReportGeneratorRequest;
import net.croz.nrich.excel.api.service.ExcelReportService;
import org.springframework.util.Assert;

public class DefaultExcelReportService
implements ExcelReportService {
    private final ExcelReportGeneratorFactory excelReportGeneratorFactory;

    public void createExcelReport(CreateExcelReportRequest request) {
        Object[][] rowBatchData;
        Assert.notNull((Object)request.getMultiRowDataProvider(), (String)"Row data provider cannot be null!");
        Assert.isTrue((request.getBatchSize() > 0 ? 1 : 0) != 0, (String)"Batch size must be greater than zero!");
        CreateReportGeneratorRequest createReportGeneratorRequest = this.toCreateReportGeneratorRequest(request);
        ExcelReportGenerator excelReportGenerator = this.excelReportGeneratorFactory.createReportGenerator(createReportGeneratorRequest);
        MultiRowDataProvider multiRowDataProvider = request.getMultiRowDataProvider();
        int limit = request.getBatchSize();
        int start = 0;
        while ((rowBatchData = multiRowDataProvider.resolveMultiRowData(start, limit)) != null && rowBatchData.length != 0) {
            Arrays.stream(rowBatchData).filter(Objects::nonNull).forEach(arg_0 -> ((ExcelReportGenerator)excelReportGenerator).writeRowData(arg_0));
            start += limit;
        }
        excelReportGenerator.flush();
    }

    private CreateReportGeneratorRequest toCreateReportGeneratorRequest(CreateExcelReportRequest reportRequest) {
        return CreateReportGeneratorRequest.builder().columnDataFormatList(reportRequest.getColumnDataFormatList()).firstRowIndex(reportRequest.getFirstRowIndex()).outputStream(reportRequest.getOutputStream()).templatePath(reportRequest.getTemplatePath()).templateVariableList(reportRequest.getTemplateVariableList()).build();
    }

    @ConstructorProperties(value={"excelReportGeneratorFactory"})
    @Generated
    public DefaultExcelReportService(ExcelReportGeneratorFactory excelReportGeneratorFactory) {
        this.excelReportGeneratorFactory = excelReportGeneratorFactory;
    }
}

