/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.formconfiguration.service;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.model.ConstrainedProperty;
import net.croz.nrich.formconfiguration.api.model.ConstrainedPropertyClientValidatorConfiguration;
import net.croz.nrich.formconfiguration.api.service.ConstrainedPropertyValidatorConverterService;
import net.croz.nrich.formconfiguration.service.FieldErrorMessageResolverService;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;

@Order
public class DefaultConstrainedPropertyValidatorConverterService
implements ConstrainedPropertyValidatorConverterService {
    private final FieldErrorMessageResolverService fieldErrorMessageResolverService;

    public List<ConstrainedPropertyClientValidatorConfiguration> convert(ConstrainedProperty constrainedProperty) {
        String message = this.fieldErrorMessageResolverService.resolveErrorMessage(constrainedProperty, LocaleContextHolder.getLocale());
        ConstrainedPropertyClientValidatorConfiguration validator = new ConstrainedPropertyClientValidatorConfiguration(constrainedProperty.getConstraintName(), constrainedProperty.getConstraintArgumentMap(), message);
        return Collections.singletonList(validator);
    }

    public boolean supports(ConstrainedProperty constrainedProperty) {
        return true;
    }

    @ConstructorProperties(value={"fieldErrorMessageResolverService"})
    @Generated
    public DefaultConstrainedPropertyValidatorConverterService(FieldErrorMessageResolverService fieldErrorMessageResolverService) {
        this.fieldErrorMessageResolverService = fieldErrorMessageResolverService;
    }
}

