/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.formconfiguration.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.croz.nrich.formconfiguration.api.annotation.FormValidationConfiguration;
import net.croz.nrich.formconfiguration.api.service.FormConfigurationAnnotationResolvingService;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class DefaultFormConfigurationAnnotationResolvingService
implements FormConfigurationAnnotationResolvingService {
    public Map<String, Class<?>> resolveFormConfigurations(List<String> packageList) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(FormValidationConfiguration.class));
        List<String> resolvedPackageList = Optional.ofNullable(packageList).orElse(Collections.emptyList());
        HashMap result = new HashMap();
        resolvedPackageList.forEach(basePackage -> {
            Map<String, Class<?>> packageResult = this.findAnnotatedClassesInPackage(scanner, (String)basePackage);
            packageResult.forEach(result::putIfAbsent);
        });
        return result;
    }

    private Map<String, Class<?>> findAnnotatedClassesInPackage(ClassPathScanningCandidateComponentProvider scanner, String basePackage) {
        return scanner.findCandidateComponents(basePackage).stream().filter(beanDefinition -> StringUtils.hasText((String)beanDefinition.getBeanClassName())).map(beanDefinition -> this.toClass(beanDefinition.getBeanClassName())).collect(Collectors.toMap(type -> type.getAnnotation(FormValidationConfiguration.class).value(), Function.identity()));
    }

    private Class<?> toClass(String className) {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }
}

