/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.formconfiguration.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.model.ConstrainedProperty;
import net.croz.nrich.formconfiguration.api.model.ConstrainedPropertyClientValidatorConfiguration;
import net.croz.nrich.formconfiguration.api.model.ConstrainedPropertyConfiguration;
import net.croz.nrich.formconfiguration.api.model.FormConfiguration;
import net.croz.nrich.formconfiguration.api.service.ConstrainedPropertyValidatorConverterService;
import net.croz.nrich.formconfiguration.api.service.FormConfigurationService;
import net.croz.nrich.javascript.api.service.JavaToJavascriptTypeConversionService;
import org.springframework.cache.annotation.Cacheable;

public class DefaultFormConfigurationService
implements FormConfigurationService {
    private static final String PREFIX_FORMAT = "%s.%s";
    private final Validator validator;
    private final Map<String, Class<?>> formIdConstraintHolderMap;
    private final List<ConstrainedPropertyValidatorConverterService> constraintConverterServiceList;
    private final JavaToJavascriptTypeConversionService javaToJavascriptTypeConversionService;

    @Cacheable(value={"nrich.formConfiguration.cache"}, key="'all-forms-' + T(org.springframework.context.i18n.LocaleContextHolder).locale.toLanguageTag()")
    public List<FormConfiguration> fetchFormConfigurationList() {
        return this.formIdConstraintHolderMap.keySet().stream().map(this::resolveFormConfiguration).collect(Collectors.toList());
    }

    @Cacheable(value={"nrich.formConfiguration.cache"}, key="#formIdList.hashCode() + T(org.springframework.context.i18n.LocaleContextHolder).locale.toLanguageTag()")
    public List<FormConfiguration> fetchFormConfigurationList(List<String> formIdList) {
        return formIdList.stream().map(this::resolveFormConfiguration).collect(Collectors.toList());
    }

    private FormConfiguration resolveFormConfiguration(String formId) {
        Class<?> validationDefinitionHolder = Optional.ofNullable(this.formIdConstraintHolderMap.get(formId)).orElseThrow(() -> new IllegalArgumentException(String.format("Form id: %s is not registered", formId)));
        List<ConstrainedPropertyConfiguration> propertyConfigurationList = this.recursiveResolveFieldConfiguration(validationDefinitionHolder, new ArrayList<ConstrainedPropertyConfiguration>(), null);
        return new FormConfiguration(formId, propertyConfigurationList);
    }

    private List<ConstrainedPropertyConfiguration> recursiveResolveFieldConfiguration(Class<?> type, List<ConstrainedPropertyConfiguration> constrainedPropertyConfigurationList, String prefix) {
        BeanDescriptor constraintBeanDescriptor = this.validator.getConstraintsForClass(type);
        Set constraintPropertyList = constraintBeanDescriptor.getConstrainedProperties();
        Optional.ofNullable(constraintPropertyList).orElse(Collections.emptySet()).forEach(propertyDescriptor -> {
            String propertyName = propertyDescriptor.getPropertyName();
            String propertyPath = prefix == null ? propertyName : String.format(PREFIX_FORMAT, prefix, propertyName);
            List<ConstrainedPropertyClientValidatorConfiguration> constrainedPropertyClientValidatorConfigurationList = this.resolvePropertyValidatorList(type, propertyPath, (PropertyDescriptor)propertyDescriptor);
            if (!constrainedPropertyClientValidatorConfigurationList.isEmpty()) {
                Class propertyType = propertyDescriptor.getElementClass();
                String javascriptType = this.javaToJavascriptTypeConversionService.convert(propertyType);
                constrainedPropertyConfigurationList.add(new ConstrainedPropertyConfiguration(propertyPath, propertyType, javascriptType, constrainedPropertyClientValidatorConfigurationList));
            }
            if (this.shouldResolveConstraintListForType((PropertyDescriptor)propertyDescriptor)) {
                this.recursiveResolveFieldConfiguration(propertyDescriptor.getElementClass(), constrainedPropertyConfigurationList, propertyName);
            }
        });
        return constrainedPropertyConfigurationList;
    }

    private boolean shouldResolveConstraintListForType(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isCascaded();
    }

    private List<ConstrainedPropertyClientValidatorConfiguration> resolvePropertyValidatorList(Class<?> parentType, String propertyPath, PropertyDescriptor propertyDescriptor) {
        Set constraintDescriptorList = propertyDescriptor.getConstraintDescriptors();
        return constraintDescriptorList.stream().map(constraintDescriptor -> this.convertProperty((ConstraintDescriptor<?>)constraintDescriptor, parentType, propertyPath, propertyDescriptor)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ConstrainedPropertyClientValidatorConfiguration> convertProperty(ConstraintDescriptor<?> constraintDescriptor, Class<?> parentType, String propertyPath, PropertyDescriptor propertyDescriptor) {
        ConstrainedProperty constrainedProperty = ConstrainedProperty.builder().constraintDescriptor(constraintDescriptor).parentType(parentType).path(propertyPath).name(propertyDescriptor.getPropertyName()).type(propertyDescriptor.getElementClass()).build();
        ConstrainedPropertyValidatorConverterService converterService = this.constraintConverterServiceList.stream().filter(converter -> converter.supports(constrainedProperty)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No converter found for constrained property: %s", constrainedProperty)));
        return converterService.convert(constrainedProperty);
    }

    @ConstructorProperties(value={"validator", "formIdConstraintHolderMap", "constraintConverterServiceList", "javaToJavascriptTypeConversionService"})
    @Generated
    public DefaultFormConfigurationService(Validator validator, Map<String, Class<?>> formIdConstraintHolderMap, List<ConstrainedPropertyValidatorConverterService> constraintConverterServiceList, JavaToJavascriptTypeConversionService javaToJavascriptTypeConversionService) {
        this.validator = validator;
        this.formIdConstraintHolderMap = formIdConstraintHolderMap;
        this.constraintConverterServiceList = constraintConverterServiceList;
        this.javaToJavascriptTypeConversionService = javaToJavascriptTypeConversionService;
    }
}

