/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.formconfiguration.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.model.ConstrainedProperty;
import net.croz.nrich.formconfiguration.service.FieldErrorMessageResolverService;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.StringUtils;

public class MessageSourceFieldErrorMessageResolverService
implements FieldErrorMessageResolverService {
    private final MessageSource messageSource;

    @Override
    public String resolveErrorMessage(ConstrainedProperty constrainedProperty, Locale locale) {
        List<String> messageCodeList = this.resolveConstraintMessageCodeList(constrainedProperty);
        Object[] argumentList = this.convertArraysInArgumentList(constrainedProperty.getConstraintArgumentList());
        String message = constrainedProperty.getConstraintMessage();
        DefaultMessageSourceResolvable defaultMessageSourceResolvable = new DefaultMessageSourceResolvable(messageCodeList.toArray(new String[0]), argumentList, message);
        return this.messageSource.getMessage((MessageSourceResolvable)defaultMessageSourceResolvable, locale);
    }

    private List<String> resolveConstraintMessageCodeList(ConstrainedProperty constrainedProperty) {
        String constraintOwningClassName = StringUtils.uncapitalize((String)constrainedProperty.getParentType().getName());
        String constraintOwningClassShortName = StringUtils.uncapitalize((String)constrainedProperty.getParentType().getSimpleName());
        String constraintPropertyName = constrainedProperty.getName();
        String constraintName = constrainedProperty.getConstraintName();
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(this.resolveMessageCode("%s.%s.client.%s.invalid", constraintOwningClassName, constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("%s.%s.client.%s.invalid", constraintOwningClassShortName, constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("%s.%s.%s.invalid", constraintOwningClassName, constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("%s.%s.%s.invalid", constraintOwningClassShortName, constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("client.%s.%s.invalid", constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("%s.%s.invalid", constraintPropertyName, constraintName));
        codeList.add(this.resolveMessageCode("client.%s.invalid", constraintName));
        codeList.add(this.resolveMessageCode("%s.invalid", constraintName));
        return codeList;
    }

    private String resolveMessageCode(String messageFormat, String ... argumentList) {
        return String.format(messageFormat, argumentList);
    }

    private Object[] convertArraysInArgumentList(Object[] argumentList) {
        if (argumentList == null) {
            return new Object[0];
        }
        return Arrays.stream(argumentList).map(value -> value instanceof Object[] ? this.convertToString((Object[])value) : value).toArray();
    }

    private String convertToString(Object[] value) {
        return Arrays.toString(value).replace('[', ' ').replace(']', ' ').trim();
    }

    @ConstructorProperties(value={"messageSource"})
    @Generated
    public MessageSourceFieldErrorMessageResolverService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

