/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.javascript.converter;

import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.croz.nrich.javascript.api.converter.JavaToJavascriptTypeConverter;
import net.croz.nrich.javascript.api.model.JavascriptType;
import org.springframework.core.annotation.Order;

@Order
public class DefaultJavaToJavascriptTypeConverter
implements JavaToJavascriptTypeConverter {
    private static final Map<Class<?>, JavascriptType> CLASS_JAVASCRIPT_TYPE_MAP = new HashMap();

    public boolean supports(Class<?> type) {
        return true;
    }

    public String convert(Class<?> type) {
        return CLASS_JAVASCRIPT_TYPE_MAP.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(type)).findFirst().map(Map.Entry::getValue).orElse(JavascriptType.OBJECT).name().toLowerCase(Locale.ROOT);
    }

    static {
        CLASS_JAVASCRIPT_TYPE_MAP.put(Boolean.class, JavascriptType.BOOLEAN);
        CLASS_JAVASCRIPT_TYPE_MAP.put(String.class, JavascriptType.STRING);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Character.class, JavascriptType.STRING);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Calendar.class, JavascriptType.DATE);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Date.class, JavascriptType.DATE);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Temporal.class, JavascriptType.DATE);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Number.class, JavascriptType.NUMBER);
        CLASS_JAVASCRIPT_TYPE_MAP.put(Enum.class, JavascriptType.STRING);
    }
}

