/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.javascript.service;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.croz.nrich.javascript.api.converter.JavaToJavascriptTypeConverter;
import net.croz.nrich.javascript.api.model.JavascriptType;
import net.croz.nrich.javascript.api.service.JavaToJavascriptTypeConversionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultJavaToJavascriptTypeConversionService
implements JavaToJavascriptTypeConversionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJavaToJavascriptTypeConversionService.class);
    private static final String DEFAULT_TYPE = JavascriptType.OBJECT.name().toLowerCase(Locale.ROOT);
    private final List<JavaToJavascriptTypeConverter> javaToJavascriptTypeConverterList;

    public String convert(Class<?> type) {
        if (CollectionUtils.isEmpty(this.javaToJavascriptTypeConverterList)) {
            log.warn("No converts registered for converting between Java to Javascript type, consider defining a bean of {} type", (Object)JavaToJavascriptTypeConverter.class.getName());
            return DEFAULT_TYPE;
        }
        return this.javaToJavascriptTypeConverterList.stream().filter(converter -> converter.supports(type)).findFirst().map(converter -> converter.convert(type)).orElse(DEFAULT_TYPE);
    }

    @ConstructorProperties(value={"javaToJavascriptTypeConverterList"})
    @Generated
    public DefaultJavaToJavascriptTypeConversionService(List<JavaToJavascriptTypeConverter> javaToJavascriptTypeConverterList) {
        this.javaToJavascriptTypeConverterList = javaToJavascriptTypeConverterList;
    }
}

