/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.logging.service;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.logging.api.model.LoggingLevel;
import net.croz.nrich.logging.api.model.LoggingVerbosityLevel;
import net.croz.nrich.logging.api.service.LoggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;

public class Slf4jLoggingService
implements LoggingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Slf4jLoggingService.class);
    private final MessageSource messageSource;

    public void logInternalException(Exception exception, Map<String, ?> exceptionAuxiliaryData) {
        LoggingVerbosityLevel configuredLoggingVerbosityLevelForException = this.fetchConfiguredLoggingVerbosityLevelForException(exception);
        if (configuredLoggingVerbosityLevelForException == LoggingVerbosityLevel.COMPACT) {
            this.logInternalExceptionAtCompactVerbosityLevel(exception, exceptionAuxiliaryData);
        } else if (configuredLoggingVerbosityLevelForException == LoggingVerbosityLevel.FULL) {
            this.logInternalExceptionAtFullVerbosityLevel(exception, exceptionAuxiliaryData);
        }
    }

    public void logInternalExceptionAtCompactVerbosityLevel(Exception exception, Map<String, ?> exceptionAuxiliaryData) {
        String exceptionAuxiliaryDataMessage = this.prepareExceptionAuxiliaryDataMessage(exceptionAuxiliaryData, ", ");
        String className = this.fetchClassNameForException(exception);
        String message = this.fetchMessageForException(exception);
        String logMessage = String.format("Exception occurred: [className: %s], message: %s, additionalInfoData: %s", className, message, exceptionAuxiliaryDataMessage);
        LoggingLevel loggingLevel = this.fetchConfiguredLoggingLevelForException(className);
        this.logOnLevel(loggingLevel, logMessage);
    }

    public void logInternalExceptionAtFullVerbosityLevel(Exception exception, Map<String, ?> exceptionAuxiliaryData) {
        String className = this.fetchClassNameForException(exception);
        String message = this.fetchMessageForException(exception);
        String exceptionInfoString = String.format("Exception occurred: [className: %s], message: %s", className, message);
        LoggingLevel loggingLevel = this.fetchConfiguredLoggingLevelForException(className);
        this.logOnLevel(loggingLevel, "Exception occurred", exception);
        String exceptionAuxiliaryDataMessage = this.prepareExceptionAuxiliaryDataMessage(exceptionAuxiliaryData, System.lineSeparator());
        String exceptionLogMessage = String.format("---------------- Information about above exception %s: %s ----------------", exceptionInfoString, exceptionAuxiliaryDataMessage);
        this.logOnLevel(loggingLevel, exceptionLogMessage);
    }

    public void logExternalException(String exceptionClassName, String exceptionMessage, Map<String, ?> exceptionAuxiliaryData) {
        if (exceptionClassName == null) {
            return;
        }
        String exceptionAuxiliaryDataMessage = this.prepareExceptionAuxiliaryDataMessage(exceptionAuxiliaryData, System.lineSeparator());
        String exceptionInfoString = String.format("Exception occurred: [className: %s], message: %s", exceptionClassName, exceptionMessage);
        String exceptionLogMessage = String.format("---------------- Information about above exception %s: %s ----------------", exceptionInfoString, exceptionAuxiliaryDataMessage);
        LoggingLevel loggingLevel = this.fetchConfiguredLoggingLevelForException(exceptionClassName);
        this.logOnLevel(loggingLevel, exceptionLogMessage);
    }

    private LoggingVerbosityLevel fetchConfiguredLoggingVerbosityLevelForException(Exception exception) {
        MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor(this.messageSource);
        String className = this.fetchClassNameForException(exception);
        String messageCode = String.format("%s.loggingVerbosityLevel", className);
        String configuredLoggingVerbosityLevel = messageSourceAccessor.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(new String[]{messageCode}, LoggingVerbosityLevel.FULL.name())).toUpperCase();
        try {
            return LoggingVerbosityLevel.valueOf((String)configuredLoggingVerbosityLevel);
        }
        catch (IllegalArgumentException ignored) {
            log.warn("Unrecognized verbosity level {} defined for {}", (Object)configuredLoggingVerbosityLevel, (Object)messageCode);
            return LoggingVerbosityLevel.FULL;
        }
    }

    private LoggingLevel fetchConfiguredLoggingLevelForException(String exceptionClassName) {
        MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor(this.messageSource);
        String messageCode = String.format("%s.loggingLevel", exceptionClassName);
        String loggingLevel = messageSourceAccessor.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(new String[]{messageCode}, LoggingLevel.ERROR.name())).toUpperCase();
        try {
            return LoggingLevel.valueOf((String)loggingLevel);
        }
        catch (IllegalArgumentException ignored) {
            log.warn("Unrecognized level {} defined for {}", (Object)loggingLevel, (Object)messageCode);
            return LoggingLevel.ERROR;
        }
    }

    private String fetchClassNameForException(Exception exception) {
        if (exception == null) {
            return "";
        }
        return exception.getClass().getName();
    }

    private String fetchMessageForException(Exception exception) {
        if (exception == null) {
            return "";
        }
        return exception.getMessage();
    }

    private String prepareExceptionAuxiliaryDataMessage(Map<String, ?> exceptionAuxiliaryData, String separator) {
        if (exceptionAuxiliaryData == null) {
            return "";
        }
        return exceptionAuxiliaryData.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(separator));
    }

    private void logOnLevel(LoggingLevel loggingLevel, String message) {
        this.logOnLevel(loggingLevel, message, null);
    }

    private void logOnLevel(LoggingLevel loggingLevel, String message, Exception exception) {
        switch (loggingLevel) {
            case DEBUG: {
                log.debug(message, (Throwable)exception);
                break;
            }
            case INFO: {
                log.info(message, (Throwable)exception);
                break;
            }
            case WARN: {
                log.warn(message, (Throwable)exception);
                break;
            }
            case ERROR: {
                log.error(message, (Throwable)exception);
            }
        }
    }

    @ConstructorProperties(value={"messageSource"})
    @Generated
    public Slf4jLoggingService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

